<?php 
##
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: file.func.php 16 2013-01-31 02:50:02Z along $
#
#	Copyright (C) 2008-2013 PHPDisk Team. All Rights Reserved.
#
##

if(!defined('IN_PHPDISK')) {
	exit('[PHPDisk] Access Denied');
}

function read_file($f) {
	if (file_exists($f)) {
		if (PHP_VERSION >= "4.3.0") return file_get_contents($f);
		$fp = fopen($f,"rb");
		$fsize = filesize($f);
		$c = fread($fp, $fsize);
		fclose($fp);
		return $c;
	} else{
		exit("<b>$f</b> does not exist!");
	}
}

function write_file($f,$str,$mode = 'wb') {
	$fp = fopen($f,$mode);
	if (!$fp) {
		exit("Can not open file <b>$f</b> .code:1");
	}
	if(is_writable($f)){
		if(!fwrite($fp,$str)){
			exit("Can not write file <b>$f</b> .code:2");
		}
	}else{
		exit("Can not write file <b>$f</b> .code:3");
	}
	fclose($fp);
}
function upload_file($source, $target) {
	if (function_exists('move_uploaded_file') && @move_uploaded_file($source, $target)) {
		@chmod($target, 0666);
		return $target;
	} elseif (@copy($source, $target)) {
		@chmod($target, 0666);
		return $target;
	} elseif (@is_readable($source)) {
		if ($fp = @fopen($source,'rb')) {
			@flock($fp,2);
			$filedata = @fread($fp,@filesize($source));
			@fclose($fp);
		}
		if ($fp = @fopen($target, 'wb')) {
			@flock($fp, 2);
			@fwrite($fp, $filedata);
			@fclose($fp);
			@chmod ($target, 0666);
			return $target;
		} else {
			return false;
		}
	}
}
function tree_path($folder_id,$in_box=0){
	global $_G;
	$str = '';
	$q = DB::query("select parent_id,folder_name,folder_id from ".DB::table('phpdisk_folders')." where folder_id='$folder_id' and userid='{$_G[uid]}'");
	if($rs = DB::fetch($q)){
		if($rs['parent_id']!=0){
			$str .= tree_path($rs['parent_id'],$in_box);
		}
		if($in_box){
			$str .= '<a href="###" onclick="top.document.location=\''.$_G[siteurl].urr("phpdisk","mod=mydisk&folder_id=$folder_id").'\'" class="myBox_close"><img src="source/plugin/phpdisk/images/folder_open.gif" align="absmiddle" border="0" />'.$rs['folder_name'].'</a>&nbsp;&raquo;&nbsp;';
		}else{
			$str .= '<a href="'.urr("phpdisk","mod=mydisk&folder_id=$folder_id").'"><img src="source/plugin/phpdisk/images/folder_open.gif" align="absmiddle" border="0" />'.$rs['folder_name'].'</a>&nbsp;&raquo;&nbsp;';
		}
	}
	unset($rs);
	return $str;
}


?>