<?php
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Site: http://www.phpdisk.com
#
#	$Id: global.func.php 23 2013-04-03 02:58:38Z along $
#
#	Copyright (C) 2008-2013 PHPDisk Team. All Rights Reserved.
#
*/
if(!defined('IN_PHPDISK')) {
	exit('[PHPDisk] Access Denied');
}
function template_echo($tpl,$tpl_dir,$app='',$is_admin_tpl=0){
	if($app){
		$tpl_cache_dir = PHPDISK_ROOT."system/plugins/$app/";
		$tpl_src_dir = PHPDISK_ROOT."plugins/$app/";
	}else{
		$tpl_cache_dir = $tpl_cache_dir_tmp = PHPDISK_ROOT.'system/'.$tpl_dir;
		$tpl_src_dir = PHPDISK_ROOT.$tpl_dir;
		$tpl_default_dir = PHPDISK_ROOT.'templates/default/';
		$admin_tpl_dir = PHPDISK_ROOT.'templates/admin/';
	}
	if(strpos($tpl,'/')!==false){
		$tpl_cache_dir_tmp = $tpl_cache_dir_tmp.substr($tpl,0,strlen($tpl)-strlen(strrchr($tpl,'/'))).'/';
	}
	make_dir($tpl_cache_dir_tmp);
	make_dir($tpl_cache_dir);

	$tpl_cache_file = $tpl_cache_dir.$tpl.'.tpl.php';
	$tpl_src_file = $tpl_src_dir.$tpl.'.tpl.php';
	if(!$app){
		if($is_admin_tpl && !file_exists($tpl_src_file)){
			$tpl_src_file = $admin_tpl_dir.$tpl.'.tpl.php';
		}elseif(!file_exists($tpl_src_file)){
			$tpl_src_file = $tpl_default_dir.$tpl.'.tpl.php';
		}
	}
	if(@filemtime($tpl_cache_file) < @filemtime($tpl_src_file)){
		write_file($tpl_cache_file,template_parse($tpl_src_file));
		return $tpl_cache_file;
	}
	if(file_exists($tpl_cache_file)){
		return $tpl_cache_file;
	}else{
		$str = strrchr($tpl_cache_file,'/');
		$str = substr($str,1,strlen($str));
		die("PHPDisk Template: <b>$tpl_dir$tpl_cache_file</b> not Exists!");
	}

}

function template_parse($tpl){
	global $user_tpl_dir;
	if(!file_exists($tpl)){
		exit('Template ['.$tpl.'] not exists!');
	}
	$str = read_file($tpl);
	$str = preg_replace("/\<\!\-\-\#include (.+?)\#\-\-\>/si","<?php require_once template_echo('\\1','$user_tpl_dir'); ?>", $str);
	$str = preg_replace("/\<\!\-\-\#(.+?)\#\-\-\>/si","<?php \\1 ?>", $str);
	$str = preg_replace("/\{([A-Z_]+)\}/","<?=\\1?>",$str);
	$str = preg_replace("/\{(\\\$[a-z0-9_\'\"\[\]]+)\}/si", "<?=\\1?>", $str);
	$str = preg_replace("/\{\<\?\=(\\\$[a-z0-9_\'\"\[\]]+)\?\>\}/si","{\\1}",$str);
	$str = preg_replace("/\{\#(.+?)\#\}/si","<?=\\1?>", $str);

	$prefix = "<?php ".LF;
	$prefix .= "// This is PHPDISK auto-generated file. Do NOT modify me.".LF.LF;
	$prefix .= "// Cache Time:".date('Y-m-d H:i:s').LF.LF;
	$prefix .= "!defined('IN_PHPDISK') && exit('[PHPDisk] Access Denied');".LF.LF;
	$prefix .= "?>".LF;

	return $prefix.$str;
}
function file_icon($ext,$fd = 'filetype',$align='absmiddle'){
	$icon = PHPDISK_ROOT."images/{$fd}/".$ext.".gif";
	if(file_exists($icon)){
		$img = "<img src='".PHPDISK_PLUGIN_DIR."/images/{$fd}/{$ext}.gif' align='{$align}' border='0' />";
	}else{
		$img = "<img src='".PHPDISK_PLUGIN_DIR."/images/{$fd}/file.gif' align='{$align}' border='0' />";
	}
	return $img;
}
function pd_encode($txt, $operation = 'ENCODE',$key = ''){
	global $settings;
	$key = $key ? $key : ($settings[encrypt_key] ? $settings[encrypt_key] : 'PHPDisk=Rc9o3');
	if($operation == 'DECODE'){
		$txt = encrypt_key(base64_decode($txt), $key);
		$tmp = '';
		for ($i = 0; $i < strlen($txt); $i++) {
			$tmp .= $txt[$i] ^ $txt[++$i];
		}
		return $tmp;
	}else{
		srand((double)microtime() * 1000000);
		$encrypt_key = md5(rand(0, 32000));
		$ctr = 0;
		$tmp = '';
		for($i = 0; $i < strlen($txt); $i++) {
			$ctr = $ctr == strlen($encrypt_key) ? 0 : $ctr;
			$tmp .= $encrypt_key[$ctr].($txt[$i] ^ $encrypt_key[$ctr++]);
		}
		return base64_encode(encrypt_key($tmp, $key));
	}
}
function encrypt_key($txt, $key) {
	$md5_key = md5($key);
	$ctr = 0;
	$tmp = '';
	for($i = 0; $i < strlen($txt); $i++) {
		$ctr = $ctr == strlen($md5_key) ? 0 : $ctr;
		$tmp .= $txt[$i] ^ $md5_key[$ctr++];
	}
	return $tmp;
}
function defend_xss($val){
	return is_array($val) ? $val : htmlspecialchars($val);
}
function gpc($name,$w = 'GPC',$default = '',$d_xss=1){
	$i = 0;
	for($i = 0; $i < strlen($w); $i++) {
		if($w[$i] == 'G' && isset($_GET[$name])) return $d_xss ? defend_xss($_GET[$name]) : $_GET[$name];
		if($w[$i] == 'P' && isset($_POST[$name])) return $d_xss ? defend_xss($_POST[$name]) : $_POST[$name];
		if($w[$i] == 'C' && isset($_COOKIE[$name])) return $d_xss ? defend_xss($_COOKIE[$name]) : $_COOKIE[$name];
	}
	return $default;
}
function get_size($s,$u='B',$p=2){
	$us = array('B'=>'K','K'=>'M','M'=>'G','G'=>'T');
	return (($u!=='B')&&(!isset($us[$u]))||($s<1024))?(number_format($s,$p)." $u"):(get_size($s/1024,$us[$u],$p));
}
function get_byte_value($v){
	$v = trim($v);
	$l = strtolower($v[strlen($v) - 1]);
	switch($l){
		case 'g':
			$v *= 1024;

		case 'm':
			$v *= 1024;

		case 'k':
			$v *= 1024;
	}
	return $v;
}
function ifselected($int1,$int2,$type = 'int'){
	if($type == 'int'){
		if(intval($int1) == intval($int2)){
			return ' selected';
		}
	}elseif($type == 'str'){
		if(strval($int1) == strval($int2)){
			return ' selected';
		}
	}
}
function ifchecked($int1,$int2,$type = 'int'){
	if($type == 'int'){
		if(intval($int1) == intval($int2)){
			return ' checked';
		}
	}elseif($type == 'str'){
		if(strval($int1) == strval($int2)){
			return ' checked';
		}
	}
}
function urr($str,$vars){
	global $settings;
	if($settings['open_rewrite']){
		switch($str){

			case 'space':
				parse_str($vars);
				return 'space-'.rawurlencode($username).'.html';
				break;
			case 'phpdisk':
				parse_str($vars);
				if($mod=='view'){
					return "file-$file_id.html";
				}elseif($mod=='down'){
					return "down-$file_id.html";
				}else{
					return $vars ? $str.'.php?'.$vars : $str.'.php';
				}
				break;
			default:
				return $vars ? $str.'.php?'.$vars : $str.'.php';
		}

	}else{
		return $vars ? $str.'.php?'.$vars : $str.'.php';
	}
}
function phpdisk_crtxt(){
	global $auth,$settings;
	$str = base64_decode('PGRpdiBjbGFzcz0icF9jciIgYWxpZ249InJpZ2h0IiB0aXRsZT0iUG93ZXJlZCBieSBQSFBEaXNrIFRlYW0iPjxhIGhyZWY9Imh0dHA6Ly93d3cucGhwZGlzay5jb20vIiBjbGFzcz0idHh0Z3JheSIgdGFyZ2V0PSJfYmxhbmsiPlBIUERpc2sgTWluaSA=').'v'.PHPDISK_VERSION.' '.VERSION_TXT.base64_decode('PC9hPjwvZGl2Pg==');
	echo ($auth[close_version] && $settings[close_version]) ? '' : $str;
}
function form_auth($p_formhash,$formhash){
	if($p_formhash != $formhash){
		exit('phpdisk system error!');
	}
}

function tb_redirect($url,$str,$timeout=2000){
	global $user_tpl_dir;
	if(is_array($str)){
		for($i=0;$i<count($str);$i++){
			$msg .= "<li>".$str[$i]."</li>".LF;
		}
	}else{
		$msg = $str;
	}
	$go_url = $url=='back' ? $url='javascript:history.back();' : $url;
	$rtn = '<link rel="stylesheet" href="'.PHPDISK_PLUGIN_DIR.'/'.$user_tpl_dir.'images/style.css" media="screen"/>'.LF;
	$rtn .= '<script type="text/javascript" src="'.PHPDISK_PLUGIN_DIR.'/includes/js/jquery.js"></script>'.LF;
	$rtn .= '<script type="text/javascript">var jq = jQuery.noConflict();</script>'.LF;
	$rtn .= '<script type="text/javascript" src="'.PHPDISK_PLUGIN_DIR.'/includes/js/jquery.mybox.js"></script>'.LF;
	$rtn .= '<link rel="stylesheet" href="'.PHPDISK_PLUGIN_DIR.'/images/mybox.css" media="screen"/>'.LF;
	$rtn .= '<div class="tb_box_msg" id="tb_box_msg"><ul>'.$msg.'</ul></div>'.LF;
	$rtn .= "<script>".LF;
	$rtn .= "function redirect() {".LF;
	$rtn .= $url=='back' ? '' : 'jq("#tb_box_msg").myBox({timeout:10});'.LF;
	$rtn .= "	self.parent.document.location.href = '$go_url';".LF;
	$rtn .= "}".LF;
	$rtn .= "setTimeout('redirect();', $timeout);".LF;
	$rtn .= "</script>".LF;
	$rtn .= "</body></html>".LF;
	echo $rtn;
}
function redirect($url,$str,$timeout=3000){
	global $user_tpl_dir;
	if(is_array($str)){
		for($i=0;$i<count($str);$i++){
			$msg .= "<li>".$str[$i]."</li>";
		}
	}else{
		$msg = $str;
	}
	$gg_time = $timeout-300;
	$go_url = $url=='back' ? $url='javascript:history.back();' : $url;
	$rtn = '<link rel="stylesheet" href="'.PHPDISK_PLUGIN_DIR.'/'.$user_tpl_dir.'images/style.css" media="screen"/>'.LF;
	$rtn .= '<script type="text/javascript" src="'.PHPDISK_PLUGIN_DIR.'/includes/js/jquery.js"></script>'.LF;
	$rtn .= '<script type="text/javascript">var jq = jQuery.noConflict();</script>'.LF;
	$rtn .= '<script type="text/javascript" src="'.PHPDISK_PLUGIN_DIR.'/includes/js/jquery.mybox.js"></script>'.LF;
	$rtn .= '<link rel="stylesheet" href="'.PHPDISK_PLUGIN_DIR.'/images/mybox.css" media="screen"/>'.LF;
	$rtn .= "<script type=\"text/javascript\">".LF;
	$rtn .= "function redirect_url() {".LF;
	$rtn .= 'jq("#tb_box_msg").myBox({title:"Ϣʾ",show:true,html:"<div class=\'rd_box\'><ul>'.$msg.'</ul></div>",timeout:'.$timeout.'});'.LF;
	$rtn .= "}".LF;
	$rtn .= 'window.onload = redirect_url;'.LF;
	$rtn .= 'function gogo(){'.LF;
	$rtn .= "	self.parent.document.location.href = '$go_url';".LF;
	$rtn .= '}'.LF;
	$rtn .= "setTimeout('gogo();', $gg_time);".LF;
	$rtn .= "</script>".LF;
	echo $rtn;
}
function checklength($str,$min,$max){
	if(!$str || strlen($str) > $max || strlen($str) < $min){
		return true;
	}
}
function checkemail($email) {
	if((strlen($email) > 6) && preg_match("/^[\w\-\.]+@[\w\-\.]+(\.\w+)+$/", $email)){
		return true;
	}else{
		return false;
	}
}

function make_dir($path,$write_file=1){
	if(!is_dir($path)){
		$str = dirname($path);
		if($str){
			make_dir($str.'/');
			@mkdir($path,0777);
			chmod($path,0777);
			if($write_file){
				write_file($path.'index.htm','PHPDisk');
			}
		}
	}
}
function get_child_folders($folder_id){
	$str = $folder_id.',';
	if($folder_id){
		$q = DB::query("select folder_id from ".DB::table('phpdisk_folders')." where parent_id='$folder_id'");
		while($rs = DB::fetch($q)){
			$str .= $rs[folder_id] ? $rs[folder_id].',' : '';
			$q2 = DB::query("select folder_id from ".DB::table('phpdisk_folders')." where parent_id='{$rs[folder_id]}'");
			while($rs2 = DB::fetch($q2)){
				if($rs2[folder_id]){
					$str .= get_child_folders($rs2[folder_id]);
				}
			}
			unset($rs2);
		}
		unset($rs);
	}
	return $str;
}
function get_all_files($folder_ids){
	$str = '';
	if($folder_ids){
		$q = DB::query("select file_id from ".DB::table('phpdisk_files')." where folder_id in ($folder_ids)");
		while($rs = DB::fetch($q)){
			$str .= $rs[file_id].',';
		}
		unset($rs);
	}
	return $str;
}
function login_auth($uid){
	global $_G;
	if(!$uid){
		header('Location: '.$_G[siteurl].'member.php?mod=logging&action=login&referer='.$_G[siteurl].'phpdisk.php');
		exit;
	}
}
function filter_name($name){
	$srh = array('','','@',' ','#','','%','','&','*','','','','','','','','','','','|','\\','/','ؼ','^','','?','!',',','[',']',';',':','"',"'",'');
	return str_replace($srh,'_',$name);
}
function get_down_status($ext){
	$arr = array('exe','zip','rar','7z','mp3','wma','wav','img','wmv','rm','rmvb','ape','flv','mp4','3gp');
	return in_array($ext,$arr);
}
function convert_str($in,$out,$str){
	if(function_exists("iconv")){
		$str = iconv($in,$out,$str);
	}elseif(function_exists("mb_convert_encoding")){
		$str = mb_convert_encoding($str,$out,$in);
	}
	return $str;
}
function is_utf8(){
	global $charset;
	return (strtolower($charset) == 'utf-8') ? true : false;
}
function is_windows(){
	return (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') ? 1 : 0;
}
function get_extension($name){
	return strtolower(trim(strrchr($name, '.'), '.'));
}
function get_real_ext($file_extension){
	$filter_extension = 'asp,asa,aspx,ascx,dtd,xsd,xsl,xslt,as,wml,java,vtm,vtml,jst,asr,php,php3,php4,php5,vb,vbs,jsf,jsp,pl,cgi,js,html,htm,xhtml,xml,css,shtm,cfm,cfml,shtml,bat,sh';
	if($file_extension){
		$exts = explode(',',$filter_extension);
		if(in_array($file_extension,$exts)){
			$file_ext = '.'.$file_extension.'.txt';
		}else{
			$file_ext = '.'.$file_extension;
		}
	}else{
		$file_ext = '.txt';
	}
	return $file_ext;
}
function add_real_ext($file_extension){
	$filter_extension = 'asp,asa,aspx,ascx,dtd,xsd,xsl,xslt,as,wml,java,vtm,vtml,jst,asr,php,php3,php4,php5,vb,vbs,jsf,jsp,pl,cgi,js,html,htm,xhtml,xml,css,shtm,cfm,cfml,shtml,bat,sh';
	$file_ext = '';
	if($file_extension){
		$exts = explode(',',$filter_extension);
		if(in_array($file_extension,$exts)){
			$file_ext = '.txt';
		}else{
			$file_ext = '';
		}
	}
	return $file_ext;
}
function get_ip(){
	if(getenv('HTTP_CLIENT_IP') && strcasecmp(getenv('HTTP_CLIENT_IP'), 'unknown')) {
		$onlineip = getenv('HTTP_CLIENT_IP');
	} elseif(getenv('HTTP_X_FORWARDED_FOR') && strcasecmp(getenv('HTTP_X_FORWARDED_FOR'), 'unknown')) {
		$onlineip = getenv('HTTP_X_FORWARDED_FOR');
	} elseif(getenv('REMOTE_ADDR') && strcasecmp(getenv('REMOTE_ADDR'), 'unknown')) {
		$onlineip = getenv('REMOTE_ADDR');
	} elseif(isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR'] && strcasecmp($_SERVER['REMOTE_ADDR'], 'unknown')) {
		$onlineip = $_SERVER['REMOTE_ADDR'];
	}
	$onlineip = addslashes($onlineip);
	@preg_match("/[\d\.]{7,15}/", $onlineip, $onlineipmatches);
	$onlineip = $onlineipmatches[0] ? $onlineipmatches[0] : 'unknown';
	unset($onlineipmatches);
	return $onlineip;
}
function sql_array ($arr){
	$ins = array();
	reset($arr);
	while(list($c, $v) = each($arr)){
		$ins[] = ($v === NULL ? sprintf('`%s`=NULL', $c) : sprintf('`%s`=\'%s\'', $c, $v));
	}
	return implode(', ', $ins);
}
function settings_cache($arr=0){
	global $settings;
	if(is_array($arr)){
		foreach($arr as $k => $v){
			$v = str_replace(array("'",'\\'),'',$v);
			$sqls .= "('$k','".trim($v)."'),";
		}
		$sqls = substr($sqls,0,-1);
		DB::query("replace into ".DB::table('phpdisk_settings')." (vars,value) values $sqls;");
	}
	$q = DB::query("select * from ".DB::table('phpdisk_settings')." order by vars");
	while($rs = DB::fetch($q)){
		$str_c .= "\t'".$rs['vars']."' => '".$rs['value']."',".LF;
	}

	$str = "<?php".LF.LF;
	$str .= "// This is PHPDISK auto-generated file. Do NOT modify me.".LF;
	$str .= "// Cache Time: ".date("Y-m-d H:i:s").LF.LF;
	$str .= "\$settings = array(".LF;
	$str .= $str_c;
	$str .= ");".LF.LF;
	$str .= "?>".LF;

	write_file(PHPDISK_ROOT."./system/settings.inc.php",$str);
}
function show_ads($pos){
	global $settings;
	echo $settings[$pos] ? stripslashes(base64_decode($settings[$pos])) : '';
}
function ip_encode($ip){
	global $G;
	if($G[adminid]==1){
		return $ip;
	}else{
		$arr = explode('.',$ip);
		for($i=0;$i<count($arr)-1;$i++){
			return $arr[0].'.*.*.*';
		}
	}
}
function pd_setcookie($var, $value, $expires = 0,$cookiepath = '/') {
	global $timestamp,$settings;
	$cookie_domain = $settings['cookie_domain'] ? '.'.$settings['cookie_domain'] : '';
	setcookie($var, $value,$expires ? ($timestamp + $expires) : 0,$cookiepath,$cookie_domain, $_SERVER['SERVER_PORT'] == 443 ? 1 : 0);
}

function read_file($f) {
	if (file_exists($f)) {
		if (PHP_VERSION >= "4.3.0") return file_get_contents($f);
		$fp = fopen($f,"rb");
		$fsize = filesize($f);
		$c = fread($fp, $fsize);
		fclose($fp);
		return $c;
	} else{
		exit("<b>$f</b> does not exist!");
	}
}

function write_file($f,$str,$mode = 'wb') {
	$fp = fopen($f,$mode);
	if (!$fp) {
		exit("Can not open file <b>$f</b> .code:1");
	}
	if(is_writable($f)){
		if(!fwrite($fp,$str)){
			exit("Can not write file <b>$f</b> .code:2");
		}
	}else{
		exit("Can not write file <b>$f</b> .code:3");
	}
	fclose($fp);
}
function upload_file($source, $target) {
	if (function_exists('move_uploaded_file') && @move_uploaded_file($source, $target)) {
		@chmod($target, 0666);
		return $target;
	} elseif (@copy($source, $target)) {
		@chmod($target, 0666);
		return $target;
	} elseif (@is_readable($source)) {
		if ($fp = @fopen($source,'rb')) {
			@flock($fp,2);
			$filedata = @fread($fp,@filesize($source));
			@fclose($fp);
		}
		if ($fp = @fopen($target, 'wb')) {
			@flock($fp, 2);
			@fwrite($fp, $filedata);
			@fclose($fp);
			@chmod ($target, 0666);
			return $target;
		} else {
			return false;
		}
	}
}
function tree_path($folder_id,$in_box=0){
	global $_G;
	$str = '';
	$q = DB::query("select parent_id,folder_name,folder_id from ".DB::table('phpdisk_folders')." where folder_id='$folder_id' and userid='{$_G[uid]}'");
	if($rs = DB::fetch($q)){
		if($rs['parent_id']!=0){
			$str .= tree_path($rs['parent_id'],$in_box);
		}
		if($in_box){
			$str .= '<a href="###" onclick="top.document.location=\''.$_G[siteurl].urr("phpdisk","mod=mydisk&folder_id=$folder_id").'\'" class="myBox_close"><img src="source/plugin/phpdisk/images/folder_open.gif" align="absmiddle" border="0" />'.$rs['folder_name'].'</a>&nbsp;&raquo;&nbsp;';
		}else{
			$str .= '<a href="'.urr("phpdisk","mod=mydisk&folder_id=$folder_id").'"><img src="source/plugin/phpdisk/images/folder_open.gif" align="absmiddle" border="0" />'.$rs['folder_name'].'</a>&nbsp;&raquo;&nbsp;';
		}
	}
	unset($rs);
	return $str;
}
function get_folder_option($pid=0,$selID=0,$lv=0,$uid){
	$sql_do = $uid ? "where userid='$uid'" : '';
	$q = DB::query("select folder_id,folder_name,parent_id from ".DB::table('phpdisk_folders')." $sql_do order by folder_id asc");
	while ($rs = DB::fetch($q)) {
		$data[] = $rs;
	}
	unset($rs);
	if(count($data)){
		$html = '';
		foreach($data as $v){
			if($v['parent_id'] == $pid){
				$html .= '<option value="'.$v[folder_id].'"';
				$html .= $selID ? ifselected($selID,$v[folder_id]) : '';
				$html .= '>'.str_repeat('&nbsp;',$lv*2).$v[folder_name].'</option>'.LF;
				$lv++;
				$html .= get_folder_option($v['folder_id'],$selID,$lv,$uid);
				$lv--;
			}
		}
		return $html;
	}else{
		return '';
	}
}
function admincp_msg($msg,$go_url,$success=1,$timeout=2000){
	$ext = $success ? '' : ' txtred';
	if(is_array($msg)){
		$msgt = '';
		for($i=0;$i<count($msg);$i++){
			$msgt .= '<li>'.$msg[$i].'</li>'.LF;
		}
	}else{
		$msgt =$msg;
	}
	echo "<div class='infobox'><h4 class='infotitle2'>$msgt</h4><p class='marginbot'><a href='$go_url' class='lightlink'>ûԶת</a></p><script type='text/JavaScript'>setTimeout('redirect(\"$go_url\");', $timeout);</script></div>";
}
function is_mobile(){
	if(strpos(strtolower($_SERVER['HTTP_USER_AGENT']),'android') || strpos(strtolower($_SERVER['HTTP_USER_AGENT']),'applewebkit')){
		return true;
	}else{
		return false;
	}
}
function check_download_ok($my_sid,$interval_time){
	global $onlineip,$timestamp;
	$rtn = false;
	DB::query("delete from ".DB::table('phpdisk_downlog')." where $timestamp-intime>3*86400");
	$rs = DB::fetch_first("select * from ".DB::table('phpdisk_downlog')." where hash='$my_sid' or ip='$onlineip'");
	if(!$rs[intime]){
		$ins = array(
		'hash'=>$my_sid,
		'ip'=>$onlineip,
		'intime'=>$timestamp,
		);
		DB::query("insert into ".DB::table('phpdisk_downlog')." set ".sql_array($ins));
		$rtn = true;
	}else{
		$interval_time = $interval_time ? $interval_time : 600;
		if($timestamp-$rs[intime]>$interval_time){
			DB::query("update ".DB::table('phpdisk_downlog')." set intime='$timestamp' where id='{$rs[id]}'");
			$rtn = true;
		}
		DB::query("update ".DB::table('phpdisk_downlog')." set downcount=downcount+1 where id='{$rs[id]}'");
	}
	return $rtn;
}
function get_nodes($server_oid){
	$q = DB::query("select * from ".DB::table('phpdisk_nodes')." where server_oid='$server_oid' and is_hidden=0 order by show_order asc,node_id asc");
	$nodes = array();
	while ($rs = DB::fetch($q)) {
		$rs[icon] = $rs[icon] ? '<img src="'.$rs[icon].'" align="absmiddle" border="0" />' : '&nbsp;';
		$rs[host] = $rs[host] ? $rs[host] : 'http://www.phpdisk.com/';
		$nodes[] = $rs;
	}
	unset($rs);
	return $nodes;
}
function get_system_upload_max_size($curr_disk=1){
	global $settings;
	$upload_max = get_byte_value(ini_get('upload_max_filesize'));
	$post_max = get_byte_value(ini_get('post_max_size'));
	$settings_max = $settings['max_file_size'] ? get_byte_value($settings['max_file_size']) : 0;
	$max_php_file_size = min($upload_max, $post_max);
	if($curr_disk){
		$max_file_size_byte = ($settings_max && $settings_max <= $max_php_file_size) ? $settings_max : $max_php_file_size;
		return get_size($max_file_size_byte,'B',0);
	}else{
		$max_file_size_byte = ($settings_max && $settings_max <= $max_php_file_size) ? $settings_max : $max_php_file_size;
		return get_size($max_php_file_size,'B',0);
	}
}
function get_ids_arr($arr,$msg,$str_in_db=0){
	$error = 0;
	if(!count($arr)){
		$error = 1;
		$strs = $msg;
	}else{
		for($i=0;$i<count($arr);$i++){
			$strs .= $str_in_db ? addslashes($arr[$i])."," : "'".addslashes($arr[$i])."',";
		}
		$strs = substr($strs,0,-1);
	}
	return array($error,$strs);
}
if(!function_exists('dir_writeable')){
	function dir_writeable($dir) {
		if(!is_dir($dir)) {
			@mkdir($dir, 0777);
		}
		if(is_dir($dir)) {
			if($fp = @fopen("$dir/phpdisk.test", 'w')) {
				@fclose($fp);
				@unlink("$dir/phpdisk.test");
				$writeable = 1;
			} else {
				$writeable = 0;
			}
		}
		return $writeable;
	}
}
?>