<?php
/** Filename:    ftp.lib.php
*   Description: ftp operand module
*                support command:cd,ls,chmod,get,put...
*            
*   Authors:     Li Zhi Wei,Greg Shaw(greg@upsdn.net)
*   License:     GPL
*   Date:        2004-12-18    
*/
  
class WEBFTP{
  var $conn_id;
  var $working_dir = "/";
  var $trans_mode  = FTP_BINARY;
  var $status_info = "";
  
  function GetStatus()
  {
    return $this->status_info;
  } 
    
  function InitConn($ftp_user,$ftp_pass,$ftp_site="127.0.0.1",$ftp_port="21")
  {
    $ret=false;
    $this->conn_id = ftp_connect($ftp_site,$ftp_port) 
    or die("Couldn't connect to Ftp<br><a href='javascript:history.back()'>Back</a>");
  
    if( ftp_login($this->conn_id,$ftp_user,$ftp_pass) ){
     $ret=true;
    }
    return $ret;
  }
  
  function CloseConn() 
  {
    ftp_close($this->conn_id);
  }
  
  function SetPasv($pasv=TRUE)
  {
    return ftp_pasv($this->conn_id,$pasv);
  }
    
  function SetWorkingDir($dir)
  {
    //if( ftp_chdir($this->conn_id, $dir) )
    // $this->working_dir=$dir;
    ftp_chdir($this->conn_id, $dir);
    $this->working_dir=ftp_pwd($this->conn_id);
  }
  
  function GetWorkingDir()
  {
  	  return $this->working_dir;
  }  	   
   
  function SetTransMode($mode)
  {
    if( ($mode= FTP_ASCII) || ($mode == FTP_BINARY) )
      $this->trans_mode = $mode;
  }
  
  function GetTransMode()
  {
    return $this->trans_mode;
  }
  
  function GetList($dir_name = "")
  {
    //"-aF " equal to '-al;
    //"-aL"  Symbol Link
    //$contents = ftp_rawlist($this->conn_id, "-al ".$this->working_dir."/".$dir_name );
    $contents = ftp_rawlist($this->conn_id, "-al ".$dir_name );
    foreach ($contents as $file){
      if(ereg("([-dl][rwxst-]+).* ([0-9]*) ([a-zA-Z0-9]+).* ([a-zA-Z0-9]+).* ([0-9]*) ([a-zA-Z]+[0-9: ]*[0-9])[ ]+(([0-9]{2}:[0-9]{2})|[0-9]{4}) (.+)", $file, $regs)){
        $type = (int) strpos("-dl", $regs[1]{0});
        $tmp_array['line'] = $regs[0];
        $tmp_array['type'] = $type;
        $tmp_array['rights'] = $regs[1];
        $tmp_array['number'] = $regs[2];
        $tmp_array['user'] = $regs[3];
        $tmp_array['group'] = $regs[4];
        $tmp_array['size'] = $regs[5];
        //$tmp_array['date'] = date("m-d",strtotime($regs[6]));
        $tmp_array['date'] = $regs[6];
        $tmp_array['time'] = $regs[7];
        $tmp_array['name'] = $regs[9];
        $dir_list[] = $tmp_array;
       }
      else if (FALSE == strstr($file,"total")){
        $this->status_info .= ("\n<br> <font color=red>Regular Expression Error</font><br>".$file);
       }
    }
    if (!isset($dir_list)){
      $this->status_info .= "<br><font color=red>Cannot Get Dir List.</font>";
      $dir_list = array();
    }
    return $dir_list;
  }
    
  function MakeDir($path)
  {
    return ftp_mkdir($this->conn_id,$path); //Name or FALSE
  }
    
  function ChangMode($file,$mode)
  {
    $ret = ftp_site($this->conn_id, "CHMOD ".$mode.$file);
    if(FALSE == $ret){ //TRUE or FALSE
      $this->status_info = "Cannot chang mode to:{$mode}[<font color=red>{$file}</font>]";
     }
    return $ret;
  }
    
  function Move($to,$from)
  {
    return ftp_rename($this->conn_id, $from, $to); //TRUE or FALSE
  }  
  
  function DeleteFile($file)
  {
    return ftp_delete($this->conn_id,$file);
  }
   
  function RemoveAll($dst_dir)
  {
    $ar_files = $this->GetList($dst_dir);
    for ($i=2;$i<sizeof($ar_files);$i++){
      $st_file = $ar_files[$i]; 
      if(1 == $st_file['type']){         // check if it is a directory
        $this->RemoveAll($dst_dir."/".$st_file['name']); // if so, use recursion
      }else{
        $this->DeleteFile($dst_dir."/".$st_file['name']); // if not, delete the file
       }
    }
    ftp_rmdir($this->conn_id, $dst_dir); // delete empty directories
  }

  function PutFileFromTemp($remote_file,$local_file)
  {
    //$ret = ftp_nb_put ($this->conn_id, $remote_file, 
    //           $local_file, $this->trans_mode,ftp_size($this->conn_id,$remote_file));   
    //$ret = ftp_nb_put ($this->conn_id, $remote_file, 
    //           $local_file, $this->trans_mode,FTP_AUTORESUME); 
    $ret = ftp_nb_put ($this->conn_id, $remote_file, 
               $local_file, $this->trans_mode); 
    while ($ret == FTP_MOREDATA){     
      //echo ".";
      $ret = ftp_nb_continue ($this->conn_id);
    }
    if ($ret != FTP_FINISHED){
      //echo "\n<br /><font color=red>There was an error uploading the file...</font>";
      $status_info ="\n<br /><font color=red>There was an error uploading the file...</font>";
      $ret =  FALSE;
    }else{
      $ret =  TRUE;                 
    }
    return $ret;
  }
   
  function GetFileToTemp($path_file,$local_file)
  {
    //ftp_fget
    /*
    $fp = fopen($local_file, "wb");
    $ret = ftp_fget($this->conn_id,$fp,$path_file,$this->trans_mode) or die("Cannot Get File: $file <br>"); 
    fclose($fp);
    return $ret;
    */
     
    //ftp_nb_get;
    /*   
    $ret = ftp_nb_get($this->conn_id, $local_file, 
                      $path_file, $this->trans_mode,FTP_AUTORESUME);
    while ($ret == FTP_MOREDATA) 
    {                
      $ret = ftp_nb_continue($this->conn_id); 
    }
    
    if ($ret != FTP_FINISHED) 
    {
      //echo "\n<br /><font color=red>There was an error downloading the file...</font>";
      $status_info ="\n<br /><font color=red>There was an error downloading the file...</font>";
      return FALSE;
    }
    else
      return TRUE;
    */

   
    //ftp_nb_fget;
    $fp = fopen($local_file, 'wb');
    $ret = ftp_nb_fget($this->conn_id, $fp, $path_file, $this->trans_mode,FTP_AUTORESUME);
    while ($ret == FTP_MOREDATA){
      $ret = ftp_nb_continue($this->conn_id); 
    }
    if ($ret != FTP_FINISHED){
      $status_info ="\n<br /><font color=red>There was an error downloading the file...</font>";
      $ret = FALSE;
    }else{
      $ret = TRUE;
    }
    fclose($fp);
    return $ret;

    
    //ftp_get
    /*
    if (ftp_get($this->conn_id, $local_file,$path_file, $this->trans_mode)) 
    {
      $ret = TRUE;
    }
    else 
    {
      $status_info ="\n<br /><font color=red>There was an error downloading the file...</font>";
      $ret = FALSE;
    }
    return $ret;
    */
  }
  
  function GetFileSize($file)
  {
    return ftp_size($this->conn_id, $file);
  }
}//end Class  

?>
