﻿<%@ WebHandler Language="C#" Class="Admin_weixin" %>

using System;
using System.Web;
using System.Linq;
using System.Text;
using System.Data;
using System.Collections;
using System.Collections.Generic;


public class Admin_weixin : IHttpHandler
{

    private string access_token = Weixin_operate.Get_AccessToken();
    private string checkboxName;
    public void ProcessRequest(HttpContext context)
    {
        context.Response.ContentType = "text/plain";
        string T = context.Request["T"];
        checkboxName = context.Request.Form["ContentIDCollection"];

        switch (T)
        {
            case "reload_user"://同步用户
                reload_user(true);
                break;
            case "reload_material"://同步素材
                reload_material(true);
                break;
            case "reloadusergroup"://同步好友分组
                reloadusergroup();
                break;
            case "send_data"://群发信息
                senddata();
                break;
            case "usertogroup"://用户添加到分组
                usertogroup();
                break;
            case "usertogroup_del"://移除用户分组
                usertogroup_del();
                break;
            case "reply"://回复信息
                reply();
                break;
            case "analysis"://统计
                analysis();
                break;
            case "add_ticket"://获取二维码
                Get_ticket();
                break;
            case "weixin_menu_add"://添加菜单
                weixin_menu_add();
                break;
            default:
            case "weixin_menu_upload"://上传微信菜单
                weixin_menu_upload();
                break;
            case "weixin_menu_download"://下载微信菜单
                weixin_menu_download();
                break;

        }
    }

    /// <summary>
    /// 在线获取二维码
    /// </summary>
    /// <param name="p"></param>
    /// <returns></returns>
    private void Get_ticket()
    {

        try
        {
            string content = HttpContext.Current.Request.Form["content"].ToString();
            string Fileurl = DateTime.Now.ToString("yyyyMMddhhmmss") + ".jpg";
            string Filename = HttpContext.Current.Server.MapPath("../../UploadFiles/" + Fileurl);
            string result = WeiXinAPI.WeiXinCommon.Get_ticket(Filename, access_token, content);
            if (result == "complete")
            {
                //入库
                string sql = "";
                sql = "insert into g_ticket (t_url,t_time) ";
                sql += " values(@t_url, @t_time)";
                System.Data.OleDb.OleDbParameter[] param ={new System.Data.OleDb.OleDbParameter("@t_url", Fileurl),
                                                            new System.Data.OleDb.OleDbParameter("@t_time",DateTime.Now.ToShortDateString())
                                                                };
                int j = guandongren.MakehtmlSQL.Add(sql, param);
                if (j > 0)
                {
                    Main.Create_log("获取微信二维码", DateTime.Now + ",成功获取微信二维码", HttpContext.Current.Request.Cookies["admin"].Value);
                }
            }
            HttpContext.Current.Response.Write(result);
        }
        catch (Exception e)
        {
            HttpContext.Current.Response.Write("获取失败:" + e.Message);
        }

    }
    //同步用户
    private bool reload_user(bool outMessage)
    {
        string delsql = string.Empty;
        string sql = string.Empty;
        string openidsstr = string.Empty;//OpenId 列表

        try
        {
            if (!string.IsNullOrEmpty(access_token))
            {
                //获取OpenId列表
                System.Collections.Generic.List<WeiXinAPI.OpenIdListObject> openIdList = WeiXinAPI.WeiXinCommon.Get_OpenId_List(access_token);
                foreach (WeiXinAPI.OpenIdListObject openobject in openIdList)
                {
                    if (!openobject.IsError)
                    {
                        string[] ids = openobject.data.Openids;//OpenId 列表
                        openidsstr = openobject.data.OpenidArrayStr;
                        foreach (string item in ids)
                        {
                            WeiXinAPI.UserDetailsObject ud = WeiXinAPI.WeiXinCommon.Get_UserDetails(access_token, item.Trim());//获取用户详情

                            string openidsql = "select u_openid from g_weixin_user where u_openid='" + item + "'";
                            object o = guandongren.MakehtmlSQL.Query_object(openidsql);
                            if (o == null || o.ToString() == string.Empty)//新增加
                            {
                                sql = "insert into  g_weixin_user (u_openid, u_subscribe, u_nickname, u_sex ,u_language, u_city, u_country,u_province,u_headimgurl ,u_subscribe_time,u_createtime,u_updatetime,u_groupid) ";
                                sql += " values(@u_openid, @u_subscribe, @u_nickname, @u_sex ,@u_language, @u_city, @u_country,@u_province,@u_headimgurl ,@u_subscribe_time,@u_createtime,@u_updatetime,@u_groupid)";
                                System.Data.OleDb.OleDbParameter[] param ={
                                                            new System.Data.OleDb.OleDbParameter("@u_openid", ud.openid),
                                                            new System.Data.OleDb.OleDbParameter("@u_subscribe",ud.subscribe),
                                                            new System.Data.OleDb.OleDbParameter("@u_nickname",ud.nickname),
                                                            new System.Data.OleDb.OleDbParameter("@u_sex",ud.sex),
                                                            new System.Data.OleDb.OleDbParameter("@u_language",ud.language),
                                                            new System.Data.OleDb.OleDbParameter("@u_city",ud.city),
                                                            new System.Data.OleDb.OleDbParameter("@u_country",ud.country),
                                                            new System.Data.OleDb.OleDbParameter("@u_province", ud.province),
                                                            new System.Data.OleDb.OleDbParameter("@u_headimgurl",ud.headimgurl),
                                                            new System.Data.OleDb.OleDbParameter("@u_subscribe_time",ud.subscribe_time),
                                                            new System.Data.OleDb.OleDbParameter("@u_createtime",System.DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss")),
                                                            new System.Data.OleDb.OleDbParameter("@u_updatetime",System.DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss")),
                                                            new System.Data.OleDb.OleDbParameter("@u_groupid",ud.groupid)
                                                                };
                                int j = guandongren.MakehtmlSQL.ExecuteSql(sql, param);
                                if (j > 0)
                                {
                                    Main.Create_log("同步微信好友，增加 OpenID:" + ud.openid + " 昵称:" + ud.nickname, "", HttpContext.Current.Request.Cookies["admin"].Value);
                                }
                            }
                            else//更新
                            {
                                sql += "update g_weixin_user set u_subscribe=@u_subscribe, u_nickname=@u_nickname, u_sex=@u_sex ,u_language=@u_language, u_city=@u_city, u_country=@u_country,u_province=@u_province,u_headimgurl=@u_headimgurl ,u_subscribe_time=@u_subscribe_time,u_updatetime=@u_updatetime, u_groupid=@u_groupid  where u_openid=@u_openid";
                                System.Data.OleDb.OleDbParameter[] param ={
                                                            new System.Data.OleDb.OleDbParameter("@u_subscribe",ud.subscribe),
                                                            new System.Data.OleDb.OleDbParameter("@u_nickname",ud.nickname),
                                                            new System.Data.OleDb.OleDbParameter("@u_sex",ud.sex),
                                                            new System.Data.OleDb.OleDbParameter("@u_language",ud.language),
                                                            new System.Data.OleDb.OleDbParameter("@u_city",ud.city),
                                                            new System.Data.OleDb.OleDbParameter("@u_country",ud.country),
                                                            new System.Data.OleDb.OleDbParameter("@u_province", ud.province),
                                                            new System.Data.OleDb.OleDbParameter("@u_headimgurl",ud.headimgurl),
                                                            new System.Data.OleDb.OleDbParameter("@u_subscribe_time",ud.subscribe_time),
                                                            new System.Data.OleDb.OleDbParameter("@u_updatetime",System.DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss")),
                                                            new System.Data.OleDb.OleDbParameter("@u_groupid",ud.groupid),
                                                            new System.Data.OleDb.OleDbParameter("@u_openid", ud.openid)
                                                                };
                                int j = guandongren.MakehtmlSQL.ExecuteSql(sql, param);
                                if (j > 0)
                                {
                                    Main.Create_log("同步微信好友，更新 OpenID:" + ud.openid + " 昵称:" + ud.nickname, "", HttpContext.Current.Request.Cookies["admin"].Value);
                                }
                            }
                            sql = string.Empty;
                        }
                    }
                    else
                    {
                        if (outMessage)
                        {
                            HttpContext.Current.Response.Write(openobject.errmsg);
                        }
                        return false;
                    }

                }

                if (!string.IsNullOrEmpty(openidsstr))
                {
                    delsql += " delete from g_weixin_user where u_openid not in(" + openidsstr + ")";
                    int j = guandongren.MakehtmlSQL.ExecuteSql(delsql);
                    if (j != 0)
                    {
                        Main.Create_log("删除无效微信好友，个数:" + j, "", HttpContext.Current.Request.Cookies["admin"].Value);
                    }
                }
                HttpContext.Current.Response.Write("ok");
                return true;
            }
            else
            {
                if (outMessage)
                {
                    HttpContext.Current.Response.Write("获取AccessToken失败！");
                }
                return false;
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write(ex.Message);
            return false;
        }
    }
    //同步素材
    public bool reload_material(bool outMessage)
    {
        try
        {
            string selectSql = "select m_name,m_type,m_media_id,m_filename,m_url,m_createtime from g_weixin_material";
            string insertSql = string.Empty;
            string delsql = string.Empty;

            System.Data.DataSet ds = guandongren.MakehtmlSQL.Query(selectSql);
            for (int i = 0; i < ds.Tables[0].Rows.Count; i++)
            {
                string media_id = ds.Tables[0].Rows[i]["m_media_id"].ToString();
                string m_name = ds.Tables[0].Rows[i]["m_name"].ToString();
                string type = ds.Tables[0].Rows[i]["m_type"].ToString();
                string m_url = ds.Tables[0].Rows[i]["m_url"].ToString();
                string m_filename = ds.Tables[0].Rows[i]["m_filename"].ToString();
                string fileExt = System.IO.Path.GetExtension(ds.Tables[0].Rows[i]["m_filename"].ToString());
                string createTime = ds.Tables[0].Rows[i]["m_createtime"].ToString();
                string filePath = string.Empty;
                string fileFullPath = string.Empty;
                switch (type)
                {
                    case "image":
                        filePath = "/UploadFiles/mp/Image/";
                        break;
                    case "voice":
                        filePath = "/UploadFiles/mp/Voice/";
                        break;
                    case "video":
                        filePath = "/UploadFiles/mp/Video/";
                        break;
                    //case "newslocal":
                    //    filePath = "UploadFiles\\Weixin\\NewsLocal\\";
                    //    break;
                    default:
                        break;
                }

                delsql = string.Format("delete from g_weixin_material where m_media_id='{0}' and m_type<>'newslocal'  ", media_id);
                guandongren.MakehtmlSQL.ExecuteSql(delsql);
                string oldfilepath = HttpContext.Current.Server.MapPath(filePath + m_filename);
                if (System.IO.File.Exists(oldfilepath))
                {
                    System.IO.File.Delete(oldfilepath);
                }

                //更新数据
                fileFullPath = HttpContext.Current.Request.PhysicalApplicationPath + filePath + media_id + fileExt;
                if (WeiXinAPI.WeiXinCommon.Get_Media(access_token, media_id, fileFullPath) == "complete")
                {
                    insertSql = string.Format("insert into {0} (m_name,m_type,m_url,m_content,m_des,m_filename,m_media_id,m_createtime,m_updatetime) values ('{1}','{2}','{3}','{4}','{5}','{6}','{7}','{8}','{9}')"
                                                           , "g_weixin_material", m_name, type, "\\" + filePath + media_id + fileExt, "", "", System.IO.Path.GetFileName(fileFullPath), media_id, createTime, System.DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss"));
                    guandongren.MakehtmlSQL.ExecuteSql(insertSql);
                }

                insertSql = string.Empty;
                delsql = string.Empty;
            }

            if (outMessage)
            {
                HttpContext.Current.Response.Write("ok");
            }
            return true;

        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write(ex.Message);
            return false;
        }
    }
    //群发信息
    private void senddata()
    {
        try
        {
            string type = HttpContext.Current.Request["type"].ToString();
            string mediaid = string.Empty;
            string result = string.Empty;
            string insertSqlText = string.Empty;
            string selectSqlText = string.Empty;
            string content = string.Empty;
            System.Collections.Generic.List<string> openidlist = new System.Collections.Generic.List<string>();

            #region 通过OpenId进行群发
            WeiXinAPI.MassMessage m;
            string openids = string.Empty;
            if (!string.IsNullOrEmpty(checkboxName))
            {
                selectSqlText = "select u_openid from g_weixin_user where u_groupid in (" + checkboxName + ")";
                using (System.Data.OleDb.OleDbDataReader reader = guandongren.MakehtmlSQL.ExecuteReader(selectSqlText, new System.Data.OleDb.OleDbParameter[] { }))
                {
                    while (reader.Read())
                    {
                        if (reader[0] != null)
                        {
                            openids += "\"" + reader[0].ToString() + "\",";
                            openidlist.Add(reader[0].ToString());
                        }
                    }
                }
                openids = "[" + openids.TrimEnd(',') + "]";
                m = new WeiXinAPI.MassMessage();
                m.AccessToken = access_token;
                m.ToUserName = openids;
                if (type == "text")
                {
                    m.MsgType = "text";
                    content = HttpContext.Current.Request.Form["content"].ToString();
                    m.Content = content;
                }
                if (type == "media")
                {
                    type = HttpContext.Current.Request["mediatype"].ToString();
                    mediaid = HttpContext.Current.Request["mediaid"].ToString();
                    m.MediaId = mediaid;
                    m.MsgType = type;
                    content = "媒体文件";
                }

                result = WeiXinAPI.WeiXinCommon.Send_MassMessageByOpenID(m);
                if (WeiXinAPI.JsonOprate.IsError(result))
                {
                    HttpContext.Current.Response.Write(result);
                    return;
                }

            }
            #endregion

            //将发送的信息存入数据库
            for (int i = 0; i < openidlist.Count; i++)
            {
                insertSqlText = "insert into g_weixin_send (s_type,s_content,s_openid,s_mediaid,s_createtime,s_user) values(@s_type,@s_content,@s_openid,@s_mediaid,@s_createtime,@s_user)";
                System.Data.OleDb.OleDbParameter[] param ={new System.Data.OleDb.OleDbParameter("@s_type",type),
                                                           new System.Data.OleDb.OleDbParameter("@s_content",content),
                                                           new System.Data.OleDb.OleDbParameter("@s_openid",openidlist[i]),
                                                           new System.Data.OleDb.OleDbParameter("@s_mediaid",mediaid),
                                                           new System.Data.OleDb.OleDbParameter("@s_createtime",System.DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss")),
                                                           new System.Data.OleDb.OleDbParameter("@s_user",checkboxName)
                                                      };
                guandongren.MakehtmlSQL.ExecuteSql(insertSqlText, param);
            }


            Main.Create_log("群发消息，消息类型:" + type + " 消息内容:" + content, "", HttpContext.Current.Request.Cookies["admin"].Value);
            HttpContext.Current.Response.Write("ok");

        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write(ex.Message);
        }
    }
    //同步用户分组
    private void reloadusergroup()
    {
        try
        {
            WeiXinAPI.UserGroupObject groups = WeiXinAPI.WeiXinCommon.Get_UserGroups(access_token);
            if (groups.groups.list.Count > 0)
            {
                string delsql = "delete from g_weixin_usergroup";
                string upsql = string.Empty;
                guandongren.MakehtmlSQL.ExecuteSql(delsql);
                foreach (WeiXinAPI.UserGroup item in groups.groups.list)
                {
                    upsql = "insert into g_weixin_usergroup(u_groupid,u_groupname,u_groupcount,u_updatetime) values(@u_groupid,@u_groupname,@u_groupcount,@u_updatetime)";
                    System.Data.OleDb.OleDbParameter[] param ={new System.Data.OleDb.OleDbParameter("@u_groupid",item.id),
                                                               new System.Data.OleDb.OleDbParameter("@u_groupname",item.name),
                                                               new System.Data.OleDb.OleDbParameter("@u_groupcount",item.count),
                                                               new System.Data.OleDb.OleDbParameter("@u_updatetime",System.DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss"))
                                                        };
                    int j = guandongren.MakehtmlSQL.Add(upsql, param);
                    if (j > 0)
                    {
                        Main.Create_log("同步微信用户分组", "", HttpContext.Current.Request.Cookies["admin"].Value);
                    }
                    HttpContext.Current.Response.Write("ok");
                }
            }
        }
        catch (Exception ex)
        {

            HttpContext.Current.Response.Write(ex.Message);
        }
    }
    //把用户添加到分组
    private void usertogroup()
    {
        try
        {
            string groupid = HttpContext.Current.Request["groupid"].ToString();
            WeiXinAPI.UserGroupMessage m;
            string updsql = string.Empty;
            if (Main.CheckNull(groupid))
            {
                foreach (string item in checkboxName.Split(','))
                {
                    m = new WeiXinAPI.UserGroupMessage();
                    m.AccessToken = access_token;
                    m.GroupID = groupid;
                    m.OpenId = item;
                    string str = WeiXinAPI.WeiXinCommon.Move_UserGroup(m);
                    if (WeiXinAPI.JsonOprate.IsError(str))
                    {
                        HttpContext.Current.Response.Write(str);
                        return;
                    }
                    else
                    {
                        updsql = "update g_weixin_user set u_groupid=@u_groupid where u_openid=@u_openid";
                        System.Data.OleDb.OleDbParameter[] param ={ new System.Data.OleDb.OleDbParameter("@u_groupid",groupid),
                                                                    new System.Data.OleDb.OleDbParameter("@u_openid",item)
                                                                  };
                        int j = guandongren.MakehtmlSQL.ExecuteSql(updsql, param);
                        if (j > 0)
                        {
                            Main.Create_log("更新微信用户表用户分组ID u_openid:" + item + " u_groupid:" + groupid, "", HttpContext.Current.Request.Cookies["admin"].Value);
                        }


                    }
                }

                reloadusergroup();

                HttpContext.Current.Response.Write("ok");
            }
            else
            {
                HttpContext.Current.Response.Write("获取Group-id失败！");
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write(ex.Message);
        }
    }

    private void usertogroup_del()
    {
        try
        {
            WeiXinAPI.UserGroupMessage m;
            string updsql = string.Empty;
            foreach (string item in checkboxName.Split(','))
            {
                m = new WeiXinAPI.UserGroupMessage();
                m.AccessToken = access_token;
                m.GroupID = "0";
                m.OpenId = item;
                string str = WeiXinAPI.WeiXinCommon.Move_UserGroup(m);
                if (WeiXinAPI.JsonOprate.IsError(str))
                {
                    HttpContext.Current.Response.Write(str);
                    return;
                }
                else
                {
                    updsql = "update g_weixin_user set u_groupid=@u_groupid where u_openid=@u_openid";
                    System.Data.OleDb.OleDbParameter[] param ={ new System.Data.OleDb.OleDbParameter("@u_groupid","0"),
                                                                    new System.Data.OleDb.OleDbParameter("@u_openid",item)
                                                                  };
                    int j = guandongren.MakehtmlSQL.Add(updsql, param);
                    if (j > 0)
                    {
                        Main.Create_log("更新微信用户表用户分组ID u_openid:" + item + " u_groupid: 0", "", HttpContext.Current.Request.Cookies["admin"].Value);
                    }
                }
            }

            reloadusergroup();
            HttpContext.Current.Response.Write("ok");

        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write(ex.Message);
        }

    }
    //回复信息
    private void reply()
    {
        try
        {
            string type = HttpContext.Current.Request["type"].ToString();//回复类型
            string title = HttpContext.Current.Request["title"].ToString();//标题
            string inputkeyword = HttpContext.Current.Request["inputkeyword"].ToString();//关键字
            string radio_state = HttpContext.Current.Request["radio_state"].ToString();//不否启用

            string textarea_txt = string.Empty;//回复文本
            string mediaid = string.Empty;//媒体ID
            string sql = string.Empty;
            string key = string.Empty;//菜单Key事件
            if (type == "text")
            {
                textarea_txt = HttpContext.Current.Request["textarea_txt"].ToString();
                key = HttpContext.Current.Request["inputkey"].ToString();

            }
            else if (type == "media")
            {

                type = HttpContext.Current.Request["mediatypevalue"].ToString();
                textarea_txt = "媒体文件";

                mediaid = HttpContext.Current.Request["mediaid"].ToString();
            }
            else if (type == "newslocal")//回复图文消息
            {
                textarea_txt = "本地图文";
                mediaid = HttpContext.Current.Request["check_value"].ToString();
            }

            object ts = guandongren.MakehtmlSQL.Query_object("select r_id from g_weixin_reply where r_keyword='" + inputkeyword + "'");
            if (ts == null)
            {
                sql = "insert into g_weixin_reply(r_name,r_keyword,r_enable,r_reply,r_reply_type,r_createtime,r_mediaid,r_key) values(@r_name,@r_keyword,@r_enable,@r_reply,@r_reply_type,@r_createtime,@r_mediaid,@r_key)";
                System.Data.OleDb.OleDbParameter[] param ={new System.Data.OleDb.OleDbParameter("@r_name",title),
                                                           new System.Data.OleDb.OleDbParameter("@r_keyword",inputkeyword),
                                                           new System.Data.OleDb.OleDbParameter("@r_enable",radio_state),
                                                           new System.Data.OleDb.OleDbParameter("@r_reply",textarea_txt),
                                                           new System.Data.OleDb.OleDbParameter("@r_reply_type",type),
                                                           new System.Data.OleDb.OleDbParameter("@r_createtime",System.DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss")),
                                                           new System.Data.OleDb.OleDbParameter("@r_mediaid",mediaid),
                                                           new System.Data.OleDb.OleDbParameter("@r_key",key)
                                                        };
                int j = guandongren.MakehtmlSQL.Add(sql, param);
                if (j > 0)
                {
                    Main.Create_log("添加被动消息回复 标题:" + title + "  关键字:" + inputkeyword, "", HttpContext.Current.Request.Cookies["admin"].Value);
                    HttpContext.Current.Response.Write("ok");
                }
                else
                {
                    HttpContext.Current.Response.Write("添加失败");
                }
            }
            else
            {
                HttpContext.Current.Response.Write("失败:关键字已经存在不能重复添加");
            }


        }
        catch (Exception ex)
        {

            HttpContext.Current.Response.Write(ex.Message);
        }
    }


    //统计分析
    private void analysis()
    {
        string sql_s = string.Empty;
        string sql_m = string.Empty;
        string sql_u = string.Empty;
        string sql_a = string.Empty;
        try
        {
            if (reload_user(false) && reload_material(false))
            {

                sql_s = "update g_weixin_a_sendmsg   set a_msg_text_count =" + getvalue("select count(*) from g_weixin_send where s_type='text'") + "," +
                    "a_msg_media_count=" + getvalue("select count(*) from g_weixin_send where s_type<>'text'") + "," +
                    "a_msg_add_1d=" + getvalue("select count(*) from g_weixin_send where (DateDiff('d',s_createtime,Date())=0)") + "," +
                    "a_msg_add_2d=" + getvalue("select count(*) from g_weixin_send where (DateDiff('d',s_createtime,Date())<=2)") + "," +
                    "a_msg_add_7d=" + getvalue("select count(*) from g_weixin_send where (DateDiff('d',s_createtime,Date())<=7)") + "," +
                    "a_msg_add_30d=" + getvalue("select count(*) from g_weixin_send where (DateDiff('d',s_createtime,Date())<=30)") + "," +
                    "a_msg_add_month=" + getvalue("select count(*) from g_weixin_send where month([s_createtime])=month(now())") + "," +
                    "a_msg_count=" + getvalue("select count(*) from g_weixin_send");

                sql_m = "update g_weixin_a_material      set a_material_image_count=" + getvalue("select count(*) from g_weixin_material where m_type='image'") + "," +
                    "a_material_voice_count=" + getvalue("select count(*) from g_weixin_material where m_type='voice'") + "," +
                    "a_material_video_count=" + getvalue("select count(*) from g_weixin_material where m_type='video'") + "," +
                    "a_material_news_count=" + getvalue("select count(*) from g_weixin_material where m_type='news'") + "," +
                    "a_material_newslocal_count=" + getvalue("select count(*) from g_weixin_material where m_type='newslocal'") + "," +
                    "a_material_music_count=" + getvalue("select count(*) from g_weixin_material where m_type='music'") + "," +
                    //"a_material_add_1d=" + getvalue("select count(*) from g_weixin_material where (DateDiff('d',m_createtime,Date())=0)") + "," +
                    //"a_material_add_2d=" + getvalue("select count(*) from g_weixin_material where (DateDiff('d',m_createtime,Date())<=2)") + "," +
                    //"a_material_add_7d=" + getvalue("select count(*) from g_weixin_material where (DateDiff('d',m_createtime,Date())<=7)") + "," +
                    //"a_material_add_30d=" + getvalue("select count(*) from g_weixin_material where (DateDiff('d',m_createtime,Date())<=30)") + "," +
                     "a_material_count=" + getvalue("select count(*) from g_weixin_material");

                sql_u = "update g_weixin_a_user set a_group_count=" + getvalue("select count(*) from g_weixin_usergroup ") + "," +
                    "a_user_b_count=" + getvalue("select count(*) from g_weixin_user where u_sex='1'") + "," +
                    "a_user_g_count=" + getvalue("select count(*) from g_weixin_user where u_sex='2'") + "," +
                    "a_user_u_count=" + getvalue("select count(*) from g_weixin_user where u_sex='0'") + "," +
                    "a_user_add_1d=" + getvalue("select count(*) from g_weixin_user where (DateDiff('d',u_createtime,Date())=0)") + "," +
                    "a_user_add_2d=" + getvalue("select count(*) from g_weixin_user where (DateDiff('d',u_createtime,Date())=2)") + "," +
                    "a_user_add_7d=" + getvalue("select count(*) from g_weixin_user where (DateDiff('d',u_createtime,Date())<=7)") + "," +
                    "a_user_add_30d=" + getvalue("select count(*) from g_weixin_user where (DateDiff('d',u_createtime,Date())<=30)") + "," +
                    "a_user_count=" + getvalue("select count(*) from g_weixin_user");

                sql_a = "update g_weixin_analysis set a_uptadetime=@a_uptadetime,a_updateuser=@a_updateuser";
                System.Data.OleDb.OleDbParameter[] param ={new System.Data.OleDb.OleDbParameter("@a_uptadetime",System.DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss")),
                                                           new System.Data.OleDb.OleDbParameter("@a_updateuser",HttpContext.Current.Request.Cookies["admin"].Value)
                                                        };


                if (
                    guandongren.MakehtmlSQL.ExecuteSql(sql_s) > 0
                    &&
                    guandongren.MakehtmlSQL.ExecuteSql(sql_m) > 0
                    &&
                    guandongren.MakehtmlSQL.ExecuteSql(sql_u) > 0
                    )
                {

                    int j = guandongren.MakehtmlSQL.Add(sql_a, param);
                    if (j > 0)
                    {
                        Main.Create_log("更新统计信息 ", "", HttpContext.Current.Request.Cookies["admin"].Value);
                        HttpContext.Current.Response.Write("ok");
                    }
                }
            }
            else
            {
                HttpContext.Current.Response.Write("获取失败!");
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write(ex.Message);
        }
    }

    private void weixin_menu_add()
    {
        try
        {
            string oplevel = HttpContext.Current.Request["oplevel"].ToString();//菜单级别
            string txtMenuName = HttpContext.Current.Request["txtMenuName"].ToString();//菜单标题
            string rdoMenu = HttpContext.Current.Request["rdoMenu"].ToString();//菜单类型  click/view
            string txtKEY = HttpContext.Current.Request["txtKEY"].ToString();//菜单KEY值，用于消息接口推送，不超过128字节
            string txtURL = HttpContext.Current.Request["txtURL"].ToString();//网页链接，用户点击菜单可打开链接，不超过256字节
            string insertSqlText = string.Empty;
            string selectSqlText = string.Empty;
            int menuCount = 0;

            //selectSqlText = "select count(*) from g_weixin_menu where m_fid=@m_fid";
            //System.Data.OleDb.OleDbParameter[] paras = { new System.Data.OleDb.OleDbParameter("m_fid", oplevel) };
            selectSqlText = "select count(*) from g_weixin_menu where m_fid='" + oplevel + "'";
            object o = guandongren.MakehtmlSQL.Query_object(selectSqlText);
            if (o != null)
            {
                menuCount = Convert.ToInt32(o);
            }
            //判断菜单MAX
            if (oplevel == "0")
            {
                if (menuCount >= 3)
                {
                    HttpContext.Current.Response.Write("一级菜单不能超过3个");
                    return;
                }
            }
            else
            {
                if (menuCount >= 5)
                {
                    HttpContext.Current.Response.Write("二级菜单不能超过5个");
                    return;
                }
            }
            insertSqlText = "insert into g_weixin_menu (m_type,m_fid,m_name,m_key,m_url) values (@m_type,@m_fid,@m_name,@m_key,@m_url)";
            System.Data.OleDb.OleDbParameter[] param ={ new System.Data.OleDb.OleDbParameter ("@m_type",rdoMenu),
                                                        new System.Data.OleDb.OleDbParameter ("@m_fid",oplevel),
                                                        new System.Data.OleDb.OleDbParameter ("@m_name",txtMenuName),
                                                        new System.Data.OleDb.OleDbParameter ("@m_key",txtKEY),
                                                        new System.Data.OleDb.OleDbParameter ("@m_url",txtURL)
                                                      };
            int j = guandongren.MakehtmlSQL.ExecuteSql(insertSqlText, param);
            if (j > 0)
            {
                Main.Create_log("添加菜单:" + txtMenuName, "", HttpContext.Current.Request.Cookies["admin"].Value);
                HttpContext.Current.Response.Write("ok");

            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write(ex.Message);
        }
    }

    //上传微信菜单
    private void weixin_menu_upload()
    {
        string selectSqlText = string.Empty;
        StringBuilder jsonStr = new StringBuilder();
        string selectSqlC = string.Empty;
        string selectSqlF = string.Empty;

        try
        {
            selectSqlF = "select m_id,m_type,m_fid,m_name,m_key,m_url from g_weixin_menu where m_fid='0' order by m_order asc";
            List<WeixinMenu> list = new List<WeixinMenu>();
            WeixinMenu menu;

            using (System.Data.OleDb.OleDbDataReader reader = guandongren.MakehtmlSQL.ExecuteReader(selectSqlF, new System.Data.OleDb.OleDbParameter[] { }))
            {
                while (reader.Read())
                {
                    menu = new WeixinMenu();
                    menu.id = reader["m_id"].ToString();
                    menu.type = reader["m_type"].ToString();
                    menu.fid = reader["m_fid"].ToString();
                    menu.name = reader["m_name"].ToString();
                    menu.key = reader["m_key"].ToString();
                    menu.url = reader["m_url"].ToString();
                    list.Add(menu);
                }
            }

            for (int i = 0; i < list.Count; i++)
            {
                selectSqlC = "select m_id,m_type,m_fid,m_name,m_key,m_url from g_weixin_menu where m_fid='" + list[i].id + "' order by m_order asc";
                using (System.Data.OleDb.OleDbDataReader reader = guandongren.MakehtmlSQL.ExecuteReader(selectSqlC, new System.Data.OleDb.OleDbParameter[] { }))
                {
                    while (reader.Read())
                    {
                        menu = new WeixinMenu();
                        menu.id = reader["m_id"].ToString();
                        menu.type = reader["m_type"].ToString();
                        menu.fid = reader["m_fid"].ToString();
                        menu.name = reader["m_name"].ToString();
                        menu.key = reader["m_key"].ToString();
                        menu.url = reader["m_url"].ToString();
                        list[i].WeixinMenuList.Add(menu);
                    }
                }
            }
            jsonStr.AppendLine("{");
            jsonStr.AppendLine(" \"button\":[");
            for (int i = 0; i < list.Count; i++)
            {
                jsonStr.AppendLine("{");
                if (list[i].WeixinMenuList.Count == 0)//没有子菜单
                {
                    jsonStr.AppendLine("\"type\":\"" + list[i].type + "\",");
                    jsonStr.AppendLine("\"name\":\"" + list[i].name + "\",");
                    if (list[i].type == "click")
                    {
                        jsonStr.AppendLine("\"key\":\"" + list[i].key + "\"");
                    }
                    else if (list[i].type == "view")
                    {
                        jsonStr.AppendLine("\"url\":\"" + list[i].url + "\"");
                    }

                }
                else//存在子菜单
                {
                    jsonStr.AppendLine("\"name\":\"" + list[i].name + "\",");
                    jsonStr.AppendLine("\"sub_button\":[");
                    //遍历子菜单
                    for (int j = 0; j < list[i].WeixinMenuList.Count; j++)
                    {
                        jsonStr.AppendLine("{");
                        jsonStr.AppendLine("\"type\":\"" + list[i].WeixinMenuList[j].type + "\",");
                        jsonStr.AppendLine("\"name\":\"" + list[i].WeixinMenuList[j].name + "\",");
                        if (list[i].WeixinMenuList[j].type == "click")
                        {
                            jsonStr.AppendLine("\"key\":\"" + list[i].WeixinMenuList[j].key + "\"");
                        }
                        else if (list[i].WeixinMenuList[j].type == "view")
                        {
                            jsonStr.AppendLine("\"url\":\"" + list[i].WeixinMenuList[j].url + "\"");
                        }
                        jsonStr.AppendLine("}");
                        if (j != list[i].WeixinMenuList.Count - 1)
                        {
                            jsonStr.Append(",");
                        }
                    }
                    jsonStr.Append("]");
                }
                jsonStr.AppendLine("}");
                if (i != list.Count - 1)
                {
                    jsonStr.Append(",");
                }
            }
            jsonStr.AppendLine("]");
            jsonStr.AppendLine("}");

            string result = WeiXinAPI.WeiXinCommon.CreateWeixinMenu(access_token, jsonStr.ToString());
            HttpContext.Current.Response.Write(result);

        }
        catch (Exception ex)
        {

            HttpContext.Current.Response.Write(ex.Message);
        }
    }

    //下载微信菜单到本地
    private void weixin_menu_download()
    {
        string menuJsonStr = string.Empty;
        List<WeixinMenu> listMenu = new List<WeixinMenu>();//父菜单
        List<WeixinMenu> listMenuSub;//子菜单
        try
        {
            menuJsonStr = WeiXinAPI.WeiXinCommon.Get_WeixinMenu(access_token);

            if (!WeiXinAPI.JsonOprate.IsError(menuJsonStr))
            {
                menuJsonStr = menuJsonStr.Replace("{\"menu\":{\"button\":[", "").Replace("]}}", "");
                List<string> list = getBraceContent(menuJsonStr);
                WeixinMenu menu;//父菜单
                for (int i = 0; i < list.Count; i++)
                {
                    menu = new WeixinMenu();
                    //为父菜单赋值
                    WeiXinAPI.JsonOprate.GetPro(menu, list[i]);
                    if (menu.sub_button.Trim() == "[]")//不存在子菜单
                    {

                    }
                    else//存在子菜单
                    {
                        listMenuSub = new List<WeixinMenu>();
                        List<string> listsub = getBraceContent(menu.sub_button);
                        WeixinMenu menusub;//子菜单
                        for (int j = 0; j < listsub.Count; j++)
                        {
                            menusub = new WeixinMenu();
                            //为子菜单赋值
                            WeiXinAPI.JsonOprate.GetPro(menusub, listsub[j]);
                            listMenuSub.Add(menusub);
                        }
                        menu.WeixinMenuList = listMenuSub;
                    }
                    listMenu.Add(menu);
                }


                //入库
                if (listMenu.Count > 0)
                {
                    string deleteSqlText = "delete from g_weixin_menu";
                    string insertSqlText = string.Empty;
                    guandongren.MakehtmlSQL.ExecuteSql(deleteSqlText);

                    for (int i = 0; i < listMenu.Count; i++)
                    {
                        //父菜单入库
                        insertSqlText = "insert into g_weixin_menu (m_type,m_fid,m_name,m_key,m_url) values (@m_type,@m_fid,@m_name,@m_key,@m_url)";
                        System.Data.OleDb.OleDbParameter[] param ={ new System.Data.OleDb.OleDbParameter ("@m_type",listMenu[i].type==null?"":listMenu[i].type),
                                                        new System.Data.OleDb.OleDbParameter ("@m_fid","0"),
                                                        new System.Data.OleDb.OleDbParameter ("@m_name",listMenu[i].name),
                                                        new System.Data.OleDb.OleDbParameter ("@m_key",listMenu[i].key==null?"":listMenu[i].key),
                                                        new System.Data.OleDb.OleDbParameter ("@m_url",listMenu[i].url==null?"":listMenu[i].url)
                                                      };
                        int mid = guandongren.MakehtmlSQL.Add(insertSqlText, param);
                        if (listMenu[i].WeixinMenuList.Count > 0)//存在子菜单
                        {
                            for (int j = 0; j < listMenu[i].WeixinMenuList.Count; j++)
                            {
                                insertSqlText = "insert into g_weixin_menu (m_type,m_fid,m_name,m_key,m_url) values (@m_type,@m_fid,@m_name,@m_key,@m_url)";
                                System.Data.OleDb.OleDbParameter[] paramsub ={ new System.Data.OleDb.OleDbParameter ("@m_type",listMenu[i].WeixinMenuList[j].type),
                                                        new System.Data.OleDb.OleDbParameter ("@m_fid",mid.ToString()),
                                                        new System.Data.OleDb.OleDbParameter ("@m_name",listMenu[i].WeixinMenuList[j].name),
                                                        new System.Data.OleDb.OleDbParameter ("@m_key",listMenu[i].WeixinMenuList[j].key==null?"":listMenu[i].WeixinMenuList[j].key),
                                                        new System.Data.OleDb.OleDbParameter ("@m_url",listMenu[i].WeixinMenuList[j].url==null?"":listMenu[i].WeixinMenuList[j].url)
                                                      };

                                guandongren.MakehtmlSQL.ExecuteSql(insertSqlText, paramsub);
                            }

                        }
                    }
                    HttpContext.Current.Response.Write("ok");
                }
                else
                {
                    HttpContext.Current.Response.Write("服务器菜单为空!");
                }
            }
            else
            {
                WeiXinAPI.ErrorMessageObject err = WeiXinAPI.JsonOprate.GetError(menuJsonStr);
                HttpContext.Current.Response.Write(err.errmsg);
            }
        }
        catch (Exception ex)
        {

            HttpContext.Current.Response.Write(ex.Message);
        }
    }

    //获取花括号中的内容
    private List<string> getBraceContent(string str)
    {
        List<string> l = new List<string>();
        string newstr = string.Empty;
        int bracketsCount = 0;//方括号数量
        bool read = false;
        for (int i = 0; i < str.Length; i++)
        {

            if (str[i] == '{')//找到第一个"{"
            {
                read = true;
            }

            if (read)
            {
                newstr += str[i];
                if (str[i] == '[')
                {
                    bracketsCount += 1;
                }
                else if (str[i] == ']')
                {
                    bracketsCount -= 1;
                }
                else if (str[i] == '}')
                {
                    if (bracketsCount == 0)//所有方括号都已闭合
                    {
                        l.Add(newstr);
                        newstr = string.Empty;
                        read = false;
                    }
                }
            }

        }
        return l;

    }

    private int getvalue(string sql)
    {
        int i = 0;
        object obj = guandongren.MakehtmlSQL.Query_object(sql);
        if (Main.isNumber(new string[] { obj.ToString() }))
        {
            i = Convert.ToInt32(obj);
        }
        return i;
    }
    public bool IsReusable
    {
        get
        {
            return false;
        }
    }

}


public class WeixinMenu : WeiXinAPI.JsonObject
{
    private string _m_id;
    private string _m_fid;
    private string _m_type;
    private string _m_name;
    private string _m_key;
    private string _m_url;
    private string _sub_button;
    private List<WeixinMenu> _WeixinMenuList = new List<WeixinMenu>();

    public string id { get { return _m_id; } set { _m_id = value; } }
    public string fid { get { return _m_fid; } set { _m_fid = value; } }
    public string type { get { return _m_type; } set { _m_type = value; } }
    public string name { get { return _m_name; } set { _m_name = value; } }
    public string key { get { return _m_key; } set { _m_key = value; } }
    public string url { get { return _m_url; } set { _m_url = value; } }
    public string sub_button { get { return _sub_button; } set { _sub_button = value; } }
    public List<WeixinMenu> WeixinMenuList { get { return _WeixinMenuList; } set { _WeixinMenuList = value; } }
}