﻿<%@ WebHandler Language="C#" Class="operate" %>

using System;
using System.Web;

public class operate : IHttpHandler, System.Web.SessionState.IRequiresSessionState
{
    public string p;
    public void ProcessRequest(HttpContext context)
    {
        //if (!Main.IsMobileDevice())
        //{
        //    HttpContext.Current.Response.End();
        //    return;
        //}
        context.Response.ContentType = "text/plain";

        string a = context.Request.Params["a"];
        p = context.Request.Params["p"];//显示数
        switch (a)
        {
            case "like"://首页资讯
                indexlike();
                break;
            case "products"://分类筛选后产品列表
                products();
                break;
            case "allproducts"://所有产品分类显示
                allproducts();
                break;
                
            case "all_information":
                all_information();
                break;
            case "information_list":
                information_list();
                break;
            case "message":
                message();
                break;
            default:
                break;
        }
    }

    /// <summary>
    /// 获取所有资讯列表页
    /// </summary>
    private void all_information()
    {
        string where = "";
        int p_count = 0;
        if (p != null && p != "")
        {
            p_count = Convert.ToInt16(p);
        }
        if (p_count > 0)
        {
            where = "where n_id <" + p_count + " ";
        }
        System.Data.DataTable dt = new System.Data.DataTable();
        string sql = "select top 5 n_id,n_title  from g_news " + where+ " order by n_id desc";
        dt = guandongren.MakehtmlSQL.Query(sql).Tables[0];
        string ss = "";
        if (dt.Rows.Count > 0)
        {
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                ss += "<li id='" + dt.Rows[i]["n_id"] + "'><a href=\"bases.aspx?pageid=information_info&id=" + dt.Rows[i]["n_id"] + "\" data-transition=\"slide\">" + Main.CutString(dt.Rows[i]["n_title"].ToString() + ",15") + "</a></li>";
            }
        }
        HttpContext.Current.Response.Write(ss.ToString());

    }
    
    /// <summary>
    /// 资讯分类列表页
    /// </summary>
    private void information_list()
    {
        string where = "";
        string cid = HttpContext.Current.Request["classid"];
        int p_count = 0;
        if (p != null && p != "")
        {
            p_count = Convert.ToInt16(p);
        }
        if (cid != "")
        {
            where = "n_classid=" + cid;
        }
        if (p_count > 0)
        {
            where = "and n_id <" + p_count + " ";
        }

        System.Data.DataTable dt = new System.Data.DataTable();
        string sql = "select top 5 n_id,n_date,n_title from g_news where " + where + " order by n_id desc";
        dt = guandongren.MakehtmlSQL.Query(sql).Tables[0];
        string ss = "";
        if (dt.Rows.Count > 0)
        {
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                ss += "<li id='" + dt.Rows[i]["n_id"] + "'><a href=\"bases.aspx?pageid=information_info&id=" + dt.Rows[i]["n_id"] + "\" data-transition=\"slide\">" + Main.CutString(dt.Rows[i]["n_title"].ToString() + ",10") + "";
                ss += "<span>&nbsp;&nbsp;" + Main.DateFormat(dt.Rows[i]["n_date"].ToString() + ",yyyy-MM-dd") + "</span></a></li>";
            }
        }
        HttpContext.Current.Response.Write(ss.ToString());

    }


    /// <summary>
    /// 根据产品分类进行筛选内容
    /// </summary>
    private void products()
    {
        try
        {
            string where = "";
            string cid = HttpContext.Current.Request.Params["classid"];
            int p_count = 0;
            if (p != null && p != "")
            {
                p_count = Convert.ToInt16(p);
            }
            if (cid != "")
            {
                where = "p_classid=" + cid;
            }
            if (p_count > 0)
            {
                where += "and p_id <" + p_count + " ";
            }
            string ss = "";
            System.Data.DataTable s = guandongren.MakehtmlSQL.GetList("select top 4 p_name,p_img,p_id from g_product where " + where + "").Tables[0];
            int item = 0;
            foreach (System.Data.DataRow dd in s.Rows)
            {
              
                if (item % 2 == 0)
                {
                    ss += "<li id='" + dd["p_id"] + "'><div class='ui-grid-a  content_type_info'>";
                    ss += "  <div class='ui-block-a'><a href='bases.aspx?pageid=product_info&id=" + dd["p_id"] + "' data-transition='slide'>";
                    ss += "  <img src='/UploadFiles/pre_" + dd["p_img"] + "'/><br/>";
                    ss += " <span>" + cutstr(dd["p_name"].ToString(), 4) + " </span>";
                    ss += " </a></div>";
                    ss += "";
                 
                }
                else
                {

                    ss += "";
                    ss += "  <div class='ui-block-b'><a href='bases.aspx?pageid=product_info&id=" + dd["p_id"] + "' data-transition='slide'>";
                    ss += "  <img src='/UploadFiles/pre_" + dd["p_img"] + "'/><br/>";
                    ss += " <span>" + cutstr(dd["p_name"].ToString(), 4) + " </span>";
                    ss += " </a></div>";
                    ss += "</div></li>";

                }

                item = item + 1;
            }

            HttpContext.Current.Response.Write(ss);
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write("错误:" + ex.Message);
            return;
        }
    }
    
    /// <summary>
    /// 根据所有商品列表
    /// </summary>
    private void allproducts()
    {
        try
        {
            string ss = "";
            System.Data.DataTable s = guandongren.MakehtmlSQL.GetList("select p_id,p_name from g_p_class where p_classid=0").Tables[0];
            foreach (System.Data.DataRow dd in s.Rows)
            {
              
                ss+="<li><a href=\"bases.aspx?pageid=product_list&id="+dd["p_id"]+"\" data-transition=\"slide\">"+dd["p_name"]+"</a></li>";
                ss+="<li><div class='ui-grid-a content_type_info'>";
                ss+=Main.get_list_class(int.Parse(dd["p_id"].ToString()));
                ss+="</div></li>";
            }

            HttpContext.Current.Response.Write(ss);
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write("错误:" + ex.Message);
            return;
        }
    }
    /// <summary>
    /// 首页资讯文章
    /// </summary>
    private void indexlike()
    {
        try
        {
            System.Data.DataSet ds = null;
            string ss = null;
            string sql = "select top 4  n_id,n_title,n_date from g_news order by n_id desc";
            ds = guandongren.MakehtmlSQL.Query(sql);
            if (ds != null && ds.Tables[0].Rows.Count > 0)
            {
                foreach (System.Data.DataRow dd in ds.Tables[0].Rows)
                {
                    ss += "<li>";
                    ss += "  <a href='bases.aspx?pageid=information_info&id=" + dd["n_id"] + "' data-transition='slide'>" + cutstr(dd["n_title"].ToString(), 10) + "<span>&nbsp;&nbsp;" + DateFormat(dd["n_date"].ToString(), "yyyy-MM-dd") + "</span></a>";
                    ss += "</li>";
                }

                HttpContext.Current.Response.Write(ss.ToString());
            }
            else
            {
                HttpContext.Current.Response.Write("没有数据");
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write("错误:" + ex.Message);
            return;
        }
    }

    private bool ExistUserName(string phone)
    {
        string password = string.Empty;
        string userid = string.Empty;
        if (ExistUserName(phone, ref  password, ref userid))
        {
            return true;
        }
        return false;
    }

    private bool ExistUserName(string phone, ref string password, ref string userid)
    {
        string sql = "select * from s_member where m_phone=@m_phone";
        System.Data.OleDb.OleDbParameter[] param = { new System.Data.OleDb.OleDbParameter("@m_phone", phone) };

        System.Data.DataSet ds = guandongren.MakehtmlSQL.GetList(sql, param);
        if (ds.Tables[0].Rows.Count > 0)
        {
            password = ds.Tables[0].Rows[0]["m_password"].ToString();
            userid = ds.Tables[0].Rows[0]["m_id"].ToString();
            return true;
        }
        return false;
    }

    /// <summary>
    /// 用户留言
    /// </summary>
    /// <returns></returns>
    private void message()
    {
        try
        {
            string u_username = HttpContext.Current.Request.Params["username"];
            string usertel = HttpContext.Current.Request.Params["usertel"];
            string askinfo = HttpContext.Current.Request.Params["askinfo"];

            if (u_username != "" && usertel != "" && askinfo != "")
            {
                string sql = "insert into g_message(m_name,m_tel,m_time,m_desc)values(@m_username,@m_tel,@m_time,@m_content)";
                System.Data.OleDb.OleDbParameter[] param = { 
                                                           new System.Data.OleDb.OleDbParameter("@m_username", u_username),
                                                           new System.Data.OleDb.OleDbParameter("@m_tel", usertel),
                                                           new System.Data.OleDb.OleDbParameter("@m_time", DateTime.Now),
                                                           new System.Data.OleDb.OleDbParameter("@m_content", askinfo),
                                                       };

                int ds = guandongren.MakehtmlSQL.Add(sql, param);
                if (ds > 0)
                {
                    HttpContext.Current.Response.Write("ok");
                }
                else
                {

                    HttpContext.Current.Response.Write("false");
                }
            }
        }catch(Exception e)
        {
            HttpContext.Current.Response.Write(e.Message);
        }
    }

    private int AddPoint(string userid, decimal point)
    {
        int j = 0;
        System.Data.OleDb.OleDbParameter[] param ={
                                   new System.Data.OleDb.OleDbParameter("@m_userid",userid)
                                            };

        string sql = "update s_member set m_point=m_point+" + point + ", m_cost=m_cost+" + point + " where m_id=@m_userid";
        try
        {
            j = guandongren.MakehtmlSQL.ExecuteSql(sql, param);
        }
        catch (Exception ex)
        {

            HttpContext.Current.Response.Write(ex.Message);
        }
        return j;

    }

    public bool IsReusable
    {
        get
        {
            return false;
        }
    }


    //截取字符串
    private string cutstr(string str, int count)
    {
        // str = str.TrimStart(new char[] { '<', 'p', '>' }).TrimEnd(new char[] { '<', '/', 'p', '>' });
        str = System.Text.RegularExpressions.Regex.Replace(str, @"<[^{><}]*>", "", System.Text.RegularExpressions.RegexOptions.IgnoreCase);
        if (str != null && str.Length > count)
        {
            str = str.Substring(0, count);
        }
        return str;

    }


    private string DateFormat(string str, string ss)
    {

        return Convert.ToDateTime(str).ToString(ss);
    }
    //获得分页数据
    private System.Data.DataSet getPage(string pageindex, string pagesize, string table, string order, string where)
    {
        System.Data.DataSet ds = null;
        string sql = string.Format(@"
                    SELECT distinct TOP {0} * 
                FROM 
                        (
                        SELECT ROW_NUMBER() OVER ({1}) AS RowNumber,* FROM {2} {3}
                        ) A
                WHERE RowNumber > {4}*({5}-1) ", pagesize, order, table, where, pagesize, pageindex);

        try
        {
            ds = guandongren.MakehtmlSQL.Query(sql);
        }
        catch (Exception ex)
        {

            HttpContext.Current.Response.Write(ex.Message);
        }

        return ds;
    }

}

