﻿<%@ WebHandler Language="C#" Class="Admin_add" %>

using System;
using System.Web;

public class Admin_add : IHttpHandler
{

    public void ProcessRequest(HttpContext context)
    {
        context.Response.ContentType = "text/plain";
        Main make_htm = new Main();
        string T = context.Request["T"];
        switch (T)
        {
            case "Create_table":
                Table_add();
                break;
            case "Create_model":
                Create_model();
                break;
            case "menu":
                MenuAdd();
                break;
            case "param":
                ParamAdd();
                break;
            case "makehtml":
                Makehtml();
                break;
            case "web_add":
                web_add();
                break;
            case "weixin_welcome":
                weixin_welcome();
                break;
            case "weixin_material_add"://添加素材
                weixin_material_add();
                break;
            case "weixin_usergroup_add":
                weixin_usergroup_add();
                break;
            case "mobileweb_add"://添加微信网站
                mobileweb_add();
                break;
            case "g_subject_user":
                g_subject_user();
                break;

            case "Createslect":
                Createslect();
                break;


        }
    }

    public bool IsReusable
    {
        get
        {
            return false;
        }
    }


    /// <summary>
    /// 添加表结构
    /// </summary>
    private void g_subject_user()
    {
        try
        {
            string S_sid = HttpContext.Current.Request.Form["s_sid"].Trim();
            string Class_2 = HttpContext.Current.Request.Form["class_2"];
            string S_openid = HttpContext.Current.Request.Form["s_openid"];

            if (Main.CheckNull(S_sid, S_openid))
            {
                string[] str_open = S_openid.Split(',');
                int ok = 0;
                for (int i = 0; i < str_open.Length; i++)
                {
                    if (str_open[i] != "")
                    {
                        string sql = "insert into g_subject_user(s_sid,s_openid,s_order) values(@S_sid,@S_openid,@S_order)";
                        System.Data.SqlClient.SqlParameter[] param ={
                                   new System.Data.SqlClient.SqlParameter("@S_sid",S_sid),
                                   new System.Data.SqlClient.SqlParameter("@S_openid",str_open[i]),
                                   new System.Data.SqlClient.SqlParameter("@S_order",0)
                                            };
                        ok = guandongren.MakehtmlSQL.Add(sql, param) + 1;
                    }

                }

                if (ok > 0)
                {
                    // Main.Create_log("创建数据库" + t_name + "表", "", HttpContext.Current.Request.Cookies["admin"].Value);
                    HttpContext.Current.Response.Write("ok");
                }
            }
            else
            {
                HttpContext.Current.Response.Write("请将资料填写完整！");
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write("错误，" + ex.Message);
        }
    }
    /// <summary>
    /// 创建下拉框select
    /// </summary>
    private void Createslect()
    {
        string table = HttpContext.Current.Request.Params["Stable"];
        string value = HttpContext.Current.Request.Params["Svalue"];
        string itemid = HttpContext.Current.Request.Params["itemid"];
        try
        {
            switch (table)
            {
                case "g_company":

                    if (itemid == "1")
                    {
                        string return_str = "";
                        object classid = guandongren.MakehtmlSQL.Query_object("select c_classid from " + table + " where c_id=" + value);
                        if (classid != null)
                        {
                            System.Data.DataTable select = guandongren.MakehtmlSQL.Query("select p_id,p_name,p_classid from g_p_class where p_level=1").Tables[0];
                            for (int i = 0; i < select.Rows.Count; i++)
                            {
                                if (select.Rows[i]["p_id"].ToString() == classid.ToString())
                                {
                                    return_str += "<option value='" + select.Rows[i]["p_id"] + "' selected='true'>" + select.Rows[i]["p_name"] + "</option>";
                                }
                                else
                                {
                                    return_str += "<option value='" + select.Rows[i]["p_id"] + "'>" + select.Rows[i]["p_name"] + "</option>";
                                }

                                //二级分类

                                System.Data.DataTable select_t = guandongren.MakehtmlSQL.Query("select p_id,p_name,p_classid from g_p_class where p_level=2 and p_classid=" + select.Rows[i]["p_id"]).Tables[0];
                                for (int j = 0; j < select_t.Rows.Count; j++)
                                {
                                    //return_str += "<option value='" + select_t.Rows[j]["p_id"] + "'>┝━━" + select_t.Rows[j]["p_name"] + "</option>";

                                    if (select_t.Rows[j]["p_id"].ToString() == classid.ToString())
                                    {
                                        return_str += "<option value='" + select_t.Rows[j]["p_id"] + "' selected='true'>┝━━" + select_t.Rows[j]["p_name"] + "</option>";
                                    }
                                    else
                                    {
                                        return_str += "<option value='" + select_t.Rows[j]["p_id"] + "'>┝━━" + select_t.Rows[j]["p_name"] + "</option>";
                                    }
                                }
                            }

                        }
                        HttpContext.Current.Response.Write(return_str);
                    }

                    if (itemid == "2")
                    {
                        string return_str = "";
                        object classid = guandongren.MakehtmlSQL.Query_object("select c_add from " + table + " where c_id=" + value);
                        if (classid != null)
                        {
                            System.Data.DataTable select = guandongren.MakehtmlSQL.Query("select a_id,a_name,a_classid from g_add where a_classid=0").Tables[0];
                            for (int i = 0; i < select.Rows.Count; i++)
                            {
                                if (select.Rows[i]["a_id"].ToString() == classid.ToString())
                                {
                                    return_str += "<option value='" + select.Rows[i]["a_id"] + "' selected='true'>" + select.Rows[i]["a_name"] + "</option>";
                                }
                                else
                                {
                                    return_str += "<option value='" + select.Rows[i]["a_id"] + "'>" + select.Rows[i]["a_name"] + "</option>";
                                }

                                //二级分类

                                System.Data.DataTable select_t = guandongren.MakehtmlSQL.Query("select a_id,a_name,a_classid from g_add where a_classid=" + select.Rows[i]["a_id"]).Tables[0];
                                for (int j = 0; j < select_t.Rows.Count; j++)
                                {
                                    if (select_t.Rows[j]["a_id"].ToString() == classid.ToString())
                                    {
                                        return_str += "<option value='" + select_t.Rows[j]["a_id"] + "' selected='true'>┝━━" + select_t.Rows[j]["a_name"] + "</option>";
                                    }
                                    else
                                    {
                                        return_str += "<option value='" + select_t.Rows[j]["a_id"] + "'>┝━━" + select_t.Rows[j]["a_name"] + "</option>";
                                    }
                                }
                            }

                        }
                        HttpContext.Current.Response.Write(return_str);
                    }
                    break;

                case "g_article":

                    string Treturn_str = "";
                    object Tclassid = guandongren.MakehtmlSQL.Query_object("select a_code from " + table + " where a_id=" + value);
                    if (Tclassid != null)
                    {
                        System.Data.DataTable select = guandongren.MakehtmlSQL.Query("select c_name,c_openid from g_company where c_openid is not null").Tables[0];
                        for (int i = 0; i < select.Rows.Count; i++)
                        {
                            if (select.Rows[i]["c_openid"].ToString() == Tclassid.ToString())
                            {
                                Treturn_str += "<option value='" + select.Rows[i]["c_openid"] + "' selected='true'>" + select.Rows[i]["c_name"] + "</option>";
                            }
                            else
                            {
                                Treturn_str += "<option value='" + select.Rows[i]["c_openid"] + "'>" + select.Rows[i]["c_name"] + "</option>";
                            }

                        }
                         
                    }
                    HttpContext.Current.Response.Write(Treturn_str);

                    break;

            }
        }
        catch (Exception e)
        {
            HttpContext.Current.Response.Write(e.Message);
        }

        return;
    }

    /// <summary>
    /// 添加表结构
    /// </summary>
    private void Table_add()
    {
        try
        {
            string t_name = HttpContext.Current.Request.Form["t_name"].Trim();
            string t_tablename = HttpContext.Current.Request.Form["t_tablename"];
            string t_template = HttpContext.Current.Request.Form["t_template"];

            if (Main.CheckNull(t_name, t_tablename))
            {
                bool isCreate = guandongren.MakehtmlSQL.CreateNewTable(t_tablename);
                if (isCreate)
                {
                    string sql = "insert into g_table(t_name,t_tablename,t_template) values(@t_name,@t_tablename,@t_template)";
                    System.Data.SqlClient.SqlParameter[] param ={
                                   new System.Data.SqlClient.SqlParameter("@t_name",t_name),
                                   new System.Data.SqlClient.SqlParameter("@t_tablename",t_tablename),
                                   new System.Data.SqlClient.SqlParameter("@t_template",t_template)
                                            };
                    int j = guandongren.MakehtmlSQL.Add(sql, param);
                    if (j > 0)
                    {
                        Main.Create_log("创建数据库" + t_name + "表", "", HttpContext.Current.Request.Cookies["admin"].Value);
                        HttpContext.Current.Response.Write("ok");
                    }
                }
                else
                {
                    HttpContext.Current.Response.Write("表创建失败！");
                    return;
                }
            }
            else
            {
                HttpContext.Current.Response.Write("请将资料填写完整！");
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write("错误，" + ex.Message);
        }
    }


    /// <summary>
    /// 添加表字段
    /// </summary>
    /// <param name="id"></param>
    private void Create_model()
    {
        try
        {
            string m_name = HttpContext.Current.Request.Form["m_name"];
            string m_type = HttpContext.Current.Request.Form["m_type"];
            string m_ismust = HttpContext.Current.Request.Form["m_ismust"];
            string m_order = HttpContext.Current.Request.Form["m_order"];
            string m_itemtype = HttpContext.Current.Request.Form["m_itemtype"];
            string m_itemname = HttpContext.Current.Request.Form["m_itemname"];
            string m_table = HttpContext.Current.Request.Form["m_table"];
            string m_show = HttpContext.Current.Request.Form["m_show"];
            string m_label = HttpContext.Current.Request.Form["m_label"];

            if (Main.CheckNull(m_name, m_table, m_type, m_order, m_itemtype, m_itemname))
            {
                object issi = guandongren.MakehtmlSQL.Query_object("select m_id from g_model where (m_table='" + m_table + "' and m_itemname='" + m_itemname + "') or (m_table='" + m_table + "' and m_order='" + m_order + "')");
                if (issi == null)
                {
                    bool is_create = guandongren.MakehtmlSQL.Create_Colunm(m_table, m_itemname, m_itemtype);

                    if (is_create)
                    {

                        string sql = "insert into g_model(m_name,m_type,m_ismust,m_order,m_itemtype,m_itemname,m_table,m_show,m_label) values(@m_name,@m_type,@m_ismust,@m_order,@m_itemtype,@m_itemname,@m_table,@m_show,@m_label)";
                        System.Data.SqlClient.SqlParameter[] param ={new System.Data.SqlClient.SqlParameter("@m_name",m_name),
                                        new System.Data.SqlClient.SqlParameter("@m_type",m_type),
                                        new System.Data.SqlClient.SqlParameter("@m_ismust",m_ismust),
                                        new System.Data.SqlClient.SqlParameter("@m_order",m_order),
                                        new System.Data.SqlClient.SqlParameter("@m_itemtype",m_itemtype),
                                        new System.Data.SqlClient.SqlParameter("@m_itemname",m_itemname),
                                        new System.Data.SqlClient.SqlParameter("@m_table",m_table),
                                        new System.Data.SqlClient.SqlParameter("@m_show",m_show),
                                        new System.Data.SqlClient.SqlParameter("@m_label",m_label)};
                        int j = guandongren.MakehtmlSQL.Add(sql, param);
                        if (j > 0)
                        {
                            Main.Create_log("创建数据库字段" + m_name, "", HttpContext.Current.Request.Cookies["admin"].Value);
                            HttpContext.Current.Response.Write("ok");
                            return;
                        }


                    }
                    else
                    {
                        HttpContext.Current.Response.Write("字段创建失败！");
                        return;
                    }
                }
                else
                {
                    HttpContext.Current.Response.Write("字段名称已存在或者排序数相同！");
                    return;
                }
            }
            else
            {
                HttpContext.Current.Response.Write("内容不能为空！");
                return;
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write("错误，" + ex.Message + "");
        }
    }


    /// <summary>
    /// 添加内容
    /// </summary>
    private void web_add()
    {

        try
        {
            string table_id = HttpContext.Current.Request.Form["table_id"];
            string[] upfiles = HttpContext.Current.Request.Files.AllKeys;
            System.Collections.Generic.List<string> uplist = new System.Collections.Generic.List<string>();
            System.Collections.Generic.Dictionary<string, string> Dir = new System.Collections.Generic.Dictionary<string, string>();
            if (Main.CheckNull(table_id))
            {

                int F_list = HttpContext.Current.Request.Files.Count;
                for (int i = 0; i < F_list; i++)
                {
                    string filename = "";
                    HttpPostedFile file = HttpContext.Current.Request.Files[i];
                    if (file.ContentLength > 0)
                    {
                        string FileName = Main.getRandomNum(6, 1, 100) + i;
                        filename = Fileuploads.UploadImg(FileName, "/UploadFiles/", 300, 300, 300, file, "jpg,gif,bmp,png,jpeg");
                        filename = "/UploadFiles/" + filename;
                        if (filename.Contains("上传失败"))
                        {
                            HttpContext.Current.Response.Write(filename);
                            return;
                        }
                    }

                    uplist.Add(upfiles[i] + "," + filename);

                }


                //table_id=p_classid
                System.Data.DataTable ds = guandongren.MakehtmlSQL.Query("select m_itemname,m_type,m_ismust,m_name from g_model where m_table='" + table_id + "' order by m_order asc").Tables[0];
                if (ds.Rows.Count > 0)
                {
                    string sql = "insert into " + table_id + "(";
                    string sql1 = "";
                    string sql2 = "";
                    string Table_ = "";
                    string Table_value = "";
                    int u = 0;
                    for (int i = 0; i < ds.Rows.Count; i++)
                    {
                        Table_ = ds.Rows[i]["m_itemname"].ToString();
                        Table_value = HttpContext.Current.Request.Params[Table_];

                        if (ds.Rows[i]["m_ismust"].ToString() == "是")
                        {
                            if (string.IsNullOrEmpty(Table_value))
                            {
                                HttpContext.Current.Response.Write("【" + ds.Rows[i]["m_name"] + "】不能为空！");
                                return;
                            }
                        }

                        switch (ds.Rows[i]["m_type"].ToString())
                        {
                            case "上传":
                                for (int n = 0; n < uplist.Count; n++)
                                {
                                    if (uplist[n].Contains(Table_))
                                    {
                                        string[] imgt = uplist[n].Split(',');
                                        if (imgt[1].ToString() != "")
                                        {
                                            sql1 += Table_ + ",";
                                            sql2 += "@" + Table_ + ",";
                                            Dir.Add(Table_, imgt[1]);

                                        }
                                    }
                                }
                                break;

                            case "下拉框":
                                string[] ts = Table_value.Split(',');
                                if (ts.Length <= 1)
                                {
                                    sql1 += Table_ + ",";
                                    sql2 += "@" + Table_ + ",";
                                    Dir.Add(Table_, Table_value);
                                }
                                else
                                {
                                    sql1 += Table_ + ",";
                                    sql2 += "@" + Table_ + ",";
                                    Dir.Add(Table_, ts[0]);
                                    //附加分类属性

                                    sql1 += "p_level,";
                                    sql2 += "@p_level,";
                                    Dir.Add("p_level", ts[1]);
                                }

                                break;

                            default:
                                sql1 += Table_ + ",";
                                sql2 += "@" + Table_ + ",";
                                Dir.Add(Table_, Table_value);

                                break;

                        }

                    }

                    //最外层添加分类ID和内容   

                    sql1 = sql1.Substring(0, sql1.Length - 1);
                    sql2 = sql2.Substring(0, sql2.Length - 1);

                    sql = sql + sql1 + " ) values( " + sql2 + " )";

                    //多级分类追加处理

                    System.Data.SqlClient.SqlParameter[] param = new System.Data.SqlClient.SqlParameter[Dir.Count];

                    int tlist = 0;
                    foreach (System.Collections.Generic.KeyValuePair<string, string> item in Dir)
                    {
                        param[tlist] = new System.Data.SqlClient.SqlParameter("@" + item.Key, item.Value);
                        tlist += 1;
                    }


                    int j = guandongren.MakehtmlSQL.Add(sql, param);
                    if (j > 0)
                    {
                        //更新生成静态页配置
                        guandongren.MakehtmlSQL.ExecuteSql("update g_config set c_task=1");
                        Main.Create_log("添加内容，向" + table_id + "表添加内容", "", HttpContext.Current.Request.Cookies["admin"].Value);
                        HttpContext.Current.Response.Write("ok");
                    }
                }
                else
                {
                    HttpContext.Current.Response.Write("信息添加失败！");
                    return;
                }
            }
            else
            {
                HttpContext.Current.Response.Write("请将资料填写完整！");
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write("错误，" + ex.Message + "");
        }
    }

    /// <summary>
    /// 微信素材添加
    /// 图片（image）: 1M，支持JPG格式
    /// 语音（voice）：2M，播放长度不超过60s，支持AMR\MP3格式
    /// 视频（video）：10MB，支持MP4格式
    /// 缩略图（thumb）：64KB，支持JPG格式
    /// </summary>
    private void weixin_material_add()
    {
        try
        {
            string table_id = HttpContext.Current.Request.Form["table_id"];
            string type = HttpContext.Current.Request.QueryString["type"];
            string material_title = HttpContext.Current.Request.Form["material_title"];
            string access_token = Weixin_operate.Get_AccessToken();
            string pictext_content = HttpContext.Current.Request.Form["pictext_content"];

            if (string.IsNullOrEmpty(material_title))
            {
                HttpContext.Current.Response.Write("标题不能为空！");
                return;
            }
            if (string.IsNullOrEmpty(access_token))
            {
                HttpContext.Current.Response.Write("获取AccessToken失败!");
                return;
            }

            if (type == "news")//单图文
            {
                try
                {
                    string material_des = HttpContext.Current.Request.Form["material_des"];
                    string material_thumb_media_id = HttpContext.Current.Request.Form["material_thumb_media_id"];
                    string material_show_cover_pic = HttpContext.Current.Request.Form["material_show_cover_pic"];
                    string material_author = HttpContext.Current.Request.Form["material_author"];
                    string material_content_source_url = HttpContext.Current.Request.Form["material_content_source_url"];

                    WeiXinAPI.NewsMessage m = new WeiXinAPI.NewsMessage();
                    m.AccessToken = access_token;
                    m.digest1 = material_des;
                    m.thumbMediaId1 = material_thumb_media_id;
                    m.show_cover_pic1 = material_show_cover_pic;
                    m.url1 = material_content_source_url;

                    string json = WeiXinAPI.WeiXinCommon.UploadNews(m);
                    if (json == string.Empty)
                    {
                        HttpContext.Current.Response.Write("上传失败");
                        return;

                    }
                    if (json.Contains("errcode"))
                    {
                        //{"errcode":40004,"errmsg":"invalid media type"}
                        HttpContext.Current.Response.Write("图文文件已过期，请重新上传图片");
                        return;
                    }

                    WeiXinAPI.MediaObject media = WeiXinAPI.WeiXinCommon.Get_MediaObject(json);


                    string sql = string.Format("insert into {0} (m_name,m_type,m_content,m_des,m_thumbmediaid,m_show_cover_pic,m_author,m_content_source_url,m_createtime,m_updatetime,m_media_id,m_created_at,m_classid) values('{1}','{2}','{3}','{4}','{5}','{6}','{7}','{8}','{9}','{10}','{11}','{12}','{13}')",

                                                         table_id, material_title, type, pictext_content, material_des, material_thumb_media_id, material_show_cover_pic, material_author, material_content_source_url, System.DateTime.Now, System.DateTime.Now, media.media_id, media.created_at, 0);

                    if (guandongren.MakehtmlSQL.ExecuteSql(sql) > 0)
                    {
                        HttpContext.Current.Response.Write("ok");
                    }
                }
                catch (Exception ex)
                {

                    HttpContext.Current.Response.Write(ex.Message);
                }
            }
            else if (type == "newsmore")//多图文
            {
                try
                {
                    string img_count = HttpContext.Current.Request.Form["s_count"];
                    string[] Tmaterial_des = new string[5];
                    string[] Tmaterial_thumb_media_id = new string[5];
                    string[] Tmaterial_show_cover_pic = new string[5];
                    string[] Tmaterial_author = new string[5];
                    string[] Tmaterial_content_source_url = new string[5];
                    string[] Tclassid = new string[5];
                    string[] Tpictext_contentT = new string[5];

                    if (!string.IsNullOrEmpty(img_count))
                    {
                        WeiXinAPI.NewsMessage m = new WeiXinAPI.NewsMessage();
                        for (int i = 1; i <= Convert.ToInt16(img_count); i++)
                        {

                            string material_des = HttpContext.Current.Request.Form["material_des_" + i];
                            string material_thumb_media_id = HttpContext.Current.Request.Form["material_thumb_media_id_" + i];
                            string material_show_cover_pic = HttpContext.Current.Request.Form["material_show_cover_pic_" + i];
                            string material_author = HttpContext.Current.Request.Form["material_author_" + i];
                            string material_content_source_url = HttpContext.Current.Request.Form["material_content_source_url_" + i];
                            string pictext_contentT = HttpContext.Current.Request.Form["pictext_content_" + i];
                            string Tmaterial_title = HttpContext.Current.Request.Form["material_title" + i];
                            Tmaterial_des[i - 1] = material_des;
                            Tmaterial_thumb_media_id[i - 1] = material_thumb_media_id;
                            Tmaterial_show_cover_pic[i - 1] = material_show_cover_pic;
                            Tmaterial_author[i - 1] = material_author;
                            Tmaterial_content_source_url[i - 1] = material_content_source_url;
                            Tclassid[i - 1] = (i - 1).ToString();
                            Tpictext_contentT[i - 1] = pictext_contentT;
                            m.AccessToken = access_token;
                            if (i == 1)
                            {
                                m.digest1 = material_des;
                                m.thumbMediaId1 = material_thumb_media_id;
                                m.show_cover_pic1 = material_show_cover_pic;
                                m.url1 = material_content_source_url;
                                m.author1 = material_author;
                                m.title1 = material_title;
                                m.description1 = pictext_contentT;

                            }
                            if (i == 2)
                            {
                                m.digest2 = material_des;
                                m.thumbMediaId2 = material_thumb_media_id;
                                m.show_cover_pic2 = material_show_cover_pic;
                                m.url2 = material_content_source_url;
                                m.author2 = material_author;
                                m.title2 = Tmaterial_title;
                                m.description2 = pictext_contentT;
                            }
                            if (i == 3)
                            {
                                m.digest3 = material_des;
                                m.thumbMediaId3 = material_thumb_media_id;
                                m.show_cover_pic3 = material_show_cover_pic;
                                m.url3 = material_content_source_url;
                                m.author3 = material_author;
                                m.title3 = Tmaterial_title;
                                m.description3 = pictext_contentT;

                            }
                            if (i == 4)
                            {
                                m.digest4 = material_des;
                                m.thumbMediaId4 = material_thumb_media_id;
                                m.show_cover_pic4 = material_show_cover_pic;
                                m.url4 = material_content_source_url;
                                m.author4 = material_author;
                                m.title4 = Tmaterial_title;
                                m.description4 = pictext_contentT;
                            }
                            if (i == 5)
                            {
                                m.digest5 = material_des;
                                m.thumbMediaId5 = material_thumb_media_id;
                                m.show_cover_pic5 = material_show_cover_pic;
                                m.url5 = material_content_source_url;
                                m.author5 = material_author;
                                m.title5 = Tmaterial_title;
                                m.description5 = pictext_contentT;
                            }
                        }

                        string json = WeiXinAPI.WeiXinCommon.UploadNews(m);
                        if (json == string.Empty)
                        {
                            HttpContext.Current.Response.Write("上传失败");
                            return;

                        }
                        if (json.Contains("errcode"))
                        {
                            //{"errcode":40004,"errmsg":"invalid media type"}
                            HttpContext.Current.Response.Write("图文文件已过期，请重新上传图片");
                            return;
                        }

                        WeiXinAPI.MediaObject media = WeiXinAPI.WeiXinCommon.Get_MediaObject(json);

                        for (int j = 0; j < Convert.ToInt16(img_count); j++)
                        {
                            string sql = string.Format("insert into {0} (m_name,m_type,m_content,m_des,m_thumbmediaid,m_show_cover_pic,m_author,m_content_source_url,m_createtime,m_updatetime,m_media_id,m_created_at,m_classid) values('{1}','{2}','{3}','{4}','{5}','{6}','{7}','{8}','{9}','{10}','{11}','{12}','{13}')",

                                                            table_id, material_title, "news", Tpictext_contentT[j], Tmaterial_des[j], Tmaterial_thumb_media_id[j], Tmaterial_show_cover_pic[j], Tmaterial_author[j], Tmaterial_content_source_url[j], System.DateTime.Now, System.DateTime.Now, media.media_id, media.created_at, Tclassid[j]);

                            guandongren.MakehtmlSQL.ExecuteSql(sql);
                        }

                        HttpContext.Current.Response.Write("ok");

                    }
                }
                catch (Exception ex)
                {

                    HttpContext.Current.Response.Write(ex.Message);
                }
            }
            else if (type == "newslocal")
            {
                string news_l_des = HttpContext.Current.Request.Form["news_l_des"];
                string news_l_link = HttpContext.Current.Request.Form["news_l_link"];

                int F_list = HttpContext.Current.Request.Files.Count;
                for (int i = 0; i < F_list; i++)
                {
                    HttpPostedFile file = HttpContext.Current.Request.Files[i];
                    if (file.ContentLength > 0)
                    {
                        string FileName = Main.getRandomNum(6, 1, 100) + i;
                        string filePath = string.Empty;//保存在本地文件
                        string filename = "";
                        filename = Fileuploads.UploadImg(FileName, "/UploadFiles/Weixin/NewsLocal/", 300, 300, 300, file, "jpg");
                        filename = "/UploadFiles/Weixin/NewsLocal/" + filename;
                        if (filename.Contains("上传失败"))
                        {
                            HttpContext.Current.Response.Write("上传失败" + filename);
                            return;
                        }
                        filePath = HttpContext.Current.Server.MapPath(filename);




                        if (System.IO.File.Exists(filePath))
                        {
                            string sql = @"insert into " + table_id + " (m_name,m_type,m_url,m_content_source_url,m_createtime,m_updatetime,m_classid)  values (@m_name,@m_type,@m_url,@m_content_source_url,@m_createtime,@m_updatetime,@m_classid)";

                            System.Data.SqlClient.SqlParameter[] param ={
                                                                      new System.Data.SqlClient.SqlParameter("@m_name",material_title),
                                                                      new System.Data.SqlClient.SqlParameter("@m_type",type),
                                                                      new System.Data.SqlClient.SqlParameter("@m_url",filename),
                                                                      new System.Data.SqlClient.SqlParameter("@m_content_source_url",news_l_link),
                                                                      new System.Data.SqlClient.SqlParameter("@m_createtime",System.DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss")),
                                                                      new System.Data.SqlClient.SqlParameter("@m_updatetime",System.DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss")),
                                                                      new System.Data.SqlClient.SqlParameter("@m_classid",1)
                                                                      };
                            int j = guandongren.MakehtmlSQL.Add(sql, param);
                            if (j > 0)
                            {
                                Main.Create_log("添加素材 类型:本地素材 标题:" + material_title + "", "", HttpContext.Current.Request.Cookies["admin"].Value);
                                HttpContext.Current.Response.ContentType = "text/plain";
                                HttpContext.Current.Response.Write("ok");
                            }
                            else
                            {
                                HttpContext.Current.Response.Write("插入数据库失败");
                                return;
                            }
                        }
                        else
                        {
                            HttpContext.Current.Response.Write(filename + "文件上传失败");
                            return;
                        }
                    }
                }
            }
            else
            {
                int F_list = HttpContext.Current.Request.Files.Count;
                for (int i = 0; i < F_list; i++)
                {
                    string filename = "";
                    HttpPostedFile file = HttpContext.Current.Request.Files[i];
                    if (file.ContentLength > 0)
                    {
                        string FileName = Main.getRandomNum(6, 1, 100) + i;
                        string filePath = string.Empty;//保存在本地文件
                        string json = string.Empty;
                        switch (type)
                        {
                            case "image":
                                filename = Fileuploads.UploadImg(FileName, "/UploadFiles/Weixin/Image", 300, 300, 300, file, "jpg");
                                filename = "/UploadFiles/Weixin/Image" + filename;
                                filePath = HttpContext.Current.Server.MapPath(filename);
                                if (System.IO.File.Exists(filePath))
                                {
                                    json = WeiXinAPI.WeiXinCommon.UploadFile(access_token, type, filePath);
                                }
                                break;
                            case "voice":
                                filename = Fileuploads.UploadFiles(FileName, "/UploadFiles/Weixin/Voice", 2 * 1024, file, "mp3,amr");
                                filePath = HttpContext.Current.Server.MapPath(filename);
                                if (System.IO.File.Exists(filePath))
                                {
                                    json = WeiXinAPI.WeiXinCommon.UploadFile(access_token, type, filePath);
                                }
                                break;
                            case "video":
                                filename = Fileuploads.UploadFiles(FileName, "/UploadFiles/Weixin/Video", 10 * 1024, file, "mp4");
                                filePath = HttpContext.Current.Server.MapPath(filename);
                                if (System.IO.File.Exists(filePath))
                                {
                                    json = WeiXinAPI.WeiXinCommon.UploadFile(access_token, type, filePath);
                                }
                                break;
                            default:
                                break;
                        }

                        if (json == string.Empty)
                        {
                            HttpContext.Current.Response.Write("上传失败");
                            return;
                        }
                        if (json.Contains("errcode"))
                        {
                            //{"errcode":40004,"errmsg":"invalid media type"}
                            HttpContext.Current.Response.Write(json);
                            return;
                        }

                        if (filename.Contains("上传失败"))
                        {
                            HttpContext.Current.Response.Write(filename);
                            return;
                        }

                        WeiXinAPI.MediaObject m = new WeiXinAPI.MediaObject();
                        WeiXinAPI.JsonOprate.GetPro(m, json);

                        if (!m.IsError)
                        {
                            string sql = string.Format("insert into {0} (m_name,m_type,m_url,m_content,m_des,m_filename,m_media_id,m_created_at,m_createtime,m_updatetime,m_classid) values ('{1}','{2}','{3}','{4}','{5}','{6}','{7}','{8}','{9}','{10}','{11}')"
                                                           , table_id, material_title, type, filename, pictext_content, "", System.IO.Path.GetFileName(filename), m.media_id, m.created_at, System.DateTime.Now, System.DateTime.Now, 0);
                            if (guandongren.MakehtmlSQL.ExecuteSql(sql) > 0)
                            {
                                HttpContext.Current.Response.Write("ok");
                            }
                        }
                        else
                        {
                            HttpContext.Current.Response.Write("插入数据库失败");
                            return;
                        }
                    }
                }
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write("错误，" + ex.Message + "");
        }

    }
    /// <summary>
    /// 添加菜单
    /// </summary>
    private void MenuAdd()
    {
        try
        {
            string menuClassid = HttpContext.Current.Request.Form["drpMenuClassid"];
            string menuName = HttpContext.Current.Request.Form["txtMenuName"].Trim();
            string menuUrl = HttpContext.Current.Request.Form["txtMenuUrl"].Trim();
            string menuDisplay = HttpContext.Current.Request.Form["rdoMenuDisplay"];
            string model_table = HttpContext.Current.Request.Form["model_table"];
            string sqlwhere = HttpContext.Current.Request.Form["sqlwhere"];
            string models = HttpContext.Current.Request.Form["models"];
            string morder = HttpContext.Current.Request.Form["m_order"];
            string m_user = HttpContext.Current.Request.Form["m_user"];

            if (models == "1")//动态模式
            {
                if (string.IsNullOrEmpty(sqlwhere))
                {
                    sqlwhere = "";
                }
            }

            if (models == "0")//静态模式
            {
                model_table = "";
                sqlwhere = "";
            }

            if (menuUrl == "")
            {
                menuUrl = "#";
            }

            if (morder == "")
            {
                morder = "0";
            }
            if (Main.CheckNull(menuName))
            {
                string sql = "insert into g_menu(m_name,m_url,m_classid,m_model,m_display,m_table,m_where,m_sys,m_order,m_user) values(@name,@url,@classid,@m_model,@display,@m_table,@m_where,@m_sys,@m_order,@m_user)";
                System.Data.SqlClient.SqlParameter[] param ={new System.Data.SqlClient.SqlParameter("@name",menuName),
                                   new System.Data.SqlClient.SqlParameter("@url",menuUrl),
                                   new System.Data.SqlClient.SqlParameter("@classid",menuClassid),
                                   new System.Data.SqlClient.SqlParameter("@m_model",models),
                                   new System.Data.SqlClient.SqlParameter("@display",menuDisplay),
                                   new System.Data.SqlClient.SqlParameter("@m_table",model_table),
                                   new System.Data.SqlClient.SqlParameter("@m_where",sqlwhere),
                                   new System.Data.SqlClient.SqlParameter("@m_sys",1),
                                   new System.Data.SqlClient.SqlParameter("@m_order",morder),
                                   new System.Data.SqlClient.SqlParameter("@m_user",m_user)};
                int j = guandongren.MakehtmlSQL.Add(sql, param);
                if (j > 0)
                {
                    Main.Create_log("添加左侧菜单，" + menuName + "", "", HttpContext.Current.Request.Cookies["admin"].Value);
                    HttpContext.Current.Response.Write("ok");
                }
            }
            else
            {
                HttpContext.Current.Response.Write("请将资料填写完整！");
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write("错误，" + ex.Message + "");
        }
    }


    /// <summary>
    /// 添加参数
    /// </summary>
    private void ParamAdd()
    {
        try
        {

            string menuName = HttpContext.Current.Request.Form["txtMenuName"].Trim();
            string txtMenusql = HttpContext.Current.Request.Form["txtMenusql"].Trim();
            string menuDisplay = HttpContext.Current.Request.Form["rdoMenuDisplay"];
            string w_Appid = HttpContext.Current.Request.Form["w_Appid"];
            string w_appsecret = HttpContext.Current.Request.Form["w_appsecret"];
            string w_baidumap = HttpContext.Current.Request.Form["w_baidumap"];

            if (Main.CheckNull(menuName))
            {
                string sql = "insert into g_weixin_setting(w_token,w_uid,w_check,w_Appid,w_appsecret,w_baidumap_ak) values(@p_name,@p_sql,@p_check,@w_Appid,@w_appsecret,@w_baidumap_ak)";
                System.Data.SqlClient.SqlParameter[] param ={new System.Data.SqlClient.SqlParameter("@p_name",menuName),
                                   new System.Data.SqlClient.SqlParameter("@p_sql",txtMenusql),
                                   new System.Data.SqlClient.SqlParameter("@p_check",menuDisplay),
                                   new System.Data.SqlClient.SqlParameter("@w_Appid",w_Appid),
                                   new System.Data.SqlClient.SqlParameter("@w_appsecret",w_appsecret),
                                   new System.Data.SqlClient.SqlParameter("@w_baidumap_ak",w_baidumap)};
                int j = guandongren.MakehtmlSQL.Add(sql, param);
                if (j > 0)
                {
                    Main.Create_log("添加参数设置，" + menuName + "", "", HttpContext.Current.Request.Cookies["admin"].Value);
                    HttpContext.Current.Response.Write("ok");
                }
            }
            else
            {
                HttpContext.Current.Response.Write("请将资料填写完整！");
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write("错误，" + ex.Message + "");
        }
    }

    /// <summary>
    /// 静态页绑定添加
    /// </summary>
    private void Makehtml()
    {
        try
        {
            string m_name = HttpContext.Current.Request.Form["m_name"];
            string m_template = HttpContext.Current.Request.Form["m_template"];
            string m_makeUrl = HttpContext.Current.Request.Form["m_makeUrl"];
            string m_table = HttpContext.Current.Request.Form["m_table"];
            string m_where = HttpContext.Current.Request.Form["m_where"];
            string m_classid = HttpContext.Current.Request.Form["m_classid"];
            if (m_classid == null)
            {
                m_classid = "";
            }
            if (Main.CheckNull(m_template, m_makeUrl, m_name))
            {
                System.Data.DataTable t = guandongren.MakehtmlSQL.GetList("select m_id from g_makehtml where m_name='" + m_name + "'").Tables[0];
                if (t.Rows.Count > 0)
                {
                    HttpContext.Current.Response.Write("该项目名称已经存在！");
                    return;
                }
                string sql = "insert into g_makehtml(m_template,m_makeUrl,m_name,m_table,m_where,m_classid) values(@m_template,@m_makeUrl,@m_name,@m_table,@m_where,@m_classid)";
                System.Data.SqlClient.SqlParameter[] param ={new System.Data.SqlClient.SqlParameter("@m_template",m_template),
                                   new System.Data.SqlClient.SqlParameter("@m_makeUrl",m_makeUrl),
                                   new System.Data.SqlClient.SqlParameter("@m_name",m_name),
                                   new System.Data.SqlClient.SqlParameter("@m_table",m_table),
                                   new System.Data.SqlClient.SqlParameter("@m_where",m_where),
                                   new System.Data.SqlClient.SqlParameter("@m_classid",m_classid)};
                int j = guandongren.MakehtmlSQL.ExecuteSql(sql, param);
                if (j > 0)
                {
                    HttpContext.Current.Response.Write("ok");
                }
            }
            else
            {
                HttpContext.Current.Response.Write("请将资料填写完整！");
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write("错误，" + ex.Message);
        }
    }




    /// <summary>
    /// 添加欢迎词
    /// </summary>
    private void weixin_welcome()
    {
        try
        {

            string menuName = HttpContext.Current.Request.Form["txtMenuName"].Trim();
            string menuDisplay = HttpContext.Current.Request.Form["rdoMenuDisplay"];

            if (Main.CheckNull(menuName))
            {
                string sql = "insert into g_weixin_welcome(f_text,f_type) values(@f_text,@f_type)";
                System.Data.SqlClient.SqlParameter[] param ={new System.Data.SqlClient.SqlParameter("@f_text",menuName),
                                   new System.Data.SqlClient.SqlParameter("@f_type",menuDisplay)};
                int j = guandongren.MakehtmlSQL.Add(sql, param);
                if (j > 0)
                {
                    Main.Create_log("添加参数设置，" + menuName + "", "", HttpContext.Current.Request.Cookies["admin"].Value);
                    HttpContext.Current.Response.Write("ok");
                }
            }
            else
            {
                HttpContext.Current.Response.Write("请将资料填写完整！");
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write("错误，" + ex.Message + "");
        }
    }


    //添加微信好友分组
    private void weixin_usergroup_add()
    {
        try
        {
            string usergroupname = HttpContext.Current.Request.Form["usergroupname"].Trim();
            string access_token = Weixin_operate.Get_AccessToken();
            string result = string.Empty;

            if (Main.CheckNull(usergroupname))
            {
                WeiXinAPI.UserGroupMessage m = new WeiXinAPI.UserGroupMessage();
                m.AccessToken = access_token;
                m.GroupName = usergroupname;

                result = WeiXinAPI.WeiXinCommon.Create_UserGroup(m);
                if (WeiXinAPI.JsonOprate.IsError(result))
                {
                    WeiXinAPI.ErrorMessageObject error = WeiXinAPI.JsonOprate.GetError(result);
                    HttpContext.Current.Response.Write("错误代码:" + error.errcode + "错误信息:" + error.errmsg);
                }
                else
                {
                    result = WeiXinAPI.JsonOprate.GetValue("group", result);
                    string id = WeiXinAPI.JsonOprate.GetValue("id", result);
                    string name = WeiXinAPI.JsonOprate.GetValue("name", result);

                    if (Main.CheckNull(id))
                    {
                        string sql = "insert into g_weixin_usergroup(u_groupid,u_groupname,u_groupcount,u_updatetime) values(@u_groupid,@u_groupname,@u_groupcount,@u_updatetime)";
                        System.Data.SqlClient.SqlParameter[] param ={new System.Data.SqlClient.SqlParameter("@u_groupid",id),
                                                                 new System.Data.SqlClient.SqlParameter("@u_groupname",name),
                                                                  new System.Data.SqlClient.SqlParameter("@u_groupcount","0"),
                                                                    new System.Data.SqlClient.SqlParameter("@u_updatetime",System.DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss"))
                                                                };
                        int j = guandongren.MakehtmlSQL.Add(sql, param);
                        if (j > 0)
                        {
                            Main.Create_log("添加微信用户分组，" + name + "", "", HttpContext.Current.Request.Cookies["admin"].Value);
                            HttpContext.Current.Response.Write("ok");
                        }
                        HttpContext.Current.Response.Write("ok");
                    }
                    else
                    {
                        HttpContext.Current.Response.Write("添加失败!");
                    }
                }
            }
            else
            {
                HttpContext.Current.Response.Write("请将资料填写完整！");
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write(ex.Message);
        }

    }

    private void mobileweb_add()
    {
        try
        {
            string webname = HttpContext.Current.Request.Form["webname"].Trim();
            string weburl = HttpContext.Current.Request.Form["weburl"].Trim();
            string[] allowedImageExtensions = { ".jpg", ".jpeg", ".bmp", ".png" };
            string filename = string.Empty;
            string filedic = string.Empty;
            System.Drawing.Image imagelogo = null;
            HttpPostedFile file;
            int F_list = HttpContext.Current.Request.Files.Count;
            if (F_list > 0)
            {
                file = HttpContext.Current.Request.Files[0];
                if (file.FileName != string.Empty)//生成带Logo的二维码
                {
                    string imageType = ",image/bmp,image/gif,image/pjpeg,image/jpeg,image/x-png,";
                    if (!imageType.Contains("," + file.ContentType + ","))
                    {
                        HttpContext.Current.Response.Write("上传失败：文件类型错误!");
                        return;
                    }
                    if (!checkFile(file.FileName, allowedImageExtensions))
                    {
                        return;
                    }
                    imagelogo = System.Drawing.Image.FromStream(file.InputStream);
                    filename = webname + ".jpg";
                    filedic = HttpContext.Current.Request.PhysicalApplicationPath + "UploadFiles\\Weixin\\QRCode\\";

                    if (!System.IO.Directory.Exists(filedic))
                    {
                        System.IO.Directory.CreateDirectory(filedic);
                    }
                    filename = filedic + filename;
                }
            }
            //保存二维码
            bool save = QRCode.saveQRCode(weburl, filename, imagelogo);
            if (save)
            {

                if (Main.CheckNull(webname))
                {
                    string sql = "insert into g_weixin_product(p_type,p_name,p_url,p_createtime) values(@p_type,@p_name,@p_url,@p_createtime)";
                    System.Data.SqlClient.SqlParameter[] param ={new System.Data.SqlClient.SqlParameter("@p_type","mobileweb"),
                                                                 new System.Data.SqlClient.SqlParameter("@p_name",webname),
                                                                  new System.Data.SqlClient.SqlParameter("@p_url",weburl),
                                                                    new System.Data.SqlClient.SqlParameter("@p_createtime",System.DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss"))
                                                                };
                    int j = guandongren.MakehtmlSQL.Add(sql, param);
                    if (j > 0)
                    {
                        Main.Create_log("添加手机网站，" + webname + "", "", HttpContext.Current.Request.Cookies["admin"].Value);
                        HttpContext.Current.Response.Write("ok");
                    }

                }
                else
                {
                    HttpContext.Current.Response.Write("标题不能为空!");
                }
            }
            else
            {
                HttpContext.Current.Response.Write("保存二维码文件失败!");
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write(ex.Message);
        }
    }

    private bool checkFile(string filename, string[] extensions)
    {
        bool extSucess = false;
        string file_type = System.IO.Path.GetExtension(filename).ToLower();
        for (int i = 0; i < extensions.Length; i++)
        {
            if (file_type == extensions[i])
            {
                extSucess = true;
                break;
            }
        }
        if (!extSucess)
        {
            HttpContext.Current.Response.Write("文件格式错误");
            return extSucess;
        }
        return true;
    }

}