﻿<%@ WebHandler Language="C#" Class="Admin_upd" %>

using System;
using System.Web;

public class Admin_upd : IHttpHandler
{

    public void ProcessRequest(HttpContext context)
    {
        context.Response.ContentType = "text/plain";
       Main make_htm = new Main();

        string T = context.Request.QueryString["T"];
        string id = context.Request.QueryString["id"];
        switch (T)
        {

            case "menu":
                MenuUpd(id);
                break;
            case "Update_table":
                Update_table(id);
                break;
            case "Update_model":
                Update_model(id);
                break;
            case "web_update":
                web_update(id);
                break;
            case "welcome":
                web_welcome(id);
                break;
            case "param":
                web_param(id);
                break;
            case "makehtml":
                makehtml(id);
                break;
            case "Update_material":
                Update_material(id);
                break;
            case "weixin_usergroup_upd":
                weixin_usergroup_upd(id);
                break;
            case "weixin_mobile_upd":
                weixin_mobile_upd(id);
                break;
            case "weixin_reply_upd"://回复被动消息
                weixin_reply_upd(id);
                break;
            case "weixin_menu_upd"://更新微信菜单
                weixin_menu_upd(id);
                break;
            case "update_company":
                update_company(id);
                break;
            case "update_company_get":
                update_company_get(id);
                break;
            case "update_company_hot":
                update_company_hot(id);
                break;
            case "update_company_get_cance":
                update_company_get_cance(id);
                break;
            case "update_company_hot_cance":
                update_company_hot_cance(id);
                break;
            case "update_article"://推荐文章
                update_article(id);
                break;
            case "update_article_cance"://取消文章
                update_article_cance(id);
                break;
                
                
        }
    }

    public bool IsReusable
    {
        get
        {
            return false;
        }
    }


    /// <summary>
    /// 修改表
    /// </summary>
    /// <param name="id"></param>
    private void Update_table(string id)
    {
        try
        {
            string t_name = HttpContext.Current.Request.Form["t_name"];
            string t_template = HttpContext.Current.Request.Form["t_template"];
            if (Main.CheckNull(t_name, t_template))
            {
                string sql = "update g_table set t_name=@t_name,t_template=@t_template where t_id=" + id;
                System.Data.SqlClient.SqlParameter[] param ={new System.Data.SqlClient.SqlParameter("@t_name",t_name),
                                   new System.Data.SqlClient.SqlParameter("@t_template",t_template)
                                        };
                int j = guandongren.MakehtmlSQL.ExecuteSql(sql, param);
                if (j > 0)
                {
                   Main.Create_log("修改表名称，" + t_name + ",模板为：" + t_template, "", HttpContext.Current.Request.Cookies["admin"].Value);
                    HttpContext.Current.Response.Write("ok");
                }
            }
            else
            {
                HttpContext.Current.Response.Write("请将资料填写完整！");
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write("错误，" + ex.Message + "");
        }
    }

    /// <summary>
    /// 修改表
    /// </summary>
    /// <param name="id"></param>
    private void update_company(string id)
    {
        try
        {
            string t_id = HttpContext.Current.Request.Form["ContentIDCollection"];
            string s_class = HttpContext.Current.Request.Form["s_class"];
            string s_add = HttpContext.Current.Request.Form["s_add"];
            if (Main.CheckNull(t_id))
            {
                string where = "";
                
                if (!string.IsNullOrEmpty(s_class))
                {
                    where = " c_classid=@c_classid";
                    string sql = "update g_company set " + where + " where c_id in (" + t_id + ")";
                    System.Data.SqlClient.SqlParameter[] param ={
                                   new System.Data.SqlClient.SqlParameter("@c_classid",s_class)
                                        };
                    int j = guandongren.MakehtmlSQL.ExecuteSql(sql, param);
                    if (j > 0)
                    {
                        // Main.Create_log("修改表名称，" + t_name + ",模板为：" + t_template, "", HttpContext.Current.Request.Cookies["admin"].Value);
                        HttpContext.Current.Response.Write("True");
                    }
                }
                if (!string.IsNullOrEmpty(s_add))
                {
                    where = " c_add=@c_add";
                    string sql = "update g_company set " + where + " where c_id in (" + t_id + ")";
                    System.Data.SqlClient.SqlParameter[] param ={new System.Data.SqlClient.SqlParameter("@c_add",s_add)
                                        };
                    int j = guandongren.MakehtmlSQL.ExecuteSql(sql, param);
                    if (j > 0)
                    {
                        // Main.Create_log("修改表名称，" + t_name + ",模板为：" + t_template, "", HttpContext.Current.Request.Cookies["admin"].Value);
                        HttpContext.Current.Response.Write("True");
                    }
                }
               
            }
            else
            {
                HttpContext.Current.Response.Write("请将资料填写完整！");
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write("错误，" + ex.Message + "");
        }
    }

    /// <summary>
    /// 修改表
    /// </summary>
    /// <param name="id"></param>
    private void update_company_get(string id)
    {
        try
        {
            string t_id = HttpContext.Current.Request.Form["ContentIDCollection"];

            if (Main.CheckNull(t_id))
            {
                string where = "";

                where = " c_get='是'";
                string sql = "update g_company set " + where + " where c_id in (" + t_id + ")";

                int j = guandongren.MakehtmlSQL.ExecuteSql(sql);
                if (j > 0)
                {
                    // Main.Create_log("修改表名称，" + t_name + ",模板为：" + t_template, "", HttpContext.Current.Request.Cookies["admin"].Value);
                    HttpContext.Current.Response.Write("True");
                }


            }
            else
            {
                HttpContext.Current.Response.Write("请将资料填写完整！");
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write("错误，" + ex.Message + "");
        }
    }

    /// <summary>
    /// 修改表
    /// </summary>
    /// <param name="id"></param>
    private void update_company_hot(string id)
    {
        try
        {
            string t_id = HttpContext.Current.Request.Form["ContentIDCollection"];

            if (Main.CheckNull(t_id))
            {
                string where = "";

                where = " c_hot='是'";
                string sql = "update g_company set " + where + " where c_id in (" + t_id + ")";

                int j = guandongren.MakehtmlSQL.ExecuteSql(sql);
                if (j > 0)
                {
                    // Main.Create_log("修改表名称，" + t_name + ",模板为：" + t_template, "", HttpContext.Current.Request.Cookies["admin"].Value);
                    HttpContext.Current.Response.Write("True");
                }


            }
            else
            {
                HttpContext.Current.Response.Write("请将资料填写完整！");
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write("错误，" + ex.Message + "");
        }
    }

    /// <summary>
    /// 修改表
    /// </summary>
    /// <param name="id"></param>
    private void update_company_get_cance(string id)
    {
        try
        {
            string t_id = HttpContext.Current.Request.Form["ContentIDCollection"];

            if (Main.CheckNull(t_id))
            {
                string where = "";

                where = " c_get='否'";
                string sql = "update g_company set " + where + " where c_id in (" + t_id + ")";

                int j = guandongren.MakehtmlSQL.ExecuteSql(sql);
                if (j > 0)
                {
                    // Main.Create_log("修改表名称，" + t_name + ",模板为：" + t_template, "", HttpContext.Current.Request.Cookies["admin"].Value);
                    HttpContext.Current.Response.Write("True");
                }


            }
            else
            {
                HttpContext.Current.Response.Write("请将资料填写完整！");
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write("错误，" + ex.Message + "");
        }
    }


    /// <summary>
    /// 推荐文章
    /// </summary>
    /// <param name="id"></param>
    private void update_article(string id)
    {
        try
        {
            string t_id = HttpContext.Current.Request.Form["ContentIDCollection"];

            if (Main.CheckNull(t_id))
            {
                string where = "";

                where = " a_hot='是'";
                string sql = "update g_article set " + where + " where a_id in (" + t_id + ")";

                int j = guandongren.MakehtmlSQL.ExecuteSql(sql);
                if (j > 0)
                {
                    // Main.Create_log("修改表名称，" + t_name + ",模板为：" + t_template, "", HttpContext.Current.Request.Cookies["admin"].Value);
                    HttpContext.Current.Response.Write("True");
                }


            }
            else
            {
                HttpContext.Current.Response.Write("请将资料填写完整！");
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write("错误，" + ex.Message + "");
        }
    }

    /// <summary>
    /// 取消推荐文章
    /// </summary>
    /// <param name="id"></param>
    private void update_article_cance(string id)
    {
        try
        {
            string t_id = HttpContext.Current.Request.Form["ContentIDCollection"];

            if (Main.CheckNull(t_id))
            {
                string where = "";

                where = " a_hot='否'";
                string sql = "update g_article set " + where + " where a_id in (" + t_id + ")";

                int j = guandongren.MakehtmlSQL.ExecuteSql(sql);
                if (j > 0)
                {
                    // Main.Create_log("修改表名称，" + t_name + ",模板为：" + t_template, "", HttpContext.Current.Request.Cookies["admin"].Value);
                    HttpContext.Current.Response.Write("True");
                }


            }
            else
            {
                HttpContext.Current.Response.Write("请将资料填写完整！");
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write("错误，" + ex.Message + "");
        }
    }

    /// <summary>
    /// 修改表
    /// </summary>
    /// <param name="id"></param>
    private void update_company_hot_cance(string id)
    {
        try
        {
            string t_id = HttpContext.Current.Request.Form["ContentIDCollection"];

            if (Main.CheckNull(t_id))
            {
                string where = "";

                where = " c_hot='否'";
                string sql = "update g_company set " + where + " where c_id in (" + t_id + ")";

                int j = guandongren.MakehtmlSQL.ExecuteSql(sql);
                if (j > 0)
                {
                    // Main.Create_log("修改表名称，" + t_name + ",模板为：" + t_template, "", HttpContext.Current.Request.Cookies["admin"].Value);
                    HttpContext.Current.Response.Write("True");
                }


            }
            else
            {
                HttpContext.Current.Response.Write("请将资料填写完整！");
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write("错误，" + ex.Message + "");
        }
    }

    /// <summary>
    /// 修改表字段
    /// </summary>
    /// <param name="id"></param>
    private void Update_model(string id)
    {
        try
        {
            string m_name = HttpContext.Current.Request.Form["m_name"];
            string m_type = HttpContext.Current.Request.Form["m_type"];
            string m_order = HttpContext.Current.Request.Form["m_order"];
            string m_ismust = HttpContext.Current.Request.Form["m_ismust"];
            string m_show = HttpContext.Current.Request.Form["m_show"];
            string m_label = HttpContext.Current.Request.Form["m_label"];

            if (Main.CheckNull(m_name, m_type, m_order))
            {
                string sql = "update g_model set m_name=@m_name,m_type=@m_type,m_order=@m_order,m_ismust=@m_ismust,m_show=@m_show,m_label=@m_label where m_id=" + id;
                System.Data.SqlClient.SqlParameter[] param ={
                                   new System.Data.SqlClient.SqlParameter("@m_name",m_name),
                                   new System.Data.SqlClient.SqlParameter("@m_type",m_type),
                                   new System.Data.SqlClient.SqlParameter("@m_order",m_order),
                                   new System.Data.SqlClient.SqlParameter("@m_ismust",m_ismust),
                                   new System.Data.SqlClient.SqlParameter("@m_show",m_show),
                                   new System.Data.SqlClient.SqlParameter("@m_label",m_label)
                                        };
                int j = guandongren.MakehtmlSQL.ExecuteSql(sql, param);
                if (j > 0)
                {
                   Main.Create_log("修改表字段名称，" + m_name, "", HttpContext.Current.Request.Cookies["admin"].Value);
                    HttpContext.Current.Response.Write("ok");
                }
            }
            else
            {
                HttpContext.Current.Response.Write("请将资料填写完整！");
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write("错误，" + ex.Message);
        }
    }


    private void web_update(string id)
    {
        try
        {

            System.Collections.Generic.Dictionary<string, string> Dir = new System.Collections.Generic.Dictionary<string, string>();
            string table_id = HttpContext.Current.Request.Form["table_id"].Trim();

            if (Main.CheckNull(table_id))
            {

                #region 上传分析

                string[] upfiles = HttpContext.Current.Request.Files.AllKeys;
                System.Collections.Generic.List<string> uplist = new System.Collections.Generic.List<string>();
                for (int i = 0; i < upfiles.Length; i++)
                {
                    string filename = "";
                    HttpPostedFile file = HttpContext.Current.Request.Files[i];
                  
                    if (file.ContentLength > 0)
                    {
                        string FileName =Main.getRandomNum(6, 1, 100) + i;
                        filename = Fileuploads.UploadImg(FileName, "/UploadFiles/", 300, 300, 300, file, "jpg,gif,bmp,png,jpeg");
                        filename = "/UploadFiles/" + filename;
                        if (filename.Contains("上传失败"))
                        {
                            HttpContext.Current.Response.Write(Main.alert_text(4, filename, ""));
                            return;
                        }
                    }

                   uplist.Add(upfiles[i]+","+ filename);
                }

                #endregion 上传分析


                System.Data.DataTable ds = guandongren.MakehtmlSQL.Query("select m_itemname,m_type,m_ismust,m_name  from g_model where m_table='" + table_id + "' order by m_order asc").Tables[0];
                if (ds.Rows.Count > 0)
                {
                    string sql = "update " + table_id + " set ";
                    string sql1 = "";
                    string sql_id = table_id.Substring(2, 1) + "_id";
                    string Table_;
                    string Table_value = "";
                    //删除历史文件
                    string del_files = "";
                    int u = 0;


                    for (int i = 0; i < ds.Rows.Count; i++)
                    {
                        Table_ = ds.Rows[i]["m_itemname"].ToString();
                        Table_value = HttpContext.Current.Request.Params[Table_];

                        if (ds.Rows[i]["m_ismust"].ToString() == "是")
                        {
                            if (string.IsNullOrEmpty(Table_value))
                            {
                                HttpContext.Current.Response.Write(Main.alert_text(4, "【" + ds.Rows[i]["m_name"] + "】不能为空！", ""));
                                return;
                            }
                        }
                        switch (ds.Rows[i]["m_type"].ToString())
                        {
                            case "上传":

                                for (int n = 0; n < uplist.Count; n++)
                                {
                                    if (uplist[n].Contains(Table_))
                                    {
                                        string[] imgt = uplist[n].Split(',');
                                        if (imgt[1].ToString() != "")
                                        {
                                            sql1 += Table_ + "=";
                                            sql1 += "@" + Table_ + ",";
                                            Dir.Add(Table_, imgt[1]);
                                        }
                                    }
                                }
                                break;
                            case "下拉框":
                                string[] ts = Table_value.Split(',');
                                
                                if (ts.Length <= 1)
                                {
                                    sql1 += Table_ + "=";
                                    sql1 += "@" + Table_ + ",";
                                    Dir.Add(Table_, Table_value);
                                }
                                else
                                {
                                    sql1 += Table_ + "=";
                                    sql1 += "@" + Table_ + ",";
                                    Dir.Add(Table_, ts[0]);
                                    //附加分类属性

                                    sql1 += "p_level=";
                                    sql1 += "@p_level,";
                                    Dir.Add("p_level", ts[1]);
                                }
                             
                                break;
                                
                            default:
                                sql1 += Table_ + "=";
                                sql1 += "@" + Table_ + ",";
                                Dir.Add(Table_, Table_value);

                                break;
                        }
                    }


                    sql1 = sql1.Substring(0, sql1.Length - 1);

                    sql = sql + sql1 + " where " + sql_id + "=" + id;

                    System.Data.SqlClient.SqlParameter[] param = new System.Data.SqlClient.SqlParameter[Dir.Count];

                    int tlist = 0;
                    foreach (System.Collections.Generic.KeyValuePair<string, string> item in Dir)
                    {
                        param[tlist] = new System.Data.SqlClient.SqlParameter("@" + item.Key, item.Value);
                        tlist += 1;
                    }
                    int j = guandongren.MakehtmlSQL.ExecuteSql(sql, param);
                    if (j > 0)
                    {
                        //销毁历史图片
                        Delete_historyFiles(del_files);
                        //更新生成静态页配置
                        guandongren.MakehtmlSQL.ExecuteSql("update g_config set c_task=1");
                       Main.Create_log("修改" + table_id + "表内容", "", HttpContext.Current.Request.Cookies["admin"].Value);
                        HttpContext.Current.Response.Write("ok");
                    }
                }
                else
                {
                    HttpContext.Current.Response.Write("信息修改失败！");
                    return;
                }
            }
            else
            {
                HttpContext.Current.Response.Write("请将资料填写完整！");
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write(Main.alert_text(4, "错误，" + ex.Message + "", ""));
        }
    }

    /// <summary>
    /// 修改微信素材
    /// </summary>
    private void Update_material(string id)
    {
        string material_title = HttpContext.Current.Request.Form["material_title"].Trim();
        string pictext_content = string.Empty;
        if (!string.IsNullOrEmpty(HttpContext.Current.Request.Form["pictext_content"]))
        {
            pictext_content = HttpContext.Current.Request.Form["pictext_content"].ToString();
        }
        string sql = "update g_weixin_material set m_name='" + material_title + "', " + "m_content='" + pictext_content + "',m_updatetime='" + System.DateTime.Now + "' where m_id=" + id;
        try
        {
            guandongren.MakehtmlSQL.ExecuteSql(sql);
           Main.Create_log("修改 g_weixin_material 表内容 m_id=" + id, "", HttpContext.Current.Request.Cookies["admin"].Value);
            HttpContext.Current.Response.Write("ok");
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write(Main.alert_text(4, "错误，" + ex.Message + "", ""));
        }

    }


    /// <summary>
    /// 修改菜单
    /// </summary>
    /// <param name="id"></param>
    private void MenuUpd(string id)
    {
        try
        {
            string menuClassid = HttpContext.Current.Request.Form["drpMenuClassid"];
            string menuName = HttpContext.Current.Request.Form["txtMenuName"];
            string menuUrl = HttpContext.Current.Request.Form["txtMenuUrl"];
            string menuDisplay = HttpContext.Current.Request.Form["rdoMenuDisplay"];
            string model_table = HttpContext.Current.Request.Form["model_table"];
            string sqlwhere = HttpContext.Current.Request.Form["sqlwhere"];
            string models = HttpContext.Current.Request.Form["models"];
            string morder = HttpContext.Current.Request.Form["m_order"];
            string m_user = HttpContext.Current.Request.Form["m_user"];
            
            if (models == "1")//动态模式
            {
                if (string.IsNullOrEmpty(sqlwhere))
                {
                    sqlwhere = "";
                }
            }

            if (models == "0")//静态模式
            {
                model_table = "";
                sqlwhere = "";
            }


            if (menuUrl == "")
            {
                menuUrl = "#";
            }

            if (morder == "")
            {
                morder = "0";
            }

            if (Main.CheckNull(menuName))
            {
                string sql = "update g_menu set m_name=@name,m_url=@url,m_display=@display,m_classid=@m_classid,m_table=@m_table,m_where=@m_where,m_model=@m_model,m_order=@m_order,m_user=@m_user where m_id=" + id;
                System.Data.SqlClient.SqlParameter[] param ={new System.Data.SqlClient.SqlParameter("@name",menuName),
                                   new System.Data.SqlClient.SqlParameter("@url",menuUrl),
                                   new System.Data.SqlClient.SqlParameter("@display",menuDisplay),
                                    new System.Data.SqlClient.SqlParameter("@m_classid",menuClassid),
                                    new System.Data.SqlClient.SqlParameter("@m_table",model_table),
                                    new System.Data.SqlClient.SqlParameter("@m_where",sqlwhere),
                                    new System.Data.SqlClient.SqlParameter("@m_model",models),
                                    new System.Data.SqlClient.SqlParameter("@m_order",morder),
                                    new System.Data.SqlClient.SqlParameter("@m_user",m_user)
                                        };
                int j = guandongren.MakehtmlSQL.ExecuteSql(sql, param);
                if (j > 0)
                {
                   Main.Create_log("修改菜单" + menuName, "", HttpContext.Current.Request.Cookies["admin"].Value);
                    HttpContext.Current.Response.Write("ok");
                }
            }
            else
            {
                HttpContext.Current.Response.Write("请将资料填写完整！");
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write("错误，" + ex.Message + "");
        }
    }

    /// <summary>
    /// 修改生成静态页绑定
    /// </summary>
    /// <param name="id"></param>
    private void makehtml(string id)
    {
        try
        {
            string m_name = HttpContext.Current.Request.Form["m_name"];
            string m_template = HttpContext.Current.Request.Form["m_template"];
            string m_makeUrl = HttpContext.Current.Request.Form["m_makeUrl"];
            string m_table = HttpContext.Current.Request.Form["m_table"];
            string m_where = HttpContext.Current.Request.Form["m_where"];
            string m_classid = HttpContext.Current.Request.Form["m_classid"];

            if (m_classid == null)
            {
                m_classid = "0";
            }
            if (Main.CheckNull(m_template, m_makeUrl, m_name))
            {
                string sql = "update g_makehtml set m_template=@m_template,m_makeUrl=@m_makeUrl,m_name=@m_name,m_where=@m_where,m_table=@m_table,m_classid=@m_classid where m_id=" + id;
                System.Data.SqlClient.SqlParameter[] param ={new System.Data.SqlClient.SqlParameter("@m_template",m_template),
                                   new System.Data.SqlClient.SqlParameter("@m_makeUrl",m_makeUrl),
                                   new System.Data.SqlClient.SqlParameter("@m_name",m_name),
                                   new System.Data.SqlClient.SqlParameter("@m_where",m_where),
                                   new System.Data.SqlClient.SqlParameter("@m_table",m_table),
                                   new System.Data.SqlClient.SqlParameter("@m_classid",m_classid)};
                int j = guandongren.MakehtmlSQL.ExecuteSql(sql, param);
                if (j > 0)
                {
                    HttpContext.Current.Response.Write("ok");
                }
            }
            else
            {
                HttpContext.Current.Response.Write("请将资料填写完整！");
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write("错误，" + ex.Message);
        }
    }

    //删除历史文件
    private void Delete_historyFiles(string del_files)
    {
        if (del_files != "")
        {
            string[] file_s = del_files.Split(',');
            for (int i = 0; i < file_s.Length - 1; i++)
            {
                Main.DeleteFile(HttpContext.Current.Server.MapPath(file_s[i]));
            }
        }
    }


    /// <summary>
    /// 修改接口参数
    /// </summary>
    private void web_param(string id)
    {
        try
        {
            string menuName = HttpContext.Current.Request.Form["txtMenuName"].Trim();
            string menuDisplay = HttpContext.Current.Request.Form["rdoMenuDisplay"];
            string w_Appid = HttpContext.Current.Request.Form["w_Appid"];
            string w_appsecret = HttpContext.Current.Request.Form["w_appsecret"];
            string w_baidumap = HttpContext.Current.Request.Form["w_baidumap"];

            if (Main.CheckNull(menuName))
            {
                string sql = "update g_weixin_setting set w_token=@p_name,w_check=@p_check,w_Appid=@w_Appid,w_appsecret=@w_appsecret,w_baidumap_ak=@w_baidumap_ak where w_id=" + id;
                System.Data.SqlClient.SqlParameter[] param ={new System.Data.SqlClient.SqlParameter("@p_name",menuName),
                                   new System.Data.SqlClient.SqlParameter("@p_check",menuDisplay),
                                   new System.Data.SqlClient.SqlParameter("@w_Appid",w_Appid),
                                   new System.Data.SqlClient.SqlParameter("@w_appsecret",w_appsecret),
                                   new System.Data.SqlClient.SqlParameter("@w_baidumap_ak",w_baidumap)};
                int j = guandongren.MakehtmlSQL.ExecuteSql(sql, param);
                if (j > 0)
                {
                    Main.Create_log("修改参数设置，" + menuName + "", "", HttpContext.Current.Request.Cookies["admin"].Value);
                    HttpContext.Current.Response.Write("ok");
                }
            }
            else
            {
                HttpContext.Current.Response.Write("请将资料填写完整！");
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write("错误，" + ex.Message + "");
        }
    }


    /// <summary>
    /// 修改欢迎词
    /// </summary>
    private void web_welcome(string id)
    {
        try
        {
            string txt_content = HttpContext.Current.Request.Form["txt_content"].Trim();
            //string f_type = HttpContext.Current.Request.Form["rdoMenuDisplay"];

            if (Main.CheckNull(txt_content))
            {
                string sql = "update g_weixin_welcome set f_text=@f_text";
                System.Data.SqlClient.SqlParameter[] param ={new System.Data.SqlClient.SqlParameter("@f_text",txt_content)
                                  // new System.Data.SqlClient.SqlParameter("@f_type",f_type)
                                                            };
                int j = guandongren.MakehtmlSQL.ExecuteSql(sql, param);
                if (j > 0)
                {
                    Main.Create_log("修改欢迎词，" + txt_content + "", "", HttpContext.Current.Request.Cookies["admin"].Value);
                    HttpContext.Current.Response.Write("ok");
                }
            }
            else
            {
                HttpContext.Current.Response.Write("请将资料填写完整！");
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write("错误，" + ex.Message + "");
        }
    }

    //微信分组名称修改
    private void weixin_usergroup_upd(string id)
    {
        try
        {
            string groupname = HttpContext.Current.Request.Form["usergroupname"].Trim();
            string result = string.Empty;
            string updSql = string.Empty;
            if (Main.CheckNull(groupname))
            {
                WeiXinAPI.UserGroupMessage m = new WeiXinAPI.UserGroupMessage();
                m.AccessToken = Weixin_operate.Get_AccessToken();
                m.GroupID = id;
                m.GroupName = groupname;

                result = WeiXinAPI.WeiXinCommon.Update_UserGroup(m);
                if (result.Contains("\"errcode\":0"))
                {
                    string sql = "update g_weixin_usergroup set u_groupname=@u_groupname,u_updatetime=@u_updatetime where u_groupid=@u_groupid";
                    System.Data.SqlClient.SqlParameter[] param ={new System.Data.SqlClient.SqlParameter("@u_groupname",groupname),
                                                               new System.Data.SqlClient.SqlParameter("@u_updatetime",System.DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss")),
                                                               new System.Data.SqlClient.SqlParameter("@u_groupid",id)
                                                               };
                    int j = guandongren.MakehtmlSQL.ExecuteSql(sql, param);
                    if (j > 0)
                    {
                        Main.Create_log("修改用户分组名称，分组ID:" + id + " 分组名称:" + groupname + "", "", HttpContext.Current.Request.Cookies["admin"].Value);
                        HttpContext.Current.Response.Write("ok");
                    }
                }
                else
                {
                    HttpContext.Current.Response.Write(result);
                }
            }
            else
            {
                HttpContext.Current.Response.Write("分组名称不能为空!");
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write(ex.Message);
        }


    }

    private void weixin_mobile_upd(string id)
    {
        try
        {
            string webname = HttpContext.Current.Request.Form["webname"].Trim();
            string weburl = HttpContext.Current.Request.Form["weburl"].Trim();

            if (Main.CheckNull(webname))
            {
                string sql = "update g_weixin_product set p_name=@p_name, p_url=@p_url where p_id=@p_id";
                System.Data.SqlClient.SqlParameter[] param ={new System.Data.SqlClient.SqlParameter("@p_name",webname),
                                                                 new System.Data.SqlClient.SqlParameter("@p_url",weburl),
                                                                  new System.Data.SqlClient.SqlParameter("@p_id",id)
                                                                };
                int j = guandongren.MakehtmlSQL.ExecuteSql(sql, param);
                if (j > 0)
                {
                    Main.Create_log("更新手机网站，编号:" + id + " 标题:" + webname, "", HttpContext.Current.Request.Cookies["admin"].Value);
                    HttpContext.Current.Response.Write("ok");
                }

            }
            else
            {
                HttpContext.Current.Response.Write("标题不能为空");
            }
        }
        catch (Exception ex)
        {

            HttpContext.Current.Response.Write(ex.Message);
        }
    }
    private void weixin_menu_upd(string id)
    {
        try
        {

            string txtMenuName = HttpContext.Current.Request["txtMenuName"].ToString();//菜单标题
            string rdoMenu = HttpContext.Current.Request["rdoMenu"].ToString();//菜单类型  click/view
            string txtKEY = HttpContext.Current.Request["txtKEY"].ToString();//菜单KEY值，用于消息接口推送，不超过128字节
            string txtURL = HttpContext.Current.Request["txtURL"].ToString();//网页链接，用户点击菜单可打开链接，不超过256字节
            string updSqlText = string.Empty;

            updSqlText = "update g_weixin_menu set m_type=@m_type,m_name=@m_name,m_key=@m_key,m_url=@m_url where m_id=@m_id";
            System.Data.SqlClient.SqlParameter[] param ={ new System.Data.SqlClient.SqlParameter ("@m_type",rdoMenu),
                                                       new System.Data.SqlClient.SqlParameter ("@m_name",txtMenuName),
                                                       new System.Data.SqlClient.SqlParameter ("@m_key",txtKEY),
                                                       new System.Data.SqlClient.SqlParameter ("@m_url",txtURL),
                                                       new System.Data.SqlClient.SqlParameter ("@m_id",id)
                                                      };
            int j = guandongren.MakehtmlSQL.ExecuteSql(updSqlText, param);
            if (j > 0)
            {
                Main.Create_log("更新菜单:" + txtMenuName, "", HttpContext.Current.Request.Cookies["admin"].Value);
                HttpContext.Current.Response.Write("ok");
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write(ex.Message);
        }

    }
    private void weixin_reply_upd(string id)
    {
        try
        {
            string reply_name = HttpContext.Current.Request.Form["reply_name"].Trim();
            string reply_keyword = HttpContext.Current.Request.Form["reply_keyword"].Trim();
            string reply_content = HttpContext.Current.Request.Form["reply_content"].Trim();
            string reply_state = HttpContext.Current.Request.Form["reply_state"].Trim();
            string key = string.Empty;
            if (HttpContext.Current.Request.Form["inputkey"] != null)
            {
                key = HttpContext.Current.Request.Form["inputkey"].Trim();
            }
            if (Main.CheckNull(reply_name))
            {
                string sql = "update g_weixin_reply set r_name=@r_name, r_keyword=@r_keyword,r_reply=@r_reply,r_enable=@r_enable,r_updatetime=@r_updatetime,r_key=@r_key where r_id=@r_id";
                System.Data.SqlClient.SqlParameter[] param ={
                                                            new System.Data.SqlClient.SqlParameter("@r_name",reply_name),
                                                            new System.Data.SqlClient.SqlParameter("@r_keyword",reply_keyword),
                                                            new System.Data.SqlClient.SqlParameter("@r_reply",reply_content),
                                                            new System.Data.SqlClient.SqlParameter("@r_enable",reply_state),
                                                            new System.Data.SqlClient.SqlParameter("@r_updatetime",System.DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss")),
                                                            new System.Data.SqlClient.SqlParameter("@r_key",key),
                                                            new System.Data.SqlClient.SqlParameter("@r_id",id)
                                                           };
                int j = guandongren.MakehtmlSQL.ExecuteSql(sql, param);
                if (j > 0)
                {
                    Main.Create_log("更新被动消息，编号:" + id + " 标题:" + reply_name, "", HttpContext.Current.Request.Cookies["admin"].Value);
                    HttpContext.Current.Response.Write("ok");
                }
            }
            else
            {
                HttpContext.Current.Response.Write("标题不能为空");
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write(ex.Message);
        }
    }

}