﻿Imports Microsoft.VisualBasic
Imports System.Web
Imports System.Web.Caching
Imports System.Text.RegularExpressions
Imports System.Security.Cryptography
Imports System.Text

Public Class PublicMethod
    ''' <summary>
    ''' 窗口样式
    ''' </summary>
    ''' <remarks></remarks>
    Public Enum WindowSkin
        Skin_Default = 1
        Skin_iblue = 2
        Skin_iblack = 3
        Skin_blue = 4
        Skin_chrome = 5
        Skin_discuz = 6
        Skin_jtop = 7
        Skin_mac = 8
        Skin_idialog = 9
    End Enum

    Public Enum WindowIcon
        None = 0 '不适用图标
        Warrning = 1 'alert.gif 警告
        Infomation = 2 'confirm.gif  '提示
        Success = 3 'success.gif '成功
        QuestionMark = 4 'prompt.gif '疑问
        Errors = 5 'error.gif  错误
    End Enum
    ''' <summary>
    ''' 获取网站基础设置信息
    ''' </summary>
    ''' <param name="AppName">信息名称</param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetApplication(ByVal AppName As String) As String
        Dim mObj As Object = System.Web.HttpRuntime.Cache.Get("ConfigDict")
        Dim mDictionaries As New Dictionary(Of String, String)
        If Not IsNothing(mObj) Then
            mDictionaries = CType(mObj, Dictionary(Of String, String))
            If mDictionaries.ContainsKey(AppName) Then
                Return mDictionaries.Item(AppName)
            Else
                Return ""
            End If
        Else
            Dim SiteCfg = DB_SiteInfoModular.clsConfigs.GetSingle()
            Dim mEndTime As Date = (Now.AddYears(1)).ToShortDateString

            If Not IsNothing(SiteCfg) Then
                With SiteCfg
                    mDictionaries.Item("EndTime") = .EndTime.ToString
                    mDictionaries.Item("SiteID") = .ID.ToString
                    mDictionaries.Item("WebName") = .WebName
                    mDictionaries.Item("WebURL") = .WebURL
                    mDictionaries.Item("UpType") = .UpType
                    mDictionaries.Item("LogTime") = .LogTime.ToString
                    mDictionaries.Item("DefaultGroup") = .DefaultGroup.ToString
                    mDictionaries.Item("SiteKey") = .SiteKey
                    mDictionaries.Item("ManagerDirectory") = .ManagerDirectory
                    mDictionaries.Item("SiteState") = .SiteState
                    mDictionaries.Item("ManagerGroup") = .ManagerGroup
                    mDictionaries.Item("OpenTrace") = .OpenTrace
                    mDictionaries.Item("CheckFile") = .CheckFile
                    mDictionaries.Item("SecCache") = .SecCache
                    mDictionaries.Item("URLRewrite") = .URLFileEx
                End With
                SyncLock (GetType(PublicMethod))
                    System.Web.HttpRuntime.Cache.Insert("ConfigDict", mDictionaries, Nothing, Web.Caching.Cache.NoAbsoluteExpiration, Web.Caching.Cache.NoSlidingExpiration, Web.Caching.CacheItemPriority.NotRemovable, Nothing)
                End SyncLock
                If mDictionaries.ContainsKey(AppName) Then
                    Return mDictionaries(AppName)
                Else
                    Return ""
                End If
            Else
                Return ""
            End If
        End If
    End Function
    ''' <summary>
    ''' 显示ToolsTips提示
    ''' </summary>
    ''' <param name="mPage">窗体页</param>
    ''' <param name="msg">消息内容</param>
    ''' <remarks></remarks>
    Public Shared Sub ShowMessage(ByVal mPage As Web.UI.Page, ByVal msg As String)
        If Not mPage.ClientScript.IsClientScriptIncludeRegistered("jqueryminScript") Then mPage.ClientScript.RegisterClientScriptInclude("jqueryminScript", BaseFunction.PublicMethod.GetBaseUrl & "/App_Themes/ManagerTheme/js/jquery.min.js")
        Dim ScriptHtml As New StringBuilder
        ScriptHtml.AppendLine("<div id=""ToolsTips""></div>")
        ScriptHtml.AppendLine("<script>")
        'ScriptHtml.AppendLine("function ToolsTips(msg) {")
        ScriptHtml.AppendLine("if (!$('#ToolsTips').is(':visible')) {")
        ScriptHtml.AppendLine("$('#ToolsTips').html('" & msg & "');")
        ScriptHtml.AppendLine("$('#ToolsTips').css({ display: 'block', top: '-100px' }).animate({ top: '+2' }, 300, function() { setTimeout(TipsSlide, 3000); });")
        ScriptHtml.AppendLine("} ")
        'ScriptHtml.AppendLine("}")
        ScriptHtml.AppendLine("function TipsSlide() {")
        ScriptHtml.AppendLine("$('#ToolsTips').animate({ top: '-40' }, 300, function() {")
        ScriptHtml.AppendLine("$(this).css({ display: 'none', top: '-100px' });")
        ScriptHtml.AppendLine("}); ")
        ScriptHtml.AppendLine("}")
        ScriptHtml.AppendLine("</script>")
        mPage.ClientScript.RegisterStartupScript(mPage.GetType, "ToolsTips", ScriptHtml.ToString)
    End Sub
    ''' <summary>
    ''' 显示消息弹窗
    ''' </summary>
    ''' <param name="mPage">窗体页</param>
    ''' <param name="Title">窗口标题</param>
    ''' <param name="msg">消息内容</param>
    ''' <remarks></remarks>
    Public Shared Sub ShowMessage(ByVal mPage As Web.UI.Page, ByVal Title As String, ByVal msg As String, Optional ByVal Icon As WindowIcon = WindowIcon.Infomation, Optional ByVal Width As Integer = 300, Optional ByVal Height As Integer = 100, Optional ByVal Skin As WindowSkin = WindowSkin.Skin_Default, Optional ByVal MinButton As Boolean = False, Optional ByVal MaxButton As Boolean = False)
        Dim mSkin As String = String.Empty
        Select Case Skin
            Case WindowSkin.Skin_blue
                mSkin = "blue"
            Case WindowSkin.Skin_chrome
                mSkin = "chrome"
            Case WindowSkin.Skin_discuz
                mSkin = "discuz"
            Case WindowSkin.Skin_iblack
                mSkin = "iblack"
            Case WindowSkin.Skin_iblue
                mSkin = "iblue"
            Case WindowSkin.Skin_idialog
                mSkin = "idialog"
            Case WindowSkin.Skin_jtop
                mSkin = "Skin_jtop"
            Case WindowSkin.Skin_mac
                mSkin = "mac"
            Case Else
                mSkin = "default"
        End Select
        Dim mIcon As String = String.Empty
        Select Case Icon
            Case WindowIcon.None
                mIcon = ""
            Case WindowIcon.Errors
                mIcon = "error.gif"
            Case WindowIcon.Infomation
                mIcon = "confirm.gif"
            Case WindowIcon.QuestionMark
                mIcon = "prompt.gif"
            Case WindowIcon.Success
                mIcon = "success.gif"
            Case WindowIcon.Warrning
                mIcon = "alert.gif"
        End Select
        If Not mPage.ClientScript.IsClientScriptIncludeRegistered("jqueryminScript") Then mPage.ClientScript.RegisterClientScriptInclude("jqueryminScript", BaseFunction.PublicMethod.GetBaseUrl & "/App_Themes/ManagerTheme/js/jquery.min.js")
        If Not mPage.ClientScript.IsClientScriptIncludeRegistered("lhgdialogminScript") Then mPage.ClientScript.RegisterClientScriptInclude("lhgdialogminScript", BaseFunction.PublicMethod.GetBaseUrl & "/App_Themes/ManagerTheme/js/lhgdialog.min.js?skin=" & mSkin)
        Dim ScriptHtml As New StringBuilder
        ScriptHtml.AppendLine("$.dialog({ ")
        ScriptHtml.AppendLine("    lock: true, ")
        ScriptHtml.AppendLine("    title:  '" & Title & "', ")
        ScriptHtml.AppendLine("    content:  '" & msg & "', ")
        ScriptHtml.AppendLine("    width:  '" & Width.ToString & "', ")
        ScriptHtml.AppendLine("    height:  '" & Height.ToString & "', ")
        ScriptHtml.AppendLine("    icon: '" & mIcon & "', ")
        ScriptHtml.AppendLine("    max: " & MaxButton.ToString.ToLower & ", ")
        ScriptHtml.AppendLine("    min: " & MinButton.ToString.ToLower)
        ScriptHtml.AppendLine("});")
        mPage.ClientScript.RegisterStartupScript(mPage.GetType, "ToolsTips", ScriptHtml.ToString, True)
    End Sub

    ''' <summary>
    ''' 重定向弹窗
    ''' </summary>
    ''' <param name="mPage">窗体页</param>
    ''' <param name="Title">窗口标题</param>
    ''' <param name="msg">消息内容</param>
    '''  <param name="RedirectURL">重定向页面</param>
    ''' <remarks></remarks>
    Public Shared Sub ShowMessage(ByVal mPage As Web.UI.Page, ByVal Title As String, ByVal msg As String, ByVal RedirectURL As String, Optional ByVal Icon As WindowIcon = WindowIcon.Infomation, Optional ByVal Width As Integer = 300, Optional ByVal Height As Integer = 100, Optional ByVal Skin As WindowSkin = WindowSkin.Skin_Default, Optional ByVal MinButton As Boolean = False, Optional ByVal MaxButton As Boolean = False)
        Dim mSkin As String = String.Empty
        Select Case Skin
            Case WindowSkin.Skin_blue
                mSkin = "blue"
            Case WindowSkin.Skin_chrome
                mSkin = "chrome"
            Case WindowSkin.Skin_discuz
                mSkin = "discuz"
            Case WindowSkin.Skin_iblack
                mSkin = "iblack"
            Case WindowSkin.Skin_iblue
                mSkin = "iblue"
            Case WindowSkin.Skin_idialog
                mSkin = "idialog"
            Case WindowSkin.Skin_jtop
                mSkin = "Skin_jtop"
            Case WindowSkin.Skin_mac
                mSkin = "mac"
            Case Else
                mSkin = "default"
        End Select
        Dim mIcon As String = String.Empty
        Select Case Icon
            Case WindowIcon.None
                mIcon = ""
            Case WindowIcon.Errors
                mIcon = "error.gif"
            Case WindowIcon.Infomation
                mIcon = "confirm.gif"
            Case WindowIcon.QuestionMark
                mIcon = "prompt.gif"
            Case WindowIcon.Success
                mIcon = "success.gif"
            Case WindowIcon.Warrning
                mIcon = "alert.gif"
        End Select
        If Not mPage.ClientScript.IsClientScriptIncludeRegistered("jqueryminScript") Then mPage.ClientScript.RegisterClientScriptInclude("jqueryminScript", BaseFunction.PublicMethod.GetBaseUrl & "/App_Themes/ManagerTheme/js/jquery.min.js")
        If Not mPage.ClientScript.IsClientScriptIncludeRegistered("lhgdialogminScript") Then mPage.ClientScript.RegisterClientScriptInclude("lhgdialogminScript", BaseFunction.PublicMethod.GetBaseUrl & "/App_Themes/ManagerTheme/js/lhgdialog.min.js?skin=" & mSkin)
        Dim ScriptHtml As New StringBuilder
        Dim mURL As String = String.Empty
        If RedirectURL.Length > 0 Then
            mURL = RedirectURL
        Else
            mURL = HttpContext.Current.Request.RawUrl.Split("?")(0)
        End If
        ScriptHtml.AppendLine("$.dialog({ ")
        ScriptHtml.AppendLine("    lock: true, ")
        ScriptHtml.AppendLine("    title:  '" & Title & "', ")
        ScriptHtml.AppendLine("    content:  '" & msg & "', ")
        ScriptHtml.AppendLine("    width:  " & Width.ToString & ", ")
        ScriptHtml.AppendLine("    height: " & Height.ToString & ", ")
        ScriptHtml.AppendLine("    icon: '" & mIcon & "', ")
        ScriptHtml.AppendLine("    max: " & MaxButton.ToString.ToLower & ", ")
        ScriptHtml.AppendLine("    min: " & MinButton.ToString.ToLower & ", ")
        ScriptHtml.AppendLine("    ok: function(){ ")
        ScriptHtml.AppendLine("        window.location='" & mURL & "'; ")
        ScriptHtml.AppendLine("    } ")
        ScriptHtml.AppendLine("});")
        mPage.ClientScript.RegisterStartupScript(mPage.GetType, "ToolsTips", ScriptHtml.ToString, True)

    End Sub

    ''' <summary>
    ''' 嵌入页面弹窗
    ''' </summary>
    ''' <param name="mPage">窗体页</param>
    ''' <param name="Title">窗口标题</param>
    '''  <param name="FileImportsURL">嵌入页面路径</param>
    ''' <remarks></remarks>
    Public Shared Sub ShowMessage(ByVal mPage As Web.UI.Page, ByVal Title As String, ByVal FileImportsURL As String, ByVal IsLock As Boolean, Optional ByVal Width As Integer = 300, Optional ByVal Height As Integer = 100, Optional ByVal Skin As WindowSkin = WindowSkin.Skin_Default, Optional ByVal MinButton As Boolean = False, Optional ByVal MaxButton As Boolean = False)
        Dim mSkin As String = String.Empty
        Select Case Skin
            Case WindowSkin.Skin_blue
                mSkin = "blue"
            Case WindowSkin.Skin_chrome
                mSkin = "chrome"
            Case WindowSkin.Skin_discuz
                mSkin = "discuz"
            Case WindowSkin.Skin_iblack
                mSkin = "iblack"
            Case WindowSkin.Skin_iblue
                mSkin = "iblue"
            Case WindowSkin.Skin_idialog
                mSkin = "idialog"
            Case WindowSkin.Skin_jtop
                mSkin = "Skin_jtop"
            Case WindowSkin.Skin_mac
                mSkin = "mac"
            Case Else
                mSkin = "default"
        End Select

        If Not mPage.ClientScript.IsClientScriptIncludeRegistered("jqueryminScript") Then mPage.ClientScript.RegisterClientScriptInclude("jqueryminScript", BaseFunction.PublicMethod.GetBaseUrl & "/App_Themes/ManagerTheme/js/jquery.min.js")
        If Not mPage.ClientScript.IsClientScriptIncludeRegistered("lhgdialogminScript") Then mPage.ClientScript.RegisterClientScriptInclude("lhgdialogminScript", BaseFunction.PublicMethod.GetBaseUrl & "/App_Themes/ManagerTheme/js/lhgdialog.min.js?skin=" & mSkin)
        Dim ScriptHtml As New StringBuilder


        ScriptHtml.AppendLine("$.dialog({ ")
        ScriptHtml.AppendLine("    lock: " & IsLock.ToString.ToLower & ", ")
        ScriptHtml.AppendLine("    title:  '" & Title & "', ")
        ScriptHtml.AppendLine("    width:  " & Width.ToString & ", ")
        ScriptHtml.AppendLine("    height: " & Height.ToString & ", ")
        ScriptHtml.AppendLine("    content:  'url:" & FileImportsURL & "',")
        ScriptHtml.AppendLine("    max: " & MaxButton.ToString.ToLower & ", ")
        ScriptHtml.AppendLine("    min: " & MinButton.ToString.ToLower)
        ScriptHtml.AppendLine("});")
        mPage.ClientScript.RegisterStartupScript(mPage.GetType, "ToolsTips", ScriptHtml.ToString, True)

    End Sub

    ''' <summary>
    ''' 变更当前模式
    ''' </summary>
    ''' <returns>返回已更改的模式</returns>
    ''' <remarks></remarks>
    Public Shared Function ChangeOpenModel() As Boolean
        If Not IsNothing(HttpContext.Current.Request.Cookies("M_OpenModel")) AndAlso HttpContext.Current.Request.Cookies("M_OpenModel").Value.Length > 0 Then
            Dim mOpenModel As Boolean = Not CType(HttpContext.Current.Request.Cookies("M_OpenModel").Value, Boolean)
            HttpContext.Current.Response.Cookies("M_OpenModel").Value = mOpenModel
            Return mOpenModel
        Else
            HttpContext.Current.Response.Cookies("M_OpenModel").Value = "False"
            Return False
        End If

    End Function

    ''' <summary>
    ''' 获取当前模式
    ''' </summary>
    ''' <returns>返回当前模式</returns>
    ''' <remarks></remarks>
    Public Shared Function GetOpenModel() As Boolean
        If Not IsNothing(HttpContext.Current.Request.Cookies("M_OpenModel")) AndAlso HttpContext.Current.Request.Cookies("M_OpenModel").Value.Length > 0 Then
            Dim mOpenModel As Boolean = CType(HttpContext.Current.Request.Cookies("M_OpenModel").Value, Boolean)
            Return mOpenModel
        Else
            HttpContext.Current.Response.Cookies("M_OpenModel").Value = "False"
            Return False
        End If

    End Function

    ''' <summary>
    ''' 获取网站域名
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetBaseUrl() As String
        Dim strApp As String = HttpContext.Current.Request.ApplicationPath

        If strApp = "/" Then
            strApp = ""
        End If
        Return HttpContext.Current.Request.Url.Scheme.ToString() & "://" & HttpContext.Current.Request.Url.Authority.ToString() & strApp
    End Function
    ''' <summary>
    ''' 按字节数截取字符串
    ''' </summary>
    ''' <param name="SouseString">被截取的字符串</param>
    ''' <param name="StrLenght">要获取的长度</param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function CutString(ByVal SouseString As String, ByVal StrLenght As Integer) As String
        Dim StrValue As String = ""
        Dim i As Integer
        Dim WordLen As Integer
        Dim iWord As String
        For i = 1 To Len(Trim(SouseString))
            iWord = Mid(SouseString, i, 1)
            If Asc(iWord) >= 255 Or Asc(iWord) <= 0 Then
                WordLen = WordLen + 2
            Else
                WordLen = WordLen + 1
            End If
            StrValue = StrValue & iWord
            If WordLen >= StrLenght Then
                If WordLen <= 10 Then
                    StrValue = StrValue
                Else
                    StrValue = StrValue & "..."
                End If
                Exit For
            End If
        Next
        Return StrValue
    End Function
    ''' <summary>
    ''' MD5加密
    ''' </summary>
    ''' <param name="strSource">要加密的字符串</param>
    ''' <param name="Code">16或32位加密</param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function MD5(ByVal strSource As String, ByVal Code As Int16) As String '这里用的是ascii编码密码原文，如果要用汉字做密码，可以用UnicodeEncoding，但会与ASP中的MD5函数不兼容
        If strSource Is Nothing OrElse strSource.Length = 0 Then Return ""
        Dim dataToHash As Byte() = (New System.Text.ASCIIEncoding).GetBytes(strSource)
        Dim hashvalue As Byte() = CType(System.Security.Cryptography.CryptoConfig.CreateFromName("MD5"), System.Security.Cryptography.HashAlgorithm).ComputeHash(dataToHash)
        Dim i As Integer
        Dim ReTurnValue As String = ""
        Select Case Code
            Case 16                 '选择16位字符的加密结果
                For i = 4 To 11
                    ReTurnValue += Hex(hashvalue(i)).ToLower
                Next
            Case 32                 '选择32位字符的加密结果
                For i = 0 To 15
                    ReTurnValue += Hex(hashvalue(i)).ToLower
                Next
            Case Else               'Code错误时，返回全部字符串，即32位字符
                For i = 0 To hashvalue.Length - 1
                    ReTurnValue += Hex(hashvalue(i)).ToLower
                Next
        End Select
        Return ReTurnValue
    End Function
    ''' <summary>
    ''' 检查EMAIL是否正确
    ''' </summary>
    ''' <param name="eMail"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function CheckEmail(ByVal eMail As String) As Boolean
        If (Regex.IsMatch(eMail, "\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*")) Then
            Return True
        Else
            Return False
        End If
    End Function
    ''' <summary>
    ''' 记录系统日志
    ''' </summary>
    ''' <param name="nAction"></param>
    ''' <remarks></remarks>
    Public Shared Sub SaveLog(ByVal nAction As String)
        If nAction.Length > 0 Then
            Dim mUserName As String = HttpUtility.HtmlEncode("匿名用户")
            If Not IsNothing(HttpContext.Current.Request.Cookies("M_UserName")) AndAlso HttpContext.Current.Request.Cookies("M_UserName").Value.Length > 0 Then
                mUserName = BaseFunction.PublicMethod.Base64DecryptData(HttpContext.Current.Request.Cookies("M_UserName").Value)
            End If
            Dim mManagerLog As New DB_SiteInfoModular.clsManagerLog
            mManagerLog.Insert(CType(GetApplication("SiteID"), Integer), Now, mUserName, nAction)
        End If
    End Sub
    ''' <summary>
    ''' BASE64加密方法
    ''' </summary>
    ''' <param name="plaintext"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function Base64EncryptData(ByVal plaintext As String) As String
        Return Convert.ToBase64String(System.Text.Encoding.UTF8.GetBytes(plaintext))
        'Dim plaintextBytes() As Byte = System.Text.Encoding.Unicode.GetBytes(plaintext)
        'Return Convert.ToBase64String(plaintextBytes)
    End Function
    ''' <summary>
    ''' BASE64解密方法
    ''' </summary>
    ''' <param name="encryptedtext"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function Base64DecryptData(ByVal encryptedtext As String) As String
        Dim strReturn As String = System.Text.Encoding.UTF8.GetString(Convert.FromBase64String(encryptedtext))
        Return strReturn.Replace("/&/&", "+")
        'Dim encryptedBytes() As Byte = Convert.FromBase64String(encryptedtext)
        'Return System.Text.Encoding.Unicode.GetString(encryptedBytes)
    End Function
    ''' <summary>
    ''' 获取汉字简拼
    ''' </summary>
    ''' <param name="str"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetPinYin(ByVal str As String) As String
        Dim pinyin As Char
        Dim c As Char
        Dim array() As Byte
        Dim i As Integer
        Dim sb As New System.Text.StringBuilder(str.Length)
        For Each c In str.ToCharArray
            pinyin = c
            array = System.Text.Encoding.Default.GetBytes(New Char() {c})
            If array.Length = 2 Then
                i = array(0) * &H100 + array(1)
                If i < &HB0A1 Then
                    pinyin = c
                ElseIf i < &HB0C5 Then
                    pinyin = "A"
                ElseIf i < &HB2C1 Then
                    pinyin = "B"
                ElseIf i < &HB4EE Then
                    pinyin = "C"
                ElseIf i < &HB6EA Then
                    pinyin = "D"
                ElseIf i < &HB7A2 Then
                    pinyin = "E"
                ElseIf i < &HB8C1 Then
                    pinyin = "F"
                ElseIf i < &HB9FE Then
                    pinyin = "G"
                ElseIf i < &HBBF7 Then
                    pinyin = "H"
                ElseIf i < &HBFA6 Then
                    pinyin = "J"
                ElseIf i < &HC0AC Then
                    pinyin = "K"
                ElseIf i < &HC2E8 Then
                    pinyin = "L"
                ElseIf i < &HC4C3 Then
                    pinyin = "M"
                ElseIf i < &HC5B6 Then
                    pinyin = "N"
                ElseIf i < &HC5BE Then
                    pinyin = "O"
                ElseIf i < &HC6DA Then
                    pinyin = "P"
                ElseIf i < &HC8BB Then
                    pinyin = "Q"
                ElseIf i < &HC8F6 Then
                    pinyin = "R"
                ElseIf i < &HCBFA Then
                    pinyin = "S"
                ElseIf i < &HCDDA Then
                    pinyin = "T"
                ElseIf i < &HCEF4 Then
                    pinyin = "W"
                ElseIf i < &HD1B9 Then
                    pinyin = "X"
                ElseIf i < &HD4D1 Then
                    pinyin = "Y"
                ElseIf i < &HD7FA Then
                    pinyin = "Z"
                End If
            End If
            sb.Append(pinyin)
        Next
        Return sb.ToString()
    End Function
    ''' <summary>
    ''' 数字转换为大写货币
    ''' </summary>
    ''' <param name="LowerMoney"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function MoneyToChinese(ByVal LowerMoney As String) As String
        Dim functionReturnValue As String = Nothing
        Dim IsNegative As Boolean = False  ' 是否是负数   
        If LowerMoney.Trim().Substring(0, 1) = "-" Then
            ' 是负数则先转为正数   
            LowerMoney = LowerMoney.Trim().Remove(0, 1)
            IsNegative = True
        End If
        Dim strLower As String = Nothing
        Dim strUpart As String = Nothing
        Dim strUpper As String = Nothing
        Dim iTemp As Integer = 0
        ' 保留两位小数 123.489→123.49　　123.4→123.4   
        LowerMoney = Math.Round(Double.Parse(LowerMoney), 2).ToString()
        If LowerMoney.IndexOf(".") > 0 Then
            If LowerMoney.IndexOf(".") = LowerMoney.Length - 2 Then
                LowerMoney = LowerMoney + "0"
            End If
        Else
            LowerMoney = LowerMoney + ".00"
        End If
        strLower = LowerMoney
        iTemp = 1
        strUpper = ""
        While iTemp <= strLower.Length
            Select Case strLower.Substring(strLower.Length - iTemp, 1)
                Case "."
                    strUpart = "元"
                Case "0"
                    strUpart = "零"
                Case "1"
                    strUpart = "壹"
                Case "2"
                    strUpart = "贰"
                Case "3"
                    strUpart = "叁"
                Case "4"
                    strUpart = "肆"
                Case "5"
                    strUpart = "伍"
                Case "6"
                    strUpart = "陆"
                Case "7"
                    strUpart = "柒"
                Case "8"
                    strUpart = "捌"
                Case "9"
                    strUpart = "玖"
            End Select

            Select Case iTemp
                Case 1
                    strUpart = strUpart + "分"
                Case 2
                    strUpart = strUpart + "角"
                Case 3
                    strUpart = strUpart + ""
                Case 4
                    strUpart = strUpart + ""
                Case 5
                    strUpart = strUpart + "拾"
                Case 6
                    strUpart = strUpart + "佰"
                Case 7
                    strUpart = strUpart + "仟"
                Case 8
                    strUpart = strUpart + "万"
                Case 9
                    strUpart = strUpart + "拾"
                Case 10
                    strUpart = strUpart + "佰"
                Case 11
                    strUpart = strUpart + "仟"
                Case 12
                    strUpart = strUpart + "亿"
                Case 13
                    strUpart = strUpart + "拾"
                Case 14
                    strUpart = strUpart + "佰"
                Case 15
                    strUpart = strUpart + "仟"
                Case 16
                    strUpart = strUpart + "万"
                Case Else
                    strUpart = strUpart + ""
            End Select

            strUpper = strUpart + strUpper
            iTemp = iTemp + 1
        End While

        'strUpper = strUpper.Replace("零拾", "零")
        'strUpper = strUpper.Replace("零佰", "零")
        'strUpper = strUpper.Replace("零仟", "零")
        'strUpper = strUpper.Replace("零零零", "零")
        'strUpper = strUpper.Replace("零零", "零")
        'strUpper = strUpper.Replace("零角零分", "整")
        'strUpper = strUpper.Replace("零分", "整")
        'strUpper = strUpper.Replace("零角", "零")
        'strUpper = strUpper.Replace("零亿零万零圆", "亿圆")
        'strUpper = strUpper.Replace("亿零万零圆", "亿圆")
        'strUpper = strUpper.Replace("零亿零万", "亿")
        'strUpper = strUpper.Replace("零万零圆", "万圆")
        'strUpper = strUpper.Replace("零亿", "亿")
        'strUpper = strUpper.Replace("零万", "万")
        'strUpper = strUpper.Replace("零圆", "圆")
        'strUpper = strUpper.Replace("零零", "零")

        ' 对壹圆以下的金额的处理   
        If strUpper.Substring(0, 1) = "圆" Then
            strUpper = strUpper.Substring(1, strUpper.Length - 1)
        End If
        If strUpper.Substring(0, 1) = "零" Then
            strUpper = strUpper.Substring(1, strUpper.Length - 1)
        End If
        If strUpper.Substring(0, 1) = "角" Then
            strUpper = strUpper.Substring(1, strUpper.Length - 1)
        End If
        If strUpper.Substring(0, 1) = "分" Then
            strUpper = strUpper.Substring(1, strUpper.Length - 1)
        End If
        If strUpper.Substring(0, 1) = "整" Then
            strUpper = "零圆整"
        End If
        functionReturnValue = strUpper

        If IsNegative = True Then
            Return "负" + functionReturnValue
        Else
            Return functionReturnValue
        End If
    End Function

    ''' <summary>
    ''' DES加密算法
    ''' </summary>
    ''' <param name="pToEncrypt">要加密的字符串</param>
    ''' <param name="sKey">英文密匙长度为8位</param>
    ''' <returns>加密后的字符串</returns>
    ''' <remarks></remarks>
    Public Shared Function DESEncrypt(ByVal pToEncrypt As String, ByVal sKey As String) As String
        Dim des As New DESCryptoServiceProvider()
        Dim inputByteArray() As Byte
        inputByteArray = Encoding.Default.GetBytes(pToEncrypt)
        '建立加密对象的密钥和偏移量 
        '原文使用ASCIIEncoding.ASCII方法的GetBytes方法 
        '使得输入密码必须输入英文文本 
        des.Key = ASCIIEncoding.ASCII.GetBytes(sKey)
        des.IV = ASCIIEncoding.ASCII.GetBytes(sKey)
        '写二进制数组到加密流 
        '(把内存流中的内容全部写入) 
        Dim ms As New System.IO.MemoryStream()
        Dim cs As New CryptoStream(ms, des.CreateEncryptor, CryptoStreamMode.Write)
        '写二进制数组到加密流 
        '(把内存流中的内容全部写入) 
        cs.Write(inputByteArray, 0, inputByteArray.Length)
        cs.FlushFinalBlock()

        '建立输出字符串      
        Dim ret As New StringBuilder()
        Dim b As Byte
        For Each b In ms.ToArray()
            ret.AppendFormat("{0:X2}", b)
        Next
        Return ret.ToString()
    End Function

    ''' <summary>
    ''' DES解密方法 
    ''' </summary>
    ''' <param name="pToDecrypt">要解密的字符串</param>
    ''' <param name="sKey">英文密匙长度为8位</param>
    ''' <returns>解密后的原文</returns>
    ''' <remarks></remarks>
    Public Shared Function DESDecrypt(ByVal pToDecrypt As String, ByVal sKey As String) As String
        Dim des As New DESCryptoServiceProvider()
        '把字符串放入byte数组 
        Dim len As Integer
        len = pToDecrypt.Length / 2 - 1
        Dim inputByteArray(len) As Byte
        Dim x, i As Integer
        For x = 0 To len
            i = Convert.ToInt32(pToDecrypt.Substring(x * 2, 2), 16)
            inputByteArray(x) = CType(i, Byte)
        Next
        '建立加密对象的密钥和偏移量，此值重要，不能修改 
        des.Key = ASCIIEncoding.ASCII.GetBytes(sKey)
        des.IV = ASCIIEncoding.ASCII.GetBytes(sKey)
        Dim ms As New System.IO.MemoryStream()
        Dim cs As New CryptoStream(ms, des.CreateDecryptor, CryptoStreamMode.Write)
        cs.Write(inputByteArray, 0, inputByteArray.Length)
        cs.FlushFinalBlock()
        Return Encoding.Default.GetString(ms.ToArray)
    End Function
End Class
