﻿Imports System.Web

Public Class SiteUser
    Private Shared Function IsManager() As Boolean
        Dim mIsManager As Boolean = False
        If Not IsNothing(HttpContext.Current.Request.Cookies("M_IsManager")) Then
            Boolean.TryParse(HttpContext.Current.Request.Cookies("M_IsManager").Value, mIsManager)
        End If
        Return mIsManager
    End Function
    ''' <summary>
    ''' 获取已登录用户的用户组ID
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function UserGroupID() As Integer
        Dim mUserGroupID As Integer = 0
        If IsManager() Then
            If Not IsNothing(HttpContext.Current.Request.Cookies("M_GroupID")) Then
                Integer.TryParse(PublicMethod.DESDecrypt(HttpContext.Current.Request.Cookies("M_GroupID").Value, BaseFunction.PublicMethod.GetApplication("SiteKey")), mUserGroupID)
            End If
        End If
        Return mUserGroupID
    End Function
    ''' <summary>
    ''' 获取已登录的用户名
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLoginUserName() As String
        Dim mUserName As String = ""
        If Not IsNothing(HttpContext.Current.Request.Cookies("M_UserName")) Then
            mUserName = BaseFunction.PublicMethod.Base64DecryptData(HttpContext.Current.Request.Cookies("M_UserName").Value)
        End If
        Return mUserName
    End Function
    ''' <summary>
    ''' 用户登录
    ''' </summary>
    ''' <param name="LoginUserName">用户名</param>
    ''' <param name="LoginPassWord">密码</param>
    ''' <returns>是否成功</returns>
    ''' <remarks></remarks>
    Public Shared Function LoginVerification(ByVal LoginUserName As String, ByVal LoginPassWord As String, Optional ByVal CheckManager As Boolean = False) As Boolean
        Dim mSiteID As Integer
        Dim md5PWD As String = BaseFunction.PublicMethod.MD5(LoginPassWord, 16)
        Dim SiteKey As String = BaseFunction.PublicMethod.GetApplication("SiteKey")
        Integer.TryParse(BaseFunction.PublicMethod.GetApplication("SiteID"), mSiteID)
        Dim clsUser As New DB_UserModular.clsXrenUser
        Dim LoginUser = clsUser.GetSingle(LoginUserName, md5PWD, True, mSiteID)
        If Not IsNothing(LoginUser) Then
            HttpContext.Current.Response.Cookies("M_OpenModel").Value = "False"
            HttpContext.Current.Response.Cookies("M_SiteID").Value = LoginUser.SiteID
            HttpContext.Current.Response.Cookies("M_UserName").Value = BaseFunction.PublicMethod.Base64EncryptData(LoginUserName)
            HttpContext.Current.Response.Cookies("M_UserID").Value = BaseFunction.PublicMethod.DESEncrypt(LoginUser.ID.ToString, SiteKey)
            HttpContext.Current.Response.Cookies("M_GroupID").Value = BaseFunction.PublicMethod.DESEncrypt(LoginUser.GroupID.ToString, SiteKey)
            HttpContext.Current.Response.Cookies("M_UserPoint").Value = LoginUser.Point.ToString
            HttpContext.Current.Response.Cookies("M_IsManager").Value = LoginUser.IsManager
            HttpContext.Current.Response.Cookies("M_UserPhoto").Value = LoginUser.HeadPhoto
            HttpContext.Current.Response.Cookies("M_LastIP").Value = LoginUser.LastLoginIP
            HttpContext.Current.Response.Cookies("M_LastTime").Value = LoginUser.LastLoginTime
            HttpContext.Current.Response.Cookies("M_LoginTimes").Value = LoginUser.LoginTimes

            BaseFunction.PublicMethod.SaveLog("登录成功：" & LoginUserName)
            Return True
        Else
            HttpContext.Current.Response.Cookies("M_UserName").Value = BaseFunction.PublicMethod.Base64EncryptData(LoginUserName)
            BaseFunction.PublicMethod.SaveLog("登录失败：" & BaseFunction.PublicMethod.Base64EncryptData(LoginUserName))
            HttpContext.Current.Response.Cookies.Clear()
            Return False
        End If
    End Function

  
End Class
