﻿Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Text
Imports System.Web
Imports System.Web.UI
Imports System.Web.UI.WebControls
Imports XrenCache.XrCache

<DefaultEvent("Submit"), DefaultProperty("PageSize"), ToolboxData("<{0}:iPaging runat=server></{0}:iPaging>")> _
Public Class iPaging
    Inherits CompositeControl
#Region "声明"
    Private imgButtonFirst As ImageButton
    Private imgButtonLast As ImageButton
    Private imgButtonPre As ImageButton
    Private imgButtonNext As ImageButton
    Private imgButtonGo As ImageButton
    Private txtGo As TextBox
    Private lblPageSize As Label
    Private lblPageState As Label
    Private _TextCssClass As String = ""
    Private _ImageButtonCssClass As String = ""
    Private _strPageStyle As String = ""
    Private _TextBoxCssClass As String = ""
    Private hfPageSize As HiddenField
    Private hfPageCount As HiddenField
    Private hfPageNo As HiddenField

    Private Shared ReadOnly EventSubmitKey As New Object()
#End Region

#Region "事件"
    <Category("Action")> _
       Public Custom Event Submit As EventHandler

        AddHandler(ByVal value As EventHandler)
            Events.AddHandler(EventSubmitKey, value)
        End AddHandler
        RemoveHandler(ByVal value As EventHandler)
            Events.RemoveHandler(EventSubmitKey, value)
        End RemoveHandler
        RaiseEvent(ByVal sender As Object, ByVal e As System.EventArgs)
            CType(Events(EventSubmitKey), EventHandler).Invoke(sender, e)
        End RaiseEvent
    End Event

    Protected Overridable Sub OnSubmit(ByVal e As EventArgs)
        Dim submitHandler As EventHandler = _
            CType(Events(EventSubmitKey), EventHandler)
        If submitHandler IsNot Nothing Then
            submitHandler(Me, e)
        End If
    End Sub

    Private Sub submitButton_Click(ByVal source As Object, ByVal e As EventArgs)
        Dim btnID As String = source.ID
        Select Case btnID
            Case "imgBtnFirst"
                PageNo = 0
            Case "imgBtnPre"
                If PageNo > 0 Then
                    PageNo = PageNo - 1
                End If
            Case "imgBtnNext"
                If PageNo + 1 < PageCount Then
                    PageNo = PageNo + 1
                End If
            Case "imgBtnLast"
                If PageCount > 0 Then
                    PageNo = PageCount - 1
                End If
            Case "imgBtnGo"
                Dim mGo As Integer
                Integer.TryParse(txtGo.Text, mGo)
                If mGo > 0 AndAlso mGo <= PageCount Then
                    PageNo = mGo - 1
                End If
        End Select
        Dim mPageCount As Integer = PageCount
        If mPageCount > 0 Then
            lblPageState.Text = Replace(Replace(strPageStyle, "Page", (PageNo + 1).ToString), "Count", PageCount.ToString)
        Else
            lblPageState.Text = Replace(Replace(strPageStyle, "Page", (PageNo + 1).ToString), "Count", "1")
        End If
        txtGo.Text = (PageNo + 1).ToString
        OnSubmit(EventArgs.Empty)
    End Sub
#End Region

#Region "页数信息"

    ''' <summary>
    ''' 输出当前页码样式
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    <Description("显示当前页码位置信息"), DisplayName("页码样式规则")> _
    Property strPageStyle() As String
        Get
            If _strPageStyle.Length = 0 Then
                _strPageStyle = "当前页：Page/Count"
            End If
            Return _strPageStyle
        End Get
        Set(ByVal value As String)
            _strPageStyle = value
        End Set
    End Property
    ''' <summary>
    ''' 每页条数
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    <DisplayName("每页条数")> _
    Property PageSize() As Integer
        Get
            EnsureChildControls()
            Dim mPageSize As Integer
            Integer.TryParse(hfPageSize.Value, mPageSize)
            If mPageSize > 0 Then
                Return mPageSize
            Else
                hfPageSize.Value = "20"
                Return 20
            End If
        End Get
        Set(ByVal value As Integer)
            EnsureChildControls()
            If value > 0 Then
                hfPageSize.Value = value.ToString
            End If
        End Set
    End Property
    ''' <summary>
    ''' 计算总页数
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    <Browsable(False)> _
    Property SumCount() As Integer
        Get
            If PageCount > 0 Then
                Return -1
            Else
                Return 0
            End If
        End Get
        Set(ByVal value As Integer)
            If value > 0 Then
                PageCount = SumPage(value)
                Dim mPageCount As Integer = PageCount
                If mPageCount > 0 Then
                    lblPageState.Text = Replace(Replace(strPageStyle, "Page", (PageNo + 1).ToString), "Count", PageCount.ToString)
                Else
                    lblPageState.Text = Replace(Replace(strPageStyle, "Page", (PageNo + 1).ToString), "Count", "1")
                End If

                txtGo.Text = (PageNo + 1).ToString
            End If
        End Set
    End Property

    ''' <summary>
    ''' 总页数
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    <Browsable(False)> _
    Property PageCount() As Integer
        Get
            EnsureChildControls()
            Dim mPageCount As Integer
            Integer.TryParse(hfPageCount.Value, mPageCount)
            If mPageCount >= 0 Then
                Return mPageCount
            Else
                hfPageCount.Value = "0"
                Return 0
            End If
        End Get
        Set(ByVal value As Integer)
            EnsureChildControls()
            hfPageCount.Value = value.ToString
        End Set
    End Property

    ''' <summary>
    ''' 当前页码
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    <Browsable(False)> _
    Property PageNo() As Integer
        Get
            EnsureChildControls()
            Dim mPageNo As Integer
            Integer.TryParse(hfPageNo.Value, mPageNo)
            If mPageNo > 0 Then
                Return mPageNo
            Else
                hfPageNo.Value = "0"
                Return 0
            End If
        End Get
        Set(ByVal value As Integer)
            EnsureChildControls()
            If value >= 0 Then
                hfPageNo.Value = value.ToString
            End If
        End Set
    End Property
    Private Function SumPage(ByVal intCount As Integer) As Integer
        lblPageSize.Text = "每页：" & PageSize.ToString & "条"
        If intCount <= PageSize Then Return 1
        Dim iPage As Integer = intCount \ PageSize
        Dim dPage As Single = intCount / PageSize
        If dPage > iPage Then
            Return iPage + 1
        Else
            Return iPage
        End If
    End Function
#End Region
  
#Region "图片按钮属性"

    ''' <summary>
    ''' 第一页按钮图片
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    <Description("第一页按钮图片"), DisplayName("首页图片")> _
    Property ButtonFirstImageUrl() As String
        Get
            EnsureChildControls()
            If imgButtonFirst.ImageUrl.Length > 0 Then
                Return imgButtonFirst.ImageUrl
            Else
                Return "/App_Themes/ManagerTheme/Images/First.gif"
            End If
        End Get
        Set(ByVal value As String)
            EnsureChildControls()
            If value.Length > 0 Then
                imgButtonFirst.ImageUrl = value
            Else
                imgButtonFirst.ImageUrl = "/App_Themes/ManagerTheme/Images/First.gif"
            End If
        End Set
    End Property
    ''' <summary>
    ''' 最后一页按钮图片
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    <Description("尾页按钮图片"), DisplayName("尾页图片")> _
    Property ButtonLastImageUrl() As String
        Get
            EnsureChildControls()
            If imgButtonLast.ImageUrl.Length > 0 Then
                Return imgButtonLast.ImageUrl
            Else
                Return "/App_Themes/ManagerTheme/Images/last.gif"
            End If
        End Get
        Set(ByVal value As String)
            EnsureChildControls()
            If value.Length > 0 Then
                imgButtonLast.ImageUrl = value
            Else
                imgButtonLast.ImageUrl = "/App_Themes/ManagerTheme/Images/last.gif"
            End If
        End Set
    End Property

    ''' <summary>
    ''' 上一页按钮图片
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    <Description("上一页按钮图片"), DisplayName("上一页图片")> _
    Property ButtonPreImageUrl() As String
        Get
            EnsureChildControls()
            If imgButtonPre.ImageUrl.Length > 0 Then
                Return imgButtonPre.ImageUrl
            Else
                Return "/App_Themes/ManagerTheme/Images/back.gif"
            End If
        End Get
        Set(ByVal value As String)
            EnsureChildControls()
            If value.Length > 0 Then
                imgButtonPre.ImageUrl = value
            Else
                imgButtonPre.ImageUrl = "/App_Themes/ManagerTheme/Images/back.gif"
            End If
        End Set
    End Property

    ''' <summary>
    ''' 下一页按钮图片
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    <Description("下一页按钮图片"), DisplayName("下一页图片")> _
    Property ButtonNextImageUrl() As String
        Get
            EnsureChildControls()
            If imgButtonNext.ImageUrl.Length > 0 Then
                Return imgButtonNext.ImageUrl
            Else
                Return "/App_Themes/ManagerTheme/Images/next.gif"
            End If
        End Get
        Set(ByVal value As String)
            EnsureChildControls()
            If value.Length > 0 Then
                imgButtonNext.ImageUrl = value
            Else
                imgButtonNext.ImageUrl = "/App_Themes/ManagerTheme/Images/next.gif"
            End If
        End Set
    End Property

    ''' <summary>
    ''' 转到某页按钮图片
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    <Description("转到页按钮图片"), DisplayName("转到页图片")> _
    Property ButtonGoImageUrl() As String
        Get
            EnsureChildControls()
            If imgButtonGo.ImageUrl.Length > 0 Then
                Return imgButtonGo.ImageUrl
            Else
                Return "/App_Themes/ManagerTheme/Images/go.gif"
            End If
        End Get
        Set(ByVal value As String)
            EnsureChildControls()
            If value.Length > 0 Then
                imgButtonGo.ImageUrl = value
            Else
                imgButtonGo.ImageUrl = "/App_Themes/ManagerTheme/Images/go.gif"
            End If
        End Set
    End Property
#End Region

#Region "样式单接口属性"
    <Description("文字样式"), DisplayName("文字样式")> _
   Property TextCssClass() As String
        Get
            Return _TextCssClass
        End Get
        Set(ByVal value As String)
            If value.Length > 0 Then
                EnsureChildControls()
                lblPageState.CssClass = value
                lblPageSize.CssClass = value
            End If
            _TextCssClass = value
        End Set
    End Property
    <Description("图片按钮样式"), DisplayName("图片按钮样式")> _
    Property ImageButtonCssClass() As String
        Get
            Return _ImageButtonCssClass
        End Get
        Set(ByVal value As String)
            If value.Length > 0 Then
                EnsureChildControls()
                imgButtonFirst.CssClass = value
                imgButtonGo.CssClass = value
                imgButtonLast.CssClass = value
                imgButtonNext.CssClass = value
                imgButtonPre.CssClass = value
            End If
            _ImageButtonCssClass = value
        End Set
    End Property
    <Description("文本框样式"), DisplayName("文本框样式")> _
    Property TextBoxCssClass() As String
        Get
            Return _TextBoxCssClass
        End Get
        Set(ByVal value As String)
            If value.Length > 0 Then
                EnsureChildControls()
                txtGo.CssClass = value
            End If
            _TextBoxCssClass = value
        End Set
    End Property
#End Region

#Region "创建控件列表"
    Protected Overrides Sub RecreateChildControls()
        EnsureChildControls()
    End Sub
    Protected Overrides Sub CreateChildControls()
        Controls.Clear()

        hfPageCount = New HiddenField
        hfPageCount.ID = "hfPageCount"
        hfPageCount.Value = PageCount
        Controls.Add(hfPageCount)

        hfPageNo = New HiddenField
        hfPageNo.ID = "hfPageNo"
        hfPageNo.Value = PageNo
        Controls.Add(hfPageNo)

        hfPageSize = New HiddenField
        hfPageSize.ID = "hfPageSize"
        Controls.Add(hfPageSize)

        lblPageState = New Label
        lblPageState.ID = "PageState"
        Dim mPageCount As Integer = PageCount
        If mPageCount > 0 Then
            lblPageState.Text = Replace(Replace(strPageStyle, "Page", (PageNo + 1).ToString), "Count", PageCount.ToString)
        Else
            lblPageState.Text = Replace(Replace(strPageStyle, "Page", (PageNo + 1).ToString), "Count", "1")
        End If
        Controls.Add(lblPageState)

        lblPageSize = New Label
        lblPageSize.ID = "PageSize"
        Controls.Add(lblPageSize)

        imgButtonFirst = New ImageButton
        imgButtonFirst.Style.Add("margin", "0px 5px 0px 5px")
        imgButtonFirst.ID = "imgBtnFirst"
        imgButtonFirst.ImageUrl = ButtonFirstImageUrl
        AddHandler imgButtonFirst.Click, AddressOf submitButton_Click
        Controls.Add(imgButtonFirst)

        imgButtonPre = New ImageButton
        imgButtonPre.Style.Add("margin", "0px 5px 0px 5px")
        imgButtonPre.ID = "imgBtnPre"
        imgButtonPre.ImageUrl = ButtonPreImageUrl
        AddHandler imgButtonPre.Click, AddressOf submitButton_Click
        Controls.Add(imgButtonPre)

        imgButtonNext = New ImageButton
        imgButtonNext.Style.Add("margin", "0px 5px 0px 5px")
        imgButtonNext.ID = "imgBtnNext"
        imgButtonNext.ImageUrl = ButtonNextImageUrl
        AddHandler imgButtonNext.Click, AddressOf submitButton_Click
        Controls.Add(imgButtonNext)

        imgButtonLast = New ImageButton
        imgButtonLast.Style.Add("margin", "0px 5px 0px 5px")
        imgButtonLast.ID = "imgBtnLast"
        imgButtonLast.ImageUrl = ButtonLastImageUrl
        AddHandler imgButtonLast.Click, AddressOf submitButton_Click
        Controls.Add(imgButtonLast)

        imgButtonGo = New ImageButton
        imgButtonGo.Style.Add("margin", "0px 5px 0px 5px")
        imgButtonGo.ID = "imgBtnGo"
        imgButtonGo.ImageUrl = ButtonGoImageUrl
        AddHandler imgButtonGo.Click, AddressOf submitButton_Click
        Controls.Add(imgButtonGo)

        txtGo = New TextBox
        txtGo.Style.Add("border", "0px")
        txtGo.Style.Add("border-bottom", "1px solid #87B6E4")
        txtGo.Style.Add("line-height", "15px")
        txtGo.Height = 13
        txtGo.ID = "txtGo"
        txtGo.Width = 40
        txtGo.Text = (PageNo + 1).ToString
        Controls.Add(txtGo)


    End Sub

    Protected Overrides Sub RenderContents(ByVal writer As HtmlTextWriter)
        AddAttributesToRender(writer)
        hfPageCount.RenderControl(writer)
        hfPageNo.RenderControl(writer)
        hfPageSize.RenderControl(writer)
        writer.Write("<center><table border=""0"" width=""650px"" cellspacing=""0"" cellpadding=""0""><tr>")
        writer.Write("<td style=""width:200px;line-height:25px;text-align:left;font-size:14px;font-family:Microsoft YaHei;"">")
        lblPageState.RenderControl(writer)
        writer.Write("&nbsp;&nbsp;")
        lblPageSize.RenderControl(writer)
        writer.Write("</td><td style=""width:450px;line-height:25px;text-align:left"">")
        imgButtonFirst.RenderControl(writer)
        imgButtonPre.RenderControl(writer)
        imgButtonNext.RenderControl(writer)
        imgButtonLast.RenderControl(writer)
        txtGo.RenderControl(writer)
        imgButtonGo.RenderControl(writer)
        writer.Write("</td></tr></table></center>")
    End Sub
#End Region

#Region "隐藏主属性"
    <Browsable(False)> _
   Public Overrides Property BackColor() As System.Drawing.Color
        Get
            Return MyBase.BackColor
        End Get
        Set(ByVal value As System.Drawing.Color)
            MyBase.BackColor = value
        End Set
    End Property
    <Browsable(False)> _
    Public Overrides Property BorderColor() As System.Drawing.Color
        Get
            Return MyBase.BorderColor
        End Get
        Set(ByVal value As System.Drawing.Color)
            MyBase.BorderColor = value
        End Set
    End Property
    <Browsable(False)> _
    Public Overrides Property AccessKey() As String
        Get
            Return MyBase.AccessKey
        End Get
        Set(ByVal value As String)
            MyBase.AccessKey = value
        End Set
    End Property
    <Browsable(False)> _
    Public Overrides Property BorderStyle() As System.Web.UI.WebControls.BorderStyle
        Get
            Return MyBase.BorderStyle
        End Get
        Set(ByVal value As System.Web.UI.WebControls.BorderStyle)
            MyBase.BorderStyle = value
        End Set
    End Property
    <Browsable(False)> _
    Public Overrides Property BorderWidth() As System.Web.UI.WebControls.Unit
        Get
            Return MyBase.BorderWidth
        End Get
        Set(ByVal value As System.Web.UI.WebControls.Unit)
            MyBase.BorderWidth = value
        End Set
    End Property
    <Browsable(False)> _
    Public Overrides Property Enabled() As Boolean
        Get
            Return MyBase.Enabled
        End Get
        Set(ByVal value As Boolean)
            MyBase.Enabled = value
        End Set
    End Property
    <Browsable(False)> _
    Public Overrides Property CssClass() As String
        Get
            Return MyBase.CssClass
        End Get
        Set(ByVal value As String)
            MyBase.CssClass = value
        End Set
    End Property
    <Browsable(False)> _
    Public Overrides Property EnableTheming() As Boolean
        Get
            Return MyBase.EnableTheming
        End Get
        Set(ByVal value As Boolean)
            MyBase.EnableTheming = value
        End Set
    End Property
    <Browsable(False)> _
    Public Overrides Property ForeColor() As System.Drawing.Color
        Get
            Return MyBase.ForeColor
        End Get
        Set(ByVal value As System.Drawing.Color)
            MyBase.ForeColor = value
        End Set
    End Property
    <Browsable(False)> _
    Public Overrides ReadOnly Property Font() As System.Web.UI.WebControls.FontInfo
        Get
            Return MyBase.Font
        End Get
    End Property
    <Browsable(False)> _
    Public Overrides Property Height() As System.Web.UI.WebControls.Unit
        Get
            Return MyBase.Height
        End Get
        Set(ByVal value As System.Web.UI.WebControls.Unit)
            MyBase.Height = value
        End Set
    End Property
    <Browsable(False)> _
    Public Overrides Property SkinID() As String
        Get
            Return MyBase.SkinID
        End Get
        Set(ByVal value As String)
            MyBase.SkinID = value
        End Set
    End Property
    <Browsable(False)> _
    Public Overrides Property Width() As System.Web.UI.WebControls.Unit
        Get
            Return MyBase.Width
        End Get
        Set(ByVal value As System.Web.UI.WebControls.Unit)
            MyBase.Width = value
        End Set
    End Property
    <Browsable(False)> _
    Public Overrides Property ToolTip() As String
        Get
            Return MyBase.ToolTip
        End Get
        Set(ByVal value As String)
            MyBase.ToolTip = value
        End Set
    End Property
    <Browsable(False)> _
    Public Overrides Property Visible() As Boolean
        Get
            Return MyBase.Visible
        End Get
        Set(ByVal value As Boolean)
            MyBase.Visible = value
        End Set
    End Property
    <Browsable(False)> _
    Public Overrides Property TabIndex() As Short
        Get
            Return MyBase.TabIndex
        End Get
        Set(ByVal value As Short)
            MyBase.TabIndex = value
        End Set
    End Property
#End Region

End Class
