﻿Public Class clsPlug
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As Plug
        Using db As New DB_PlugDataContext
            Return (From c In db.Plug _
                    Where c.ID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq() As IQueryable(Of Plug)
        Dim db As New DB_PlugDataContext
        Return From c In db.Plug _
               Order By c.ClassID, c.OrderID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_PlugDataContext
            Dim Del = (From d In db.Plug _
                      Where d.ID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                Dim mGetPlug As New DB_PlugModular.clsPlugParameter
                mGetPlug.DeletePlugParameter(ID)
                db.Plug.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Plug.txt", Now)
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_PlugDataContext
            Dim Del = From d In db.Plug _
                      Where ID.Contains(d.ID) _
                      Select d
            For Each d In Del
                db.Plug.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Plug.txt", Now)
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="ClassID"></param>
    ''' <param name="PageFlag"></param>
    ''' <param name="AddTime"></param>
    ''' <param name="ShowMenu"></param>
    ''' <param name="NewTarget"></param>
    ''' <param name="PlugName"></param>
    ''' <param name="PlugMemo"></param>
    ''' <param name="Author"></param>
    ''' <param name="PageSetFile"></param>
    ''' <param name="SendTo"></param>
    ''' <param name="LookFor"></param>
    ''' <param name="PlugPic"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal ClassID As Integer, ByVal PageFlag As Integer, ByVal OrderID As Integer, ByVal AddTime As DateTime, ByVal ShowMenu As Boolean, ByVal NewTarget As Boolean, ByVal PlugName As String, ByVal PlugMemo As String, ByVal Author As String, ByVal PageSetFile As String, ByVal SendTo As String, ByVal LookFor As String, ByVal PlugPic As String, ByVal BaseURL As String) As Integer
        Using db As New DB_PlugDataContext
            Dim mNewPlug As New Plug With {.ClassID = ClassID, .PageFlag = PageFlag, .OrderID = OrderID, .AddTime = AddTime, .ShowMenu = ShowMenu, .NewTarget = NewTarget, .PlugName = PlugName, .PlugMemo = PlugMemo, .Author = Author, .PageSetFile = PageSetFile, .SendTo = SendTo, .LookFor = LookFor, .PlugPic = PlugPic, .BaseURL = BaseURL}
            db.Plug.InsertOnSubmit(mNewPlug)
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Plug.txt", Now)
                Return mNewPlug.ID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="ClassID"></param>
    ''' <param name="PageFlag"></param>
    ''' <param name="OrderID"></param>
    ''' <param name="AddTime"></param>
    ''' <param name="ShowMenu"></param>
    ''' <param name="NewTarget"></param>
    ''' <param name="PlugName"></param>
    ''' <param name="PlugMemo"></param>
    ''' <param name="Author"></param>
    ''' <param name="PageSetFile"></param>
    ''' <param name="SendTo"></param>
    ''' <param name="LookFor"></param>
    ''' <param name="PlugPic"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal ClassID As Integer, ByVal PageFlag As Integer, ByVal OrderID As Integer, ByVal AddTime As DateTime, ByVal ShowMenu As Boolean, ByVal NewTarget As Boolean, ByVal PlugName As String, ByVal PlugMemo As String, ByVal Author As String, ByVal PageSetFile As String, ByVal SendTo As String, ByVal LookFor As String, ByVal PlugPic As String, ByVal BaseUrl As String) As Integer
        Using db As New DB_PlugDataContext
            Dim UpdatePlug = (From c In db.Plug _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdatePlug) Then
                With UpdatePlug
                    .ClassID = ClassID
                    .PageFlag = PageFlag
                    .OrderID = OrderID
                    .AddTime = AddTime
                    .ShowMenu = ShowMenu
                    .NewTarget = NewTarget
                    .PlugName = PlugName
                    .PlugMemo = PlugMemo
                    .Author = Author
                    .PageSetFile = PageSetFile
                    .SendTo = SendTo
                    .LookFor = LookFor
                    .PlugPic = PlugPic
                    .BaseURL = BaseUrl
                End With

                Try
                    db.SubmitChanges()
                    IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Plug.txt", Now)
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
End Class
