﻿Public Class clsPlugClass
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As PlugClass
        Using db As New DB_PlugDataContext
            Return (From c In db.PlugClass _
                    Where c.ClassID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq() As IQueryable(Of PlugClass)
        Dim db As New DB_PlugDataContext
        Return From c In db.PlugClass _
               Order By c.OrderID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_PlugDataContext
            Dim Del = (From d In db.PlugClass _
                      Where d.ClassID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                db.PlugClass.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\PlugClass.txt", Now)
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_PlugDataContext
            Dim Del = From d In db.PlugClass _
                      Where ID.Contains(d.ClassID) _
                      Select d
            For Each d In Del
                db.PlugClass.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\PlugClass.txt", Now)
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="mOrderID"></param>
    ''' <param name="ClassType"></param>
    ''' <param name="ClassName"></param>
    ''' <param name="enName"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal mOrderID As Integer, ByVal ClassType As Integer, ByVal ClassName As String, ByVal enName As String) As Integer
        Using db As New DB_PlugDataContext
            Dim mMaxOrder As Integer = 0
            If mOrderID > 0 Then
                mMaxOrder = mOrderID - 1
            Else
                Dim mPlugMax As PlugClass = (From p In db.PlugClass _
                                         Where p.ClassType = ClassType _
                                         Order By p.OrderID Descending _
                                         Select p).FirstOrDefault
                If mPlugMax IsNot Nothing Then
                    mMaxOrder = mPlugMax.OrderID
                End If
            End If
            
            Dim mNewPlugClass As New PlugClass With {.OrderID = mMaxOrder + 1, .ClassType = ClassType, .ClassName = ClassName, .enName = enName}
            db.PlugClass.InsertOnSubmit(mNewPlugClass)
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\PlugClass.txt", Now)
                Return mNewPlugClass.ClassID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="OrderID"></param>
    ''' <param name="ClassType"></param>
    ''' <param name="ClassName"></param>
    ''' <param name="enName"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal OrderID As Integer, ByVal ClassType As Integer, ByVal ClassName As String, ByVal enName As String) As Integer
        Using db As New DB_PlugDataContext
            Dim UpdatePlugClass = (From c In db.PlugClass _
                                       Where c.ClassID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdatePlugClass) Then
                With UpdatePlugClass
                    .OrderID = OrderID
                    .ClassType = ClassType
                    .ClassName = ClassName
                    .enName = enName

                End With

                Try
                    db.SubmitChanges()
                    IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\PlugClass.txt", Now)
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
End Class
