﻿Public Class clsPlugParameter
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As PlugParameter
        Using db As New DB_PlugDataContext
            Return (From c In db.PlugParameter _
                    Where c.ParID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq() As IQueryable(Of PlugParameter)
        Dim db As New DB_PlugDataContext
        Return From c In db.PlugParameter _
               Order By c.ParID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_PlugDataContext
            Dim Del = (From d In db.PlugParameter _
                      Where d.ParID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                db.PlugParameter.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\PlugParameter.txt", Now)
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_PlugDataContext
            Dim Del = From d In db.PlugParameter _
                      Where ID.Contains(d.ParID) _
                      Select d
            For Each d In Del
                db.PlugParameter.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\PlugParameter.txt", Now)
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="PlugID"></param>
    ''' <param name="ParType"></param>
    ''' <param name="ParName"></param>
    ''' <param name="ParNote"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal PlugID As Integer, ByVal ParType As Integer, ByVal ParName As String, ByVal ParNote As String) As Integer
        Using db As New DB_PlugDataContext
            Dim mNewPlugParameter As New PlugParameter With {.PlugID = PlugID, .ParType = ParType, .ParName = ParName, .ParNote = ParNote}
            db.PlugParameter.InsertOnSubmit(mNewPlugParameter)
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\PlugParameter.txt", Now)
                Return mNewPlugParameter.ParID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="PlugID"></param>
    ''' <param name="ParType"></param>
    ''' <param name="ParName"></param>
    ''' <param name="ParNote"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal PlugID As Integer, ByVal ParType As Integer, ByVal ParName As String, ByVal ParNote As String) As Integer
        Using db As New DB_PlugDataContext
            Dim UpdatePlugParameter = (From c In db.PlugParameter _
                                       Where c.ParID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdatePlugParameter) Then
                With UpdatePlugParameter
                    .PlugID = PlugID
                    .ParType = ParType
                    .ParName = ParName
                    .ParNote = ParNote
                End With
                Try
                    db.SubmitChanges()
                    IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\PlugParameter.txt", Now)
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
    ''' <summary>
    ''' 修改插件页面操作说明
    ''' </summary>
    ''' <param name="mParID">页面操作ID</param>
    ''' <param name="NewParNote">新页面操作说明</param>
    ''' <returns>是否成功</returns>
    ''' <remarks></remarks>
    Public Function ChangeParameterName(ByVal mParID As Integer, ByVal NewParNote As String) As Boolean
        Using db As New DB_PlugDataContext
            Dim ChangePar = (From p In db.PlugParameter _
                            Where p.ParID = mParID _
                            Select p).FirstOrDefault
            If Not IsNothing(ChangePar) Then
                ChangePar.ParNote = NewParNote
                Try
                    db.SubmitChanges()
                    IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\PlugParameter.txt", Now)
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除所有页面操作和对应权限
    ''' </summary>
    ''' <param name="mPlugID">插件ID</param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function DeletePlugParameter(ByVal mPlugID As Integer) As Boolean
        Using db As New DB_PlugDataContext
            Dim DelPars = From p In db.PlugParameter _
                           Where p.PlugID = mPlugID _
                           Select p
            For Each d In DelPars
                db.PlugParameter.DeleteOnSubmit(d)
            Next
            Dim mUserSec As New clsPlugUserSecurity
            mUserSec.DeleteUserPlugSecurity(mPlugID)
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\PlugParameter.txt", Now)
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
End Class
