﻿Public Class clsPlugUserSecurity
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As PlugUserSecurity
        Using db As New DB_PlugDataContext
            Return (From c In db.PlugUserSecurity _
                    Where c.UserParameteID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有用户组权限
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq(ByVal SiteID As Integer) As IQueryable(Of PlugUserSecurity)
        Dim db As New DB_PlugDataContext
        Return From c In db.PlugUserSecurity _
               Where c.SiteID = SiteID _
               Order By c.UserParameteID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_PlugDataContext
            Dim Del = (From d In db.PlugUserSecurity _
                      Where d.UserParameteID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                Dim mSiteID As Integer = Del.SiteID
                db.PlugUserSecurity.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Security" & mSiteID.ToString & ".txt", Now)
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_PlugDataContext
            Dim Del = From d In db.PlugUserSecurity _
                      Where ID.Contains(d.UserParameteID) _
                      Select d
            Dim mSiteID As Integer
            For Each d In Del
                mSiteID = d.SiteID
                db.PlugUserSecurity.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Security" & mSiteID.ToString & ".txt", Now)
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="SiteID"></param>
    ''' <param name="GroupID"></param>
    ''' <param name="PlugID"></param>
    ''' <param name="ParID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal SiteID As Integer, ByVal GroupID As Integer, ByVal PlugID As Integer, ByVal ParID As Integer) As Integer
        Using db As New DB_PlugDataContext
            Dim mNewPlugUserSecurity As New PlugUserSecurity With {.SiteID = SiteID, .GroupID = GroupID, .PlugID = PlugID, .ParID = ParID}
            db.PlugUserSecurity.InsertOnSubmit(mNewPlugUserSecurity)
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Security" & SiteID.ToString & ".txt", Now)
                Return mNewPlugUserSecurity.UserParameteID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="SiteID"></param>
    ''' <param name="GroupID"></param>
    ''' <param name="PlugID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal SiteID As Integer, ByVal GroupID As Integer, ByVal PlugID As Integer) As Boolean
        Using db As New DB_PlugDataContext
            Dim mPars = (From p In db.PlugParameter _
                         Where p.PlugID = PlugID _
                         Select p.ParID).ToArray
            Dim mNewPlugUserSecurity() As PlugUserSecurity = Nothing
            For Each p In mPars
                If mNewPlugUserSecurity Is Nothing Then
                    ReDim mNewPlugUserSecurity(0)
                Else
                    ReDim Preserve mNewPlugUserSecurity(mNewPlugUserSecurity.Length)
                End If
                mNewPlugUserSecurity(UBound(mNewPlugUserSecurity)) = New PlugUserSecurity

                With mNewPlugUserSecurity(UBound(mNewPlugUserSecurity))
                    .SiteID = SiteID
                    .GroupID = GroupID
                    .PlugID = PlugID
                    .ParID = p
                End With
            Next
            If mNewPlugUserSecurity Is Nothing Then
                ReDim mNewPlugUserSecurity(0)
            Else
                ReDim Preserve mNewPlugUserSecurity(mNewPlugUserSecurity.Length)
            End If
            mNewPlugUserSecurity(UBound(mNewPlugUserSecurity)) = New PlugUserSecurity
            With mNewPlugUserSecurity(UBound(mNewPlugUserSecurity))
                .SiteID = SiteID
                .GroupID = GroupID
                .PlugID = PlugID
                .ParID = 0
            End With
            db.PlugUserSecurity.InsertAllOnSubmit(mNewPlugUserSecurity)
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Security" & SiteID.ToString & ".txt", Now)
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="UserParameteID"></param>
    ''' <param name="GroupID"></param>
    ''' <param name="PlugID"></param>
    ''' <param name="ParID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal UserParameteID As Integer, ByVal GroupID As Integer, ByVal PlugID As Integer, ByVal ParID As Integer) As Integer
        Using db As New DB_PlugDataContext
            Dim UpdatePlugUserSecurity = (From c In db.PlugUserSecurity _
                                          Where c.UserParameteID = UserParameteID _
                                          Select c).FirstOrDefault
            If Not IsNothing(UpdatePlugUserSecurity) Then
                With UpdatePlugUserSecurity
                    .GroupID = GroupID
                    .PlugID = PlugID
                    .ParID = ParID
                End With

                Try
                    db.SubmitChanges()
                    IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Security" & UpdatePlugUserSecurity.SiteID.ToString & ".txt", Now)
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除指定插件页面所有操作权限
    ''' </summary>
    ''' <param name="mPlugID">页面操作ID</param>
    ''' <remarks></remarks>
    Public Sub DeleteUserPlugSecurity(ByVal mPlugID As Integer)
        Using db As New DB_PlugDataContext
            Dim UserSe = From p In db.PlugUserSecurity _
                         Where p.PlugID = mPlugID _
                         Select p
            Dim mSiteID As Integer
            For Each u In UserSe
                mSiteID = u.SiteID
                db.PlugUserSecurity.DeleteOnSubmit(u)
            Next
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Security" & mSiteID.ToString & ".txt", Now)
            Catch ex As Exception

            End Try
        End Using
    End Sub

    ''' <summary>
    ''' 删除指定插件页面操作所有用户权限
    ''' </summary>
    ''' <param name="mParID">页面操作ID</param>
    ''' <remarks></remarks>
    Public Sub DeleteUserSecurity(ByVal mParID As Integer)
        Using db As New DB_PlugDataContext
            Dim UserSe = From p In db.PlugUserSecurity _
                         Where p.ParID = mParID _
                         Select p
            Dim mSiteID As Integer
            For Each u In UserSe
                mSiteID = u.SiteID
                db.PlugUserSecurity.DeleteOnSubmit(u)
            Next
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Security" & mSiteID.ToString & ".txt", Now)
            Catch ex As Exception

            End Try
        End Using
    End Sub
    ''' <summary>
    ''' 删除指定用户组的页面操作权限
    ''' </summary>
    ''' <param name="mParID">页面操作ID</param>
    ''' <param name="UserGroupID">用户组ID</param>
    ''' <remarks></remarks>
    Public Sub DeleteUserSecurity(ByVal mParID As Integer, ByVal UserGroupID As Integer)
        Using db As New DB_PlugDataContext
            Dim UserSe = From p In db.PlugUserSecurity _
                         Where p.ParID = mParID _
                         And p.GroupID = UserGroupID _
                         Select p
            Dim mSiteID As Integer
            For Each u In UserSe
                mSiteID = u.SiteID
                db.PlugUserSecurity.DeleteOnSubmit(u)
            Next
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Security" & mSiteID.ToString & ".txt", Now)
            Catch ex As Exception

            End Try
        End Using
    End Sub
    ''' <summary>
    ''' 删除指定用户组的页面操作权限
    ''' </summary>
    ''' <param name="mParID">页面操作ID</param>
    ''' <param name="UserGroupID">用户组ID</param>
    ''' <param name="mPlugID">插件ID</param>
    ''' <remarks></remarks>
    Public Sub DeleteUserSecurity(ByVal mParID() As Integer, ByVal UserGroupID As Integer, ByVal mPlugID As Integer)
        Using db As New DB_PlugDataContext
            Dim UserSe = From p In db.PlugUserSecurity _
                         Where mParID.Contains(p.ParID) _
                         And p.GroupID = UserGroupID _
                         And p.PlugID = mPlugID _
                         Select p
            Dim mSiteID As Integer
            For Each u In UserSe
                mSiteID = u.SiteID
                db.PlugUserSecurity.DeleteOnSubmit(u)
            Next
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Security" & mSiteID.ToString & ".txt", Now)
            Catch ex As Exception

            End Try
        End Using
    End Sub
    ''' <summary>
    ''' 删除指定用户组的页面操作权限
    ''' </summary>
    ''' <param name="UserGroupID">用户组ID</param>
    ''' <param name="mPlugID">插件ID</param>
    ''' <remarks></remarks>
    Public Sub DeleteUserPlugSecurity(ByVal mPlugID As Integer, ByVal UserGroupID As Integer)
        Using db As New DB_PlugDataContext
            Dim UserSe = From p In db.PlugUserSecurity _
                         Where mPlugID = p.PlugID _
                         And p.GroupID = UserGroupID _
                         Select p
            Dim mSiteID As Integer
            For Each u In UserSe
                mSiteID = u.SiteID
                db.PlugUserSecurity.DeleteOnSubmit(u)
            Next
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Security" & mSiteID.ToString & ".txt", Now)
            Catch ex As Exception

            End Try
        End Using
    End Sub
    ''' <summary>
    ''' 根据插件名称获取当前用户插件权限
    ''' </summary>
    ''' <param name="PlugName"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetUserPlugParameter(ByVal PlugName As String, ByVal UserGroupID As Integer) As List(Of PlugUserSecurity)
        Dim db As New DB_PlugDataContext
        Return (From g In db.Plug _
                Join u In db.PlugUserSecurity On g.ID Equals u.PlugID _
                Where g.PageSetFile = PlugName _
                And u.GroupID = UserGroupID _
                Select u).ToList
    End Function
End Class
