﻿Public Class clsAdv
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As Adv
        Using db As New DB_AdvDataContext
            Return (From c In db.Adv _
                    Where c.ID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq(ByVal SiteID As Integer) As IQueryable(Of Adv)
        Dim db As New DB_AdvDataContext
        Return From c In db.Adv _
               Where c.SiteID = SiteID _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_AdvDataContext
            Dim Del = (From d In db.Adv _
                      Where d.ID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                db.Adv.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_AdvDataContext
            Dim Del = From d In db.Adv _
                      Where ID.Contains(d.ID) _
                      Select d
            For Each d In Del
                db.Adv.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="ClassID"></param>
    ''' <param name="OrderID"></param>
    ''' <param name="SiteID"></param>
    ''' <param name="Name"></param>
    ''' <param name="Url"></param>
    ''' <param name="Pic"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal ClassID As Integer, ByVal OrderID As Integer, ByVal SiteID As Integer, ByVal Name As String, ByVal Url As String, ByVal Pic As String) As Integer
        Using db As New DB_AdvDataContext
            Dim mNewAdv As New Adv With {.ClassID = ClassID, .OrderID = OrderID, .SiteID = SiteID, .Name = Name, .Url = Url, .Pic = Pic}
            db.Adv.InsertOnSubmit(mNewAdv)
            Try
                db.SubmitChanges()
                Return mNewAdv.ID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="ClassID"></param>
    ''' <param name="OrderID"></param>
    ''' <param name="SiteID"></param>
    ''' <param name="Name"></param>
    ''' <param name="Url"></param>
    ''' <param name="Pic"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal ClassID As Integer, ByVal OrderID As Integer, ByVal SiteID As Integer, ByVal Name As String, ByVal Url As String, ByVal Pic As String) As Integer
        Using db As New DB_AdvDataContext
            Dim UpdateAdv = (From c In db.Adv _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateAdv) Then
                With UpdateAdv
                    .ClassID = ClassID
                    .OrderID = OrderID
                    .SiteID = SiteID
                    .Name = Name
                    .Url = Url
                    .Pic = Pic

                End With

                Try
                    db.SubmitChanges()
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
End Class

