﻿Public Class clsAdvClass
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As AdvClass
        Using db As New DB_AdvDataContext
            Return (From c In db.AdvClass _
                    Where c.ID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq(ByVal SiteID As Integer) As IQueryable(Of AdvClass)
        Dim db As New DB_AdvDataContext
        Return From c In db.AdvClass _
               Where c.SiteID = SiteID _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_AdvDataContext
            Dim Del = (From d In db.AdvClass _
                      Where d.ID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                db.AdvClass.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_AdvDataContext
            Dim Del = From d In db.AdvClass _
                      Where ID.Contains(d.ID) _
                      Select d
            For Each d In Del
                db.AdvClass.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="SiteID"></param>
    ''' <param name="ClassName"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal SiteID As Integer, ByVal ClassName As String) As Integer
        Using db As New DB_AdvDataContext
            Dim mNewAdvClass As New AdvClass With {.SiteID = SiteID, .ClassName = ClassName}
            db.AdvClass.InsertOnSubmit(mNewAdvClass)
            Try
                db.SubmitChanges()
                Return mNewAdvClass.ID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="SiteID"></param>
    ''' <param name="ClassName"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal SiteID As Integer, ByVal ClassName As String) As Integer
        Using db As New DB_AdvDataContext
            Dim UpdateAdvClass = (From c In db.AdvClass _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateAdvClass) Then
                With UpdateAdvClass
                    .SiteID = SiteID
                    .ClassName = ClassName

                End With

                Try
                    db.SubmitChanges()
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
End Class

