﻿Imports System.Web
Public Class clsArticle
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetSingle(ByVal ID As Integer) As Article
        Using db As New DB_ArticleDataContext
            Return (From c In db.Article _
                    Where c.ID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq(ByVal mSiteID As Integer) As IQueryable(Of Article)
        Dim db As New DB_ArticleDataContext
        Return From c In db.Article _
               Where c.SiteID = mSiteID _
               Order By c.ID Descending _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_ArticleDataContext
            Dim Del = (From d In db.Article _
                      Where d.ID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                Dim mSiteID As Integer = Del.SiteID
                db.Article.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Article" & mSiteID.ToString & ".txt", Now)
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_ArticleDataContext
            Dim Del = From d In db.Article _
                      Where ID.Contains(d.ID) _
                      Select d
            Dim mSiteID As Integer = 0
            For Each d In Del
                mSiteID = d.SiteID
                db.Article.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Article" & mSiteID.ToString & ".txt", Now)
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="ClassID"></param>
    ''' <param name="Point"></param>
    ''' <param name="GroupID"></param>
    ''' <param name="Hits"></param>
    ''' <param name="AddTime"></param>
    ''' <param name="txtContext"></param>
    ''' <param name="IsChecked"></param>
    ''' <param name="OpenComment"></param>
    ''' <param name="Grades"></param>
    ''' <param name="Title"></param>
    ''' <param name="TitleStyle"></param>
    ''' <param name="Author"></param>
    ''' <param name="scTitle"></param>
    ''' <param name="ShortTitle"></param>
    ''' <param name="KeyWord"></param>
    ''' <param name="ArticleTag"></param>
    ''' <param name="CopyFrom"></param>
    ''' <param name="PicName"></param>
    ''' <param name="ArticleAbstract"></param>
    ''' <param name="Appendix"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function Insert(ByVal mSiteID As Integer, ByVal ClassID As Integer, ByVal Point As Integer, ByVal GroupID As Integer, ByVal Hits As Integer, ByVal AddTime As DateTime, ByVal txtContext As String, ByVal IsChecked As Boolean, ByVal OpenComment As Boolean, ByVal Grades As Integer, ByVal Title As String, ByVal TitleStyle As String, ByVal Author As String, ByVal scTitle As String, ByVal ShortTitle As String, ByVal KeyWord As String, ByVal ArticleTag As String, ByVal CopyFrom As String, ByVal PicName As String, ByVal ArticleAbstract As String, ByVal Appendix As String, ByVal SkipURL As String) As Integer
        Using db As New DB_ArticleDataContext
            Dim mNewArticle As New Article With {.ClassID = ClassID, .SiteID = mSiteID, .Point = Point, .GroupID = GroupID, .Hits = Hits, .AddTime = AddTime, .txtContext = txtContext, .IsChecked = IsChecked, .OpenComment = OpenComment, .Grades = Grades, .Title = Title, .TitleStyle = TitleStyle, .Author = Author, .scTitle = scTitle, .ShortTitle = ShortTitle, .KeyWord = KeyWord, .ArticleTag = ArticleTag, .CopyFrom = CopyFrom, .PicName = PicName, .ArticleAbstract = ArticleAbstract, .Appendix = Appendix, .SkipURL = SkipURL}
            db.Article.InsertOnSubmit(mNewArticle)
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Article" & mSiteID.ToString & ".txt", Now)
                Return mNewArticle.ID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <param name="ClassID"></param>
    ''' <param name="Point"></param>
    ''' <param name="GroupID"></param>
    ''' <param name="Hits"></param>
    ''' <param name="AddTime"></param>
    ''' <param name="txtContext"></param>
    ''' <param name="IsChecked"></param>
    ''' <param name="OpenComment"></param>
    ''' <param name="Grades"></param>
    ''' <param name="Title"></param>
    ''' <param name="TitleStyle"></param>
    ''' <param name="Author"></param>
    ''' <param name="scTitle"></param>
    ''' <param name="ShortTitle"></param>
    ''' <param name="KeyWord"></param>
    ''' <param name="ArticleTag"></param>
    ''' <param name="CopyFrom"></param>
    ''' <param name="PicName"></param>
    ''' <param name="ArticleAbstract"></param>
    ''' <param name="Appendix"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function Save(ByVal ID As Integer, ByVal ClassID As Integer, ByVal Point As Integer, ByVal GroupID As Integer, ByVal Hits As Integer, ByVal AddTime As DateTime, ByVal txtContext As String, ByVal IsChecked As Boolean, ByVal OpenComment As Boolean, ByVal Grades As String, ByVal Title As String, ByVal TitleStyle As String, ByVal Author As String, ByVal scTitle As String, ByVal ShortTitle As String, ByVal KeyWord As String, ByVal ArticleTag As String, ByVal CopyFrom As String, ByVal PicName As String, ByVal ArticleAbstract As String, ByVal Appendix As String, ByVal SkipURL As String) As Integer
        Using db As New DB_ArticleDataContext
            Dim UpdateArticle = (From c In db.Article _
                                 Where c.ID = ID _
                                 Select c).FirstOrDefault
            If Not IsNothing(UpdateArticle) Then
                With UpdateArticle
                    .ClassID = ClassID
                    .Point = Point
                    .GroupID = GroupID
                    .Hits = Hits
                    .GradeCount = 1
                    .AddTime = AddTime
                    .txtContext = txtContext
                    .IsChecked = IsChecked
                    .OpenComment = OpenComment
                    .Grades = Grades
                    .Title = Title
                    .TitleStyle = TitleStyle
                    .Author = Author
                    .scTitle = scTitle
                    .ShortTitle = ShortTitle
                    .KeyWord = KeyWord
                    .ArticleTag = ArticleTag
                    .CopyFrom = CopyFrom
                    .PicName = PicName
                    .ArticleAbstract = ArticleAbstract
                    .Appendix = Appendix
                    .SkipURL = SkipURL
                End With
                Try
                    db.SubmitChanges()
                    IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Article" & UpdateArticle.SiteID.ToString & ".txt", Now)
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
    ''' <summary>
    ''' 修改文章评论属性
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function ChangeComment(ByVal ID As Integer) As Boolean
        Using db As New DB_ArticleDataContext
            Dim mArticle = (From a In db.Article _
                           Where a.ID = ID _
                           Select a).FirstOrDefault
            If mArticle IsNot Nothing Then
                mArticle.OpenComment = Not mArticle.OpenComment
                Try
                    db.SubmitChanges()
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 修改文章审核属性
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function ChangeChecked(ByVal ID As Integer) As Boolean
        Using db As New DB_ArticleDataContext
            Dim mArticle = (From a In db.Article _
                           Where a.ID = ID _
                           Select a).FirstOrDefault
            If mArticle IsNot Nothing Then
                mArticle.IsChecked = Not mArticle.IsChecked
                Try
                    db.SubmitChanges()
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
End Class
