﻿Imports System.Web
Imports System.Web.UI.WebControls

Public Class clsArticleClass
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As ArticleClass
        Using db As New DB_ArticleDataContext
            Return (From c In db.ArticleClass _
                    Where c.ClassID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq(ByVal mSiteID As Integer) As IQueryable(Of ArticleClass)
        Dim db As New DB_ArticleDataContext
        Return From c In db.ArticleClass _
               Where c.SiteID = mSiteID _
               Order By c.ClassLev, c.OrderID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_ArticleDataContext
            Dim Del = (From d In db.ArticleClass _
                      Where d.ClassID = ID _
                      Select d).FirstOrDefault
            Dim mSiteID As Integer = 0
            If Not IsNothing(Del) Then
                mSiteID = Del.SiteID
                If Del.ParentID > 0 Then
                    Dim pClass = (From c In db.ArticleClass _
                                 Where c.ClassID = Del.ParentID _
                                 Select c).FirstOrDefault
                    If Not IsNothing(pClass) Then
                        pClass.ChildCount = pClass.ChildCount - 1
                        Try
                            db.SubmitChanges()
                        Catch ex As Exception
                            Return False
                        End Try
                    End If
                End If
                db.ArticleClass.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\ArticleClass" & mSiteID.ToString & ".txt", Now)
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_ArticleDataContext
            Dim Del = From d In db.ArticleClass _
                      Where ID.Contains(d.ClassID) _
                      Select d
            Dim mSiteID As Integer
            For Each d In Del
                mSiteID = d.SiteID
                db.ArticleClass.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\ArticleClass" & mSiteID.ToString & ".txt", Now)
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="ParentID"></param>
    ''' <param name="ClassLev"></param>
    ''' <param name="ChildCount"></param>
    ''' <param name="OrderID"></param>
    ''' <param name="Flag"></param>
    ''' <param name="ClassName"></param>
    ''' <param name="PageKey"></param>
    ''' <param name="PageContext"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal mSiteID As Integer, ByVal ParentID As Integer, ByVal ClassLev As Integer, ByVal ChildCount As Integer, ByVal OrderID As Integer, ByVal Flag As String, ByVal ClassName As String, ByVal PageKey As String, ByVal PageContext As String) As Integer
        Using db As New DB_ArticleDataContext
            Dim mTopID As Integer = 0
            Dim pClass = (From p In db.ArticleClass _
                         Where p.ClassID = ParentID _
                         Select p).FirstOrDefault
            If pClass IsNot Nothing Then
                pClass.ChildCount += 1
                If pClass.TopID > 0 Then
                    mTopID = pClass.TopID
                Else
                    mTopID = pClass.ClassID
                End If
                Try
                    db.SubmitChanges()
                Catch ex As Exception
                    Return 0
                End Try
            End If
            Dim mNewArticleClass As New ArticleClass With {.SiteID = mSiteID, .TopID = mTopID, .ParentID = ParentID, .ClassLev = ClassLev, .ChildCount = ChildCount, .OrderID = OrderID, .Flag = Flag, .ClassName = ClassName, .PageKey = PageKey, .PageContext = PageContext}
            db.ArticleClass.InsertOnSubmit(mNewArticleClass)
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\ArticleClass" & mSiteID.ToString & ".txt", Now)
                Return mNewArticleClass.ClassID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function

    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="ClassID"></param>
    ''' <param name="Flag"></param>
    ''' <param name="ClassName"></param>
    ''' <param name="PageKey"></param>
    ''' <param name="PageContext"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ClassID As Integer, ByVal Flag As String, ByVal ClassName As String, ByVal PageKey As String, ByVal PageContext As String) As Integer
        Using db As New DB_ArticleDataContext
            Dim UpdateArticleClass = (From c In db.ArticleClass _
                                       Where c.ClassID = ClassID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateArticleClass) Then
                With UpdateArticleClass
                    .Flag = Flag
                    .ClassName = ClassName
                    .PageKey = PageKey
                    .PageContext = PageContext
                End With
                Try
                    db.SubmitChanges()
                    IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\ArticleClass" & UpdateArticleClass.SiteID.ToString & ".txt", Now)
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function

    Public Sub FillDplClass(ByVal DplName As System.Web.UI.WebControls.DropDownList, ByVal mSiteID As Integer)
        Dim ClassItem() As ListItem = Nothing
        Dim ClassDepth As Integer = 0
        Dim IsFind As Boolean = False
        DplName.Items.Clear()
        Dim ArticleClasses = GetLinq(mSiteID).ToList
        For Each PowerClass In ArticleClasses
            If IsNothing(ClassItem) Then
                ReDim ClassItem(0)
            Else
                For Each Fitem As ListItem In ClassItem
                    If PowerClass.ClassID = CType(Fitem.Value, Integer) Then
                        IsFind = True
                        Exit For
                    End If
                Next
                If IsFind Then
                    IsFind = False
                    Continue For
                End If
                ReDim Preserve ClassItem(UBound(ClassItem) + 1)
            End If
            ClassItem(UBound(ClassItem)) = New ListItem(PowerClass.ClassName, PowerClass.ClassID.ToString)
            If PowerClass.ChildCount > 0 Then
                ClassDepth = 1
                ClassItem = AddPowerChild(ClassItem, PowerClass.ClassID, ArticleClasses, ClassDepth)
            End If
        Next
        If Not IsNothing(ClassItem) Then
            DplName.Items.AddRange(ClassItem)
        End If
        DplName.Items.Add(New ListItem("所有栏目", "0"))
        DplName.SelectedValue = "0"
    End Sub
    Private Shared Function AddPowerChild(ByVal mItem() As ListItem, ByVal ClassID As Integer, ByVal PowerList As List(Of ArticleClass), ByVal mDepth As Integer) As ListItem()
        Dim strValue As String = ""
        Dim mCount As Integer = 0
        Dim Powers = PowerList.Where(Function(Power) Power.ParentID = ClassID)
        Dim ChildCount As Integer = Powers.Count
        For Each mPower In Powers
            mCount += 1
            For i As Integer = 1 To mDepth
                strValue += "..."
            Next
            If ChildCount > mCount Then
                strValue += "├  "
            Else
                strValue += "└  "
            End If
            If Not mItem.Contains(New ListItem(mPower.ClassName, mPower.ClassID.ToString)) Then
                ReDim Preserve mItem(UBound(mItem) + 1)
                mItem(UBound(mItem)) = New ListItem(strValue & mPower.ClassName, mPower.ClassID.ToString)

                strValue = ""
                If mPower.ChildCount > 0 Then
                    mItem = AddPowerChild(mItem, mPower.ClassID, PowerList, mDepth + 1)
                End If
            End If
        Next
        Return mItem
    End Function
    ''' <summary>
    ''' 排序节点向上向下移动
    ''' </summary>
    ''' <param name="ParentClassID">父级序号</param>
    ''' <param name="ThisClassID">栏目序号</param>
    ''' <param name="IsUp">是否向上移动</param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function ChangeOrder(ByVal mSiteID As Integer, ByVal ParentClassID As Integer, ByVal ThisClassID As Integer, ByVal IsUp As Boolean)
        Using db As New DB_ArticleDataContext
            Dim MeOrderID As Integer = 1
            Dim mTmpOrderID As Integer = 1
            Dim rtnValue As Boolean = True
            Dim mThisClass = (From c In db.ArticleClass _
                             Where c.ClassID = ThisClassID _
                             Select c).FirstOrDefault
            If mThisClass IsNot Nothing Then
                mTmpOrderID = mThisClass.OrderID
                If IsUp Then
                    If mThisClass.OrderID > 1 Then
                        MeOrderID = mThisClass.OrderID - 1
                    End If
                Else
                    MeOrderID = mThisClass.OrderID + 1
                End If
                mThisClass.OrderID = MeOrderID
                Dim mThatClass = (From c In db.ArticleClass _
                                  Where c.OrderID = MeOrderID _
                                  And c.ParentID = ParentClassID _
                                  Select c).FirstOrDefault
                If mThatClass IsNot Nothing Then
                    mThatClass.OrderID = mTmpOrderID
                    Try
                        db.SubmitChanges()
                    Catch ex As Exception
                        Return False
                    End Try
                End If
            End If
            Return True
        End Using
    End Function
End Class
