﻿Public Class clsErrorMessage
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As ErrorMessage
        Using db As New DB_ErrorMessageDataContext
            Return (From c In db.ErrorMessage _
                    Where c.ID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq() As IQueryable(Of ErrorMessage)
        Dim db As New DB_ErrorMessageDataContext
        Return From c In db.ErrorMessage _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_ErrorMessageDataContext
            Dim Del = (From d In db.ErrorMessage _
                      Where d.ID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                db.ErrorMessage.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_ErrorMessageDataContext
            Dim Del = From d In db.ErrorMessage _
                      Where ID.Contains(d.ID) _
                      Select d
            For Each d In Del
                db.ErrorMessage.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="Source"></param>
    ''' <param name="Message"></param>
    ''' <param name="StackTrace"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal Source As String, ByVal Message As String, ByVal StackTrace As String) As Integer
        Using db As New DB_ErrorMessageDataContext
            Dim mNewErrorMessage As New ErrorMessage With {.Source = Source, .Message = Message, .StackTrace = StackTrace}
            db.ErrorMessage.InsertOnSubmit(mNewErrorMessage)
            Try
                db.SubmitChanges()
                Return mNewErrorMessage.ID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="Source"></param>
    ''' <param name="Message"></param>
    ''' <param name="StackTrace"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal Source As String, ByVal Message As String, ByVal StackTrace As String) As Integer
        Using db As New DB_ErrorMessageDataContext
            Dim UpdateErrorMessage = (From c In db.ErrorMessage _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateErrorMessage) Then
                With UpdateErrorMessage
                    .Source = Source
                    .Message = Message
                    .StackTrace = StackTrace

                End With

                Try
                    db.SubmitChanges()
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
End Class
