﻿Public Class clsGoodsAssess
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As GoodsAssess
        Using db As New DB_ExchangeDataContext
            Return (From c In db.GoodsAssess _
                    Where c.GoodsID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq() As IQueryable(Of GoodsAssess)
        Dim db As New DB_ExchangeDataContext
        Return From c In db.GoodsAssess _
               Order By c.GoodsID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_ExchangeDataContext
            Dim Del = (From d In db.GoodsAssess _
                      Where d.GoodsID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                db.GoodsAssess.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_ExchangeDataContext
            Dim Del = From d In db.GoodsAssess _
                      Where ID.Contains(d.GoodsID) _
                      Select d
            For Each d In Del
                db.GoodsAssess.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="GoodsClassID"></param>
    ''' <param name="UserID"></param>
    ''' <param name="Depreciation"></param>
    ''' <param name="GoodsState"></param>
    ''' <param name="AssessPoint"></param>
    ''' <param name="AddTime"></param>
    ''' <param name="OriginalPrice"></param>
    ''' <param name="SellingPrice"></param>
    ''' <param name="GoodsName"></param>
    ''' <param name="GoodsPic"></param>
    ''' <param name="Note"></param>
    ''' <param name="GoodsIntegrity"></param>
    ''' <param name="Assess"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal GoodsID As Integer, ByVal GoodsClassID As Integer, ByVal UserID As Integer, ByVal Depreciation As Integer, ByVal GoodsState As Integer, ByVal AddTime As DateTime, ByVal OriginalPrice As Double, ByVal SellingPrice As Double, ByVal GoodsName As String, ByVal GoodsPic As String, ByVal Note As String, ByVal GoodsIntegrity As String, Optional ByVal Assess As String = "", Optional ByVal AssessPoint As Integer = 0) As Integer
        Using db As New DB_ExchangeDataContext
            Dim mNewGoodsAssess As New GoodsAssess With {.GoodsID = GoodsID, .GoodsClassID = GoodsClassID, .UserID = UserID, .Depreciation = Depreciation, .GoodsState = GoodsState, .AssessPoint = AssessPoint, .AddTime = AddTime, .OriginalPrice = OriginalPrice, .SellingPrice = SellingPrice, .GoodsName = GoodsName, .GoodsPic = GoodsPic, .Note = Note, .GoodsIntegrity = GoodsIntegrity, .Assess = Assess}
            db.GoodsAssess.InsertOnSubmit(mNewGoodsAssess)
            Try
                db.SubmitChanges()
                Return mNewGoodsAssess.GoodsID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="GoodsClassID"></param>
    ''' <param name="UserID"></param>
    ''' <param name="Depreciation"></param>
    ''' <param name="GoodsState"></param>
    ''' <param name="AssessPoint"></param>
    ''' <param name="AddTime"></param>
    ''' <param name="OriginalPrice"></param>
    ''' <param name="SellingPrice"></param>
    ''' <param name="GoodsName"></param>
    ''' <param name="GoodsPic"></param>
    ''' <param name="Note"></param>
    ''' <param name="GoodsIntegrity"></param>
    ''' <param name="Assess"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal GoodsClassID As Integer, ByVal UserID As Integer, ByVal Depreciation As Integer, ByVal GoodsState As Integer, ByVal AddTime As DateTime, ByVal OriginalPrice As Double, ByVal SellingPrice As Double, ByVal GoodsName As String, ByVal GoodsPic As String, ByVal Note As String, ByVal GoodsIntegrity As String, ByVal Assess As String, ByVal AssessPoint As Integer) As Integer
        Using db As New DB_ExchangeDataContext
            Dim UpdateGoodsAssess = (From c In db.GoodsAssess _
                                       Where c.GoodsID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateGoodsAssess) Then
                With UpdateGoodsAssess
                    .GoodsClassID = GoodsClassID
                    .UserID = UserID
                    .Depreciation = Depreciation
                    .GoodsState = GoodsState
                    .AssessPoint = AssessPoint
                    .AddTime = AddTime
                    .OriginalPrice = OriginalPrice
                    .SellingPrice = SellingPrice
                    .GoodsName = GoodsName
                    .GoodsPic = GoodsPic
                    .Note = Note
                    .GoodsIntegrity = GoodsIntegrity
                    .Assess = Assess
                End With

                Try
                    db.SubmitChanges()
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
End Class
