﻿Public Class clsGoodsRegister
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As GoodsRegister
        Using db As New DB_ExchangeDataContext
            Return (From c In db.GoodsRegister _
                    Where c.ID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq() As IQueryable(Of GoodsRegister)
        Dim db As New DB_ExchangeDataContext
        Return From c In db.GoodsRegister _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 商品下架操作
    ''' GoodsState : 1下架 2交易成功
    ''' </summary>
    ''' <param name="GoodID">商品序号</param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GoodsDown(ByVal GoodID As Integer) As Boolean
        Using db As New DB_ExchangeDataContext
            Dim DownGoods = (From g In db.GoodsRegister _
                            Where g.ID = GoodID _
                            Select g).FirstOrDefault
            If DownGoods IsNot Nothing Then
                Dim mGoodsAssess As New clsGoodsAssess
                With DownGoods
                    mGoodsAssess.Insert(.ID, .GoodsClassID, .UserID, .Depreciation, 1, Now, .OriginalPrice, .SellingPrice, .GoodsName, .GoodsPic, .Note, .GoodsIntegrity)
                End With
                db.GoodsRegister.DeleteOnSubmit(DownGoods)
                Try
                    db.SubmitChanges()
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            End If

        End Using
    End Function

    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_ExchangeDataContext
            Dim Del = (From d In db.GoodsRegister _
                      Where d.ID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                db.GoodsRegister.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_ExchangeDataContext
            Dim Del = From d In db.GoodsRegister _
                      Where ID.Contains(d.ID) _
                      Select d
            For Each d In Del
                db.GoodsRegister.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="ClassID"></param>
    ''' <param name="UserID"></param>
    ''' <param name="Depreciation"></param>
    ''' <param name="OriginalPrice"></param>
    ''' <param name="SellingPrice"></param>
    ''' <param name="GoodsName"></param>
    ''' <param name="GoodsPic"></param>
    ''' <param name="Note"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal ClassID As Integer, ByVal UserID As Integer, ByVal Depreciation As Integer, ByVal OriginalPrice As Double, ByVal SellingPrice As Double, ByVal GoodsName As String, ByVal GoodsPic As String, ByVal Note As String) As Integer
        Using db As New DB_ExchangeDataContext
            Dim mNewGoodsRegister As New GoodsRegister With {.GoodsClassID = ClassID, .UserID = UserID, .Depreciation = Depreciation, .OriginalPrice = OriginalPrice, .SellingPrice = SellingPrice, .GoodsName = GoodsName, .GoodsPic = GoodsPic, .Note = Note}
            db.GoodsRegister.InsertOnSubmit(mNewGoodsRegister)
            Try
                db.SubmitChanges()
                Return mNewGoodsRegister.ID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="ClassID"></param>
    ''' <param name="UserID"></param>
    ''' <param name="Depreciation"></param>
    ''' <param name="GoodsState"></param>
    ''' <param name="OriginalPrice"></param>
    ''' <param name="SellingPrice"></param>
    ''' <param name="GoodsName"></param>
    ''' <param name="GoodsPic"></param>
    ''' <param name="Note"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal ClassID As Integer, ByVal UserID As Integer, ByVal Depreciation As Integer, ByVal GoodsState As Integer, ByVal OriginalPrice As Double, ByVal SellingPrice As Double, ByVal GoodsName As String, ByVal GoodsPic As String, ByVal Note As String) As Integer
        Using db As New DB_ExchangeDataContext
            Dim UpdateGoodsRegister = (From c In db.GoodsRegister _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateGoodsRegister) Then
                With UpdateGoodsRegister
                    .GoodsClassID = ClassID
                    .UserID = UserID
                    .Depreciation = Depreciation
                    .OriginalPrice = OriginalPrice
                    .SellingPrice = SellingPrice
                    .GoodsName = GoodsName
                    .GoodsPic = GoodsPic
                    .Note = Note

                End With

                Try
                    db.SubmitChanges()
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
End Class
