﻿Public Class clsHouseInfo
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As HouseInfo
        Using db As New DB_HouseDataContext
            Return (From c In db.HouseInfo _
                    Where c.ID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq() As IQueryable(Of HouseInfo)
        Dim db As New DB_HouseDataContext
        Return From c In db.HouseInfo _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_HouseDataContext
            Dim Del = (From d In db.HouseInfo _
                      Where d.ID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                db.HouseInfo.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_HouseDataContext
            Dim Del = From d In db.HouseInfo _
                      Where ID.Contains(d.ID) _
                      Select d
            For Each d In Del
                db.HouseInfo.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="ClassID"></param>
    ''' <param name="Area"></param>
    ''' <param name="Title"></param>
    ''' <param name="HousePosition"></param>
    ''' <param name="Orientation"></param>
    ''' <param name="HousePics"></param>
    ''' <param name="TrafficSigns"></param>
    ''' <param name="Note"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal ClassID As Integer, ByVal Area As String, ByVal Title As String, ByVal HousePosition As String, ByVal Orientation As String, ByVal HousePics As String, ByVal TrafficSigns As String, ByVal Note As String, ByVal Prices As Integer, ByVal IsTop As Boolean, ByVal HouseType As String) As Integer
        Using db As New DB_HouseDataContext
            Dim mNewHouseInfo As New HouseInfo With {.ClassID = ClassID, .Area = Area, .Title = Title, .HousePosition = HousePosition, .Orientation = Orientation, .HousePics = HousePics, .TrafficSigns = TrafficSigns, .Note = Note, .Prices = Prices, .IsTop = IsTop, .HouseType = HouseType}
            db.HouseInfo.InsertOnSubmit(mNewHouseInfo)
            Try
                db.SubmitChanges()
                Return mNewHouseInfo.ID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="ClassID"></param>
    ''' <param name="Area"></param>
    ''' <param name="Title"></param>
    ''' <param name="HousePosition"></param>
    ''' <param name="Orientation"></param>
    ''' <param name="HousePics"></param>
    ''' <param name="TrafficSigns"></param>
    ''' <param name="Note"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal ClassID As Integer, ByVal Area As String, ByVal Title As String, ByVal HousePosition As String, ByVal Orientation As String, ByVal HousePics As String, ByVal TrafficSigns As String, ByVal Note As String, ByVal Prices As Integer, ByVal IsTop As Boolean, ByVal HouseType As String) As Integer
        Using db As New DB_HouseDataContext
            Dim UpdateHouseInfo = (From c In db.HouseInfo _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateHouseInfo) Then
                With UpdateHouseInfo
                    .ClassID = ClassID
                    .Area = Area
                    .Title = Title
                    .HousePosition = HousePosition
                    .Orientation = Orientation
                    .HousePics = HousePics
                    .TrafficSigns = TrafficSigns
                    .Note = Note
                    .Prices = Prices
                    .IsTop = IsTop
                    .HouseType = HouseType
                End With

                Try
                    db.SubmitChanges()
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
End Class
