﻿Public Class clsSQLData
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As SQLData
        Using db As New DB_SQLDataContext
            Return (From c In db.SQLData _
                    Where c.ID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq(ByVal SiteID As Integer) As IQueryable(Of SQLData)
        Dim db As New DB_SQLDataContext
        Return From c In db.SQLData _
               Where c.SiteID = SiteID _
               Order By c.ID _
               Select c
    End Function

    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq(ByVal SQLID() As String) As IQueryable(Of SQLData)
        Dim db As New DB_SQLDataContext
        Return From c In db.SQLData _
               Where SQLID.Contains(c.ID.ToString) _
               Order By c.ID _
               Select c
    End Function

    Public Shared Function GetListOfClass(ByVal ClassID As Integer) As IQueryable(Of SQLData)
        Dim db As New DB_SQLDataContext
        Return From c In db.SQLData _
               Where c.ClassID = ClassID _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_SQLDataContext

            Dim Del = (From d In db.SQLData _
                      Where d.ID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                Dim mSiteID As Integer = Del.SiteID
                Dim clsDesign As New clsSQLDesign
                clsDesign.Delete(ID)
                db.SQLData.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\SQL" & mSiteID.ToString & ".txt", Now)
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_SQLDataContext
            Dim Del = From d In db.SQLData _
                      Where ID.Contains(d.ID) _
                      Select d
            Dim mSiteID As Integer
            Dim clsDesign As New clsSQLDesign
            clsDesign.Delete(ID)
            For Each d In Del
                mSiteID = d.SiteID
                db.SQLData.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\SQL" & mSiteID.ToString & ".txt", Now)
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="SiteID"></param>
    ''' <param name="ClassID"></param>
    ''' <param name="CacheLifeType"></param>
    ''' <param name="SQLName"></param>
    ''' <param name="SQLType"></param>
    ''' <param name="SQLData"></param>
    ''' <param name="CountSQL"></param>
    ''' <param name="DependOf"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal SiteID As Integer, ByVal ClassID As Integer, ByVal CacheLifeType As Integer, ByVal SQLName As String, ByVal SQLType As String, ByVal SQLData As String, ByVal CountSQL As String, ByVal DependOf As String) As Integer
        Using db As New DB_SQLDataContext
            Dim mNewSQLData As New SQLData With {.SiteID = SiteID, .ClassID = ClassID, .CacheLifeType = CacheLifeType, .SQLName = SQLName, .SQLType = SQLType, .SQLData = SQLData, .CountSQL = CountSQL, .DependOf = DependOf}
            db.SQLData.InsertOnSubmit(mNewSQLData)
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\SQL" & SiteID.ToString & ".txt", Now)
                Return mNewSQLData.ID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="ClassID"></param>
    ''' <param name="CacheLifeType"></param>
    ''' <param name="SQLName"></param>
    ''' <param name="SQLType"></param>
    ''' <param name="SQLData"></param>
    ''' <param name="CountSQL"></param>
    ''' <param name="DependOf"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal ClassID As Integer, ByVal CacheLifeType As Integer, ByVal SQLName As String, ByVal SQLType As String, ByVal SQLData As String, ByVal CountSQL As String, ByVal DependOf As String) As Integer
        Using db As New DB_SQLDataContext
            Dim UpdateSQLData = (From c In db.SQLData _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateSQLData) Then
                With UpdateSQLData
                    .ClassID = ClassID
                    .CacheLifeType = CacheLifeType
                    .SQLName = SQLName
                    .SQLType = SQLType
                    .SQLData = SQLData
                    .CountSQL = CountSQL
                    .DependOf = DependOf
                End With

                Try
                    db.SubmitChanges()
                    IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\SQL" & UpdateSQLData.SiteID.ToString & ".txt", Now)
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
End Class
