﻿Public Class clsSQLDesign
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="SQLID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal SQLID As Integer) As SQLDesign
        Using db As New DB_SQLDataContext
            Return (From c In db.SQLDesign _
                    Where c.SQLID = SQLID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq() As IQueryable(Of SQLDesign)
        Dim db As New DB_SQLDataContext
        Return From c In db.SQLDesign _
               Order By c.SQLID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_SQLDataContext
            Dim Del = (From d In db.SQLDesign _
                      Where d.SQLID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                db.SQLDesign.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_SQLDataContext
            Dim Del = From d In db.SQLDesign _
                      Where ID.Contains(d.SQLID) _
                      Select d
            For Each d In Del
                db.SQLDesign.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="hfWhere"></param>
    ''' <param name="hfOrderBY"></param>
    ''' <param name="hfSelectFields"></param>
    ''' <param name="hfTableJson"></param>
    ''' <param name="hfHTMLMain"></param>
    ''' <param name="hfHTMLWhere"></param>
    ''' <param name="hfHTMLOrder"></param>
    ''' <param name="hfInner"></param>
    ''' <param name="hfHTMLInner"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal SQLID As Integer, ByVal hfWhere As String, ByVal hfOrderBY As String, ByVal hfSelectFields As String, ByVal hfTableJson As String, ByVal hfHTMLMain As String, ByVal hfHTMLWhere As String, ByVal hfHTMLOrder As String, ByVal hfInner As String, ByVal hfHTMLInner As String) As Integer
        Using db As New DB_SQLDataContext
            Dim mNewSQLDesign As New SQLDesign With {.SQLID = SQLID, .hfWhere = hfWhere, .hfOrderBY = hfOrderBY, .hfSelectFields = hfSelectFields, .hfTableJson = hfTableJson, .hfHTMLMain = hfHTMLMain, .hfHTMLWhere = hfHTMLWhere, .hfHTMLOrder = hfHTMLOrder, .hfInner = hfInner, .hfHTMLInner = hfHTMLInner}
            db.SQLDesign.InsertOnSubmit(mNewSQLDesign)
            Try
                db.SubmitChanges()
                Return mNewSQLDesign.SQLID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="hfWhere"></param>
    ''' <param name="hfOrderBY"></param>
    ''' <param name="hfSelectFields"></param>
    ''' <param name="hfTableJson"></param>
    ''' <param name="hfHTMLMain"></param>
    ''' <param name="hfHTMLWhere"></param>
    ''' <param name="hfHTMLOrder"></param>
    ''' <param name="hfInner"></param>
    ''' <param name="hfHTMLInner"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal hfWhere As String, ByVal hfOrderBY As String, ByVal hfSelectFields As String, ByVal hfTableJson As String, ByVal hfHTMLMain As String, ByVal hfHTMLWhere As String, ByVal hfHTMLOrder As String, ByVal hfInner As String, ByVal hfHTMLInner As String) As Integer
        Using db As New DB_SQLDataContext
            Dim UpdateSQLDesign = (From c In db.SQLDesign _
                                       Where c.SQLID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateSQLDesign) Then
                With UpdateSQLDesign
                    .hfWhere = hfWhere
                    .hfOrderBY = hfOrderBY
                    .hfSelectFields = hfSelectFields
                    .hfTableJson = hfTableJson
                    .hfHTMLMain = hfHTMLMain
                    .hfHTMLWhere = hfHTMLWhere
                    .hfHTMLOrder = hfHTMLOrder
                    .hfInner = hfInner
                    .hfHTMLInner = hfHTMLInner

                End With

                Try
                    db.SubmitChanges()
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
End Class
