﻿Public Class clsSQLTemplate
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As SQLTemplate
        Using db As New DB_SQLDataContext
            Return (From c In db.SQLTemplate _
                    Where c.ID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq(ByVal SiteID As Integer) As IQueryable(Of SQLTemplate)
        Dim db As New DB_SQLDataContext
        Return From c In db.SQLTemplate _
               Where c.SiteID = SiteID _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_SQLDataContext
            Dim Del = (From d In db.SQLTemplate _
                      Where d.ID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                db.SQLTemplate.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_SQLDataContext
            Dim Del = From d In db.SQLTemplate _
                      Where ID.Contains(d.ID) _
                      Select d
            For Each d In Del
                db.SQLTemplate.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="SQLName"></param>
    ''' <param name="SQLContent"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal SiteID As Integer, ByVal SQLName As String, ByVal SQLContent As String) As Integer
        Using db As New DB_SQLDataContext
            Dim mNewSQLTemplate As New SQLTemplate With {.SiteID = SiteID, .SQLName = SQLName, .SQLContent = SQLContent}
            db.SQLTemplate.InsertOnSubmit(mNewSQLTemplate)
            Try
                db.SubmitChanges()
                Return mNewSQLTemplate.ID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="SQLName"></param>
    ''' <param name="SQLContent"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal SQLName As String, ByVal SQLContent As String) As Integer
        Using db As New DB_SQLDataContext
            Dim UpdateSQLTemplate = (From c In db.SQLTemplate _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateSQLTemplate) Then
                With UpdateSQLTemplate
                    .SQLName = SQLName
                    .SQLContent = SQLContent

                End With

                Try
                    db.SubmitChanges()
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
End Class
