﻿Imports System.Web

Public Class clsSQLUrl
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As SQLUrl
        Using db As New DB_SQLDataContext
            Return (From c In db.SQLUrl _
                    Where c.ID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq(ByVal SiteID As Integer) As IQueryable(Of SQLUrl)
        Dim db As New DB_SQLDataContext
        Return From c In db.SQLUrl _
               Where c.SiteID = SiteID _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetSQLLinq(ByVal SQLID As Integer) As IQueryable(Of SQLUrl)
        Dim db As New DB_SQLDataContext
        Return From c In db.SQLUrl _
               Where c.SQLID = SQLID _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq(ByVal ID() As Integer) As IQueryable(Of SQLUrl)
        Dim db As New DB_SQLDataContext
        Return From c In db.SQLUrl _
               Where ID.Contains(c.SQLID) _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_SQLDataContext
            Dim Del = (From d In db.SQLUrl _
                      Where d.ID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                Dim mSiteID As Integer = Del.SiteID
                db.SQLUrl.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\SQLUrl" & mSiteID.ToString & ".txt", Now)
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除SQL序号关联所有映射
    ''' </summary>
    ''' <param name="SQLID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function DeleteSQL(ByVal SQLID As Integer) As Boolean
        Using db As New DB_SQLDataContext
            Dim Del = From d In db.SQLUrl _
                      Where d.SQLID = SQLID _
                      Select d
            Dim mSiteID As Integer
            For Each d In Del
                mSiteID = d.SiteID
                db.SQLUrl.DeleteOnSubmit(Del)
            Next
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\SQLUrl" & mSiteID.ToString & ".txt", Now)
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 删除SQL序号关联所有映射
    ''' </summary>
    ''' <param name="SQLID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function DeleteSQL(ByVal SQLID() As Integer) As Boolean
        Using db As New DB_SQLDataContext
            Dim Del = From d In db.SQLUrl _
                      Where SQLID.Contains(d.SQLID) _
                      Select d
            Dim mSiteID As Integer = 0
            For Each d In Del
                mSiteID = d.SiteID
                db.SQLUrl.DeleteOnSubmit(Del)
            Next
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\SQLUrl" & mSiteID.ToString & ".txt", Now)
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_SQLDataContext
            Dim Del = From d In db.SQLUrl _
                      Where ID.Contains(d.ID) _
                      Select d
            Dim mSiteID As Integer = 0
            For Each d In Del
                mSiteID = d.SiteID
                db.SQLUrl.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\SQLUrl" & mSiteID.ToString & ".txt", Now)
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="LookFor"></param>
    ''' <param name="SendTo"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal SQLID As Integer, ByVal LookFor As String, ByVal SendTo As String, ByVal SiteID As Integer) As Integer
        Using db As New DB_SQLDataContext

            Dim mNewSQLUrl As New SQLUrl With {.SQLID = SQLID, .SiteID = SiteID, .LookFor = LookFor, .SendTo = SendTo}
            db.SQLUrl.InsertOnSubmit(mNewSQLUrl)
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\SQLUrl" & SiteID.ToString & ".txt", Now)
                Return mNewSQLUrl.ID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="LookFor"></param>
    ''' <param name="SendTo"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal LookFor As String, ByVal SendTo As String) As Integer
        Using db As New DB_SQLDataContext
            Dim UpdateSQLUrl = (From c In db.SQLUrl _
                                Where c.ID = ID _
                                Select c).FirstOrDefault
            If Not IsNothing(UpdateSQLUrl) Then
                With UpdateSQLUrl
                    .LookFor = LookFor
                    .SendTo = SendTo
                End With

                Try
                    db.SubmitChanges()
                    IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\SQLUrl" & UpdateSQLUrl.SiteID.ToString & ".txt", Now)
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
End Class
