﻿Public Class clsTableData
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As TableData
        Using db As New DB_SQLDataContext
            Return (From c In db.TableData _
                    Where c.ID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq() As IQueryable(Of TableData)
        Dim db As New DB_SQLDataContext
        Return From c In db.TableData _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_SQLDataContext
            Dim Del = (From d In db.TableData _
                      Where d.ID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                Dim mclsField As New clsTableFields
                mclsField.Delete(Del.TableName)
                db.TableData.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\TableData.txt", Now)
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_SQLDataContext
            Dim Del = From d In db.TableData _
                      Where ID.Contains(d.ID) _
                      Select d
            For Each d In Del
                db.TableData.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\TableData.txt", Now)
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="TableName"></param>
    ''' <param name="TableNote"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal TableName As String, ByVal TableNote As String) As Integer
        Using db As New DB_SQLDataContext
            Dim mNewTableData As New TableData With {.TableName = TableName, .TableNote = TableNote}
            db.TableData.InsertOnSubmit(mNewTableData)
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\TableData.txt", Now)
                Return mNewTableData.ID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="TableName"></param>
    ''' <param name="TableNote"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal TableNote As String, Optional ByVal TableName As String = "") As Integer
        Using db As New DB_SQL.DB_SQLDataContext
            Dim UpdateTableData = (From c In db.TableData _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateTableData) Then
                With UpdateTableData
                    If TableName.Length > 0 Then .TableName = TableName
                    .TableNote = TableNote
                End With

                Try
                    db.SubmitChanges()
                    IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\TableData.txt", Now)
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
End Class
