﻿Public Class clsTableFields
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As TableFields
        Using db As New DB_SQLDataContext
            Return (From c In db.TableFields _
                    Where c.ID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq() As IQueryable(Of TableFields)
        Dim db As New DB_SQLDataContext
        Return From c In db.TableFields _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq(ByVal FieldsID() As Integer) As IQueryable(Of TableFields)
        Dim db As New DB_SQLDataContext
        Return From c In db.TableFields _
               Where FieldsID.Contains(c.ID) _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 获取指定表下所有字段
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq(ByVal TableName As String) As IQueryable(Of TableFields)
        Dim db As New DB_SQLDataContext
        Return From c In db.TableFields _
               Where c.TableName = TableName _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 获取指定表下所有字段
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq(ByVal TableName() As String) As IQueryable(Of TableFields)
        Dim db As New DB_SQLDataContext
        Return From c In db.TableFields _
               Where TableName.Contains(c.TableName) _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_SQLDataContext
            Dim Del = (From d In db.TableFields _
                      Where d.ID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                db.TableFields.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\TableFields.txt", Now)
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_SQLDataContext
            Dim Del = From d In db.TableFields _
                      Where ID.Contains(d.ID) _
                      Select d
            For Each d In Del
                db.TableFields.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\TableFields.txt", Now)
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 删除指定表下所有字段
    ''' </summary>
    ''' <param name="TableName"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal TableName As String) As Boolean
        Using db As New DB_SQLDataContext
            Dim Del = From d In db.TableFields _
                      Where d.TableName = TableName _
                      Select d
            For Each d In Del
                db.TableFields.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\TableFields.txt", Now)
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="TableName"></param>
    ''' <param name="FieldName"></param>
    ''' <param name="FieldNote"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal TableName As String, ByVal FieldName As String, ByVal FieldNote As String) As Integer
        Using db As New DB_SQLDataContext
            Dim mNewTableFields As New TableFields With {.TableName = TableName, .FieldName = FieldName, .FieldNote = FieldNote}
            db.TableFields.InsertOnSubmit(mNewTableFields)
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\TableFields.txt", Now)
                Return mNewTableFields.ID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="TableName"></param>
    ''' <param name="FieldName"></param>
    ''' <param name="FieldNote"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal TableName As String, ByVal FieldName As String, ByVal FieldNote As String) As Integer
        Using db As New DB_SQLDataContext
            Dim UpdateTableFields = (From c In db.TableFields _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateTableFields) Then
                With UpdateTableFields
                    .TableName = TableName
                    .FieldName = FieldName
                    .FieldNote = FieldNote
                End With

                Try
                    db.SubmitChanges()
                    IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\TableFields.txt", Now)
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="FieldNote"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal FieldNote As String) As Integer
        Using db As New DB_SQLDataContext
            Dim UpdateTableFields = (From c In db.TableFields _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateTableFields) Then
                With UpdateTableFields
                    .FieldNote = FieldNote
                End With

                Try
                    db.SubmitChanges()
                    IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\TableFields.txt", Now)
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
End Class
