﻿Imports System.Web

Public Class clsConfigs
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As Configs
        Using db As New DB_ConfigsDataContext
            Return (From c In db.Configs _
                    Where c.ID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取当前站点记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetSingle() As Configs
        Dim SiteUrl As String = LCase(HttpContext.Current.Request.ServerVariables("Http_Host"))
        Using db As New DB_ConfigsDataContext
            Return (From c In db.Configs _
                    Where c.WebURL = SiteUrl _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq() As IQueryable(Of Configs)
        Dim db As New DB_ConfigsDataContext
        Return From c In db.Configs _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_ConfigsDataContext
            Dim SitePath As String = HttpContext.Current.Server.MapPath("/Sites/Site")
            Dim DelID As Integer = 0
            Dim Del = (From d In db.Configs _
                      Where d.ID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                db.Configs.DeleteOnSubmit(Del)
                DelID = Del.ID
                Try
                    db.SubmitChanges()
                Catch ex As Exception
                    Return False
                End Try

                Try
                    IO.Directory.Delete(SitePath & DelID.ToString, True)
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_ConfigsDataContext
            Dim Del = From d In db.Configs _
                      Where ID.Contains(d.ID) _
                      Select d
            For Each d In Del
                db.Configs.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="WebName"></param>
    ''' <param name="WebURL"></param>
    ''' <param name="EndTime"></param>
    ''' <param name="UpType"></param>
    ''' <param name="SiteState"></param>
    ''' <param name="CreatTime"></param>
    ''' <param name="LogTime"></param>
    ''' <param name="ManagerDirectory"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal WebName As String, ByVal WebURL As String, ByVal EndTime As DateTime, ByVal UpType As String, ByVal SiteState As Boolean, ByVal CreatTime As DateTime, ByVal LogTime As Integer, ByVal ManagerDirectory As String, ByVal SiteKey As String, Optional ByVal OpenSecCache As Boolean = False, Optional ByVal CheckFile As Boolean = False, Optional ByVal UrlReWriteEx As String = "") As Integer
        Using db As New DB_ConfigsDataContext
            Dim SitePath As String = HttpContext.Current.Server.MapPath("/Sites/Site")
            Dim mNewConfigs As New Configs With {.WebName = WebName, .WebURL = WebURL, .EndTime = EndTime, .UpType = UpType, .SiteState = SiteState, .CreatTime = CreatTime, .LogTime = LogTime, .ManagerDirectory = ManagerDirectory, .ManagerGroup = 0, .SiteKey = SiteKey, .OpenTrace = False, .CheckFile = CheckFile, .SecCache = OpenSecCache, .URLFileEx = UrlReWriteEx}
            db.Configs.InsertOnSubmit(mNewConfigs)
            Try
                db.SubmitChanges()
            Catch ex As Exception
                Return 0
            End Try
            Try
                IO.Directory.CreateDirectory(SitePath & mNewConfigs.ID.ToString)
                Return mNewConfigs.ID
            Catch ex As Exception
                Return 0
            End Try

        End Using

    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="WebName"></param>
    ''' <param name="WebURL"></param>
    ''' <param name="EndTime"></param>
    ''' <param name="UpType"></param>
    ''' <param name="SiteState"></param>
    ''' <param name="CreatTime"></param>
    ''' <param name="LogTime"></param>
    ''' <param name="ManagerDirectory"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal WebName As String, ByVal WebURL As String, ByVal EndTime As DateTime, ByVal UpType As String, ByVal SiteState As Boolean, ByVal CreatTime As DateTime, ByVal LogTime As Integer, ByVal ManagerDirectory As String, ByVal OpenTrace As Integer, Optional ByVal OpenSecCache As Boolean = False, Optional ByVal ManagerGroupID As Integer = 0, Optional ByVal DefaultGroup As Integer = 0, Optional ByVal UrlReWriteEx As String = "") As Integer
        Using db As New DB_ConfigsDataContext
            Dim UpdateConfigs = (From c In db.Configs _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateConfigs) Then
                With UpdateConfigs
                    .WebName = WebName
                    .WebURL = WebURL
                    .EndTime = EndTime
                    .UpType = UpType
                    .SiteState = SiteState
                    .CreatTime = CreatTime
                    .LogTime = LogTime
                    .ManagerDirectory = ManagerDirectory
                    .OpenTrace = OpenTrace
                    .SecCache = OpenSecCache
                    .URLFileEx = UrlReWriteEx
                    If ManagerGroupID > 0 Then .ManagerGroup = ManagerGroupID
                    If DefaultGroup > 0 Then .DefaultGroup = DefaultGroup
                End With

                Try
                    db.SubmitChanges()
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
    ''' <summary>
    ''' 修改网站信息
    ''' </summary>
    ''' <param name="WebName"></param>
    ''' <param name="WebURL"></param>
    ''' <param name="UpType"></param>
    ''' <param name="LogTime"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal WebName As String, ByVal WebURL As String, ByVal UpType As String, ByVal LogTime As Integer, ByVal SiteKey As String, ByVal OpenTrace As Integer, ByVal CheckFile As Boolean, ByVal OpenSecCache As Boolean, Optional ByVal ManagerGroupID As Integer = 0, Optional ByVal DefaultGroup As Integer = 0, Optional ByVal URLRewriteEx As String = "") As Integer
        Using db As New DB_ConfigsDataContext
            Dim UpdateConfigs = (From c In db.Configs _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateConfigs) Then
                With UpdateConfigs
                    .WebName = WebName
                    .WebURL = WebURL
                    .UpType = UpType
                    .LogTime = LogTime
                    .SiteKey = SiteKey
                    .CheckFile = CheckFile
                    .SecCache = OpenSecCache
                    .OpenTrace = OpenTrace
                    If ManagerGroupID > 0 Then .ManagerGroup = ManagerGroupID
                    If DefaultGroup > 0 Then .DefaultGroup = DefaultGroup
                    .URLFileEx = URLRewriteEx
                End With

                Try
                    db.SubmitChanges()
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
    ''' <summary>
    ''' 更新网站管理组
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal ManagerGroupID As Integer) As Integer
        Using db As New DB_ConfigsDataContext
            Dim UpdateConfigs = (From c In db.Configs _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateConfigs) Then
                With UpdateConfigs
                   .ManagerGroup = ManagerGroupID
                End With

                Try
                    db.SubmitChanges()
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
    ''' <summary>
    ''' 修改网站默认模板组
    ''' </summary>
    ''' <param name="SiteID"></param>
    ''' <param name="GroupID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function ChangeDefaultTMP(ByVal SiteID As Integer, ByVal GroupID As Integer) As Boolean
        Using db As New DB_ConfigsDataContext
            Dim UpdateConfigs = (From c In db.Configs _
                                 Where c.ID = SiteID _
                                 Select c).FirstOrDefault
            UpdateConfigs.DefaultGroup = GroupID
            Try
                db.SubmitChanges()
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
End Class
