﻿Imports System.Web

Public Class clsManagerLog
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As ManagerLog
        Using db As New DB_ConfigsDataContext
            Return (From c In db.ManagerLog _
                    Where c.ID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq() As IQueryable(Of ManagerLog)
        Dim db As New DB_ConfigsDataContext
        Return From c In db.ManagerLog _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_ConfigsDataContext
            Dim Del = (From d In db.ManagerLog _
                      Where d.ID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                db.ManagerLog.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_ConfigsDataContext
            Dim Del = From d In db.ManagerLog _
                      Where ID.Contains(d.ID) _
                      Select d
            For Each d In Del
                db.ManagerLog.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="LogTime"></param>
    ''' <param name="UserName"></param>
    ''' <param name="LogAction"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal mSiteID As Integer, ByVal LogTime As DateTime, ByVal UserName As String, ByVal LogAction As String) As Integer
        Using db As New DB_ConfigsDataContext
            Dim mNewManagerLog As New ManagerLog With {.SiteID = mSiteID, .LogTime = LogTime, .UserName = UserName, .UserIP = HttpContext.Current.Request.ServerVariables("REMOTE_ADDR"), .LogAction = LogAction}
            db.ManagerLog.InsertOnSubmit(mNewManagerLog)
            Try
                db.SubmitChanges()
                Return mNewManagerLog.ID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="LogTime"></param>
    ''' <param name="UserName"></param>
    ''' <param name="LogAction"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal LogTime As DateTime, ByVal UserName As String, ByVal LogAction As String) As Integer
        Using db As New DB_ConfigsDataContext
            Dim UpdateManagerLog = (From c In db.ManagerLog _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateManagerLog) Then
                With UpdateManagerLog
                    .LogTime = LogTime
                    .UserName = UserName
                    .UserIP = HttpContext.Current.Request.ServerVariables("REMOTE_ADDR")
                    .LogAction = LogAction
                End With

                Try
                    db.SubmitChanges()
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
End Class
