﻿Public Class clsTagData
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As TagData
        Using db As New DB_TagDataContext
            Return (From c In db.TagData _
                    Where c.ID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 判断是否存在相同标签名
    ''' </summary>
    ''' <param name="TagName"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function IsHasTagName(ByVal TagName As String, ByVal SiteID As Integer) As Boolean
        Using db As New DB_TagDataContext
            Dim TagID = (From c In db.TagData _
                        Where c.TagName = TagName _
                        And c.SiteID = SiteID _
                        Select c.ID).FirstOrDefault
            If TagID > 0 Then
                Return True
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 判断是否存在相同标签名
    ''' </summary>
    ''' <param name="TagName"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function IsHasTagName(ByVal TagID As Integer, ByVal TagName As String, ByVal SiteID As Integer) As Boolean
        Using db As New DB_TagDataContext
            Dim mTagID = (From c In db.TagData _
                            Where c.TagName = TagName _
                            And c.SiteID = SiteID _
                            And c.ID <> TagID _
                            Select c.ID).FirstOrDefault
            If mTagID > 0 Then
                Return True
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq(ByVal SiteID As Integer) As IQueryable(Of TagData)
        Dim db As New DB_TagDataContext
        Dim TagQuery = From c In db.TagData _
                       Where c.SiteID = SiteID _
                       Order By c.ID _
                       Select c
        Return TagQuery
    End Function
    ''' <summary>
    ''' 获取分类下所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetClassLinq(ByVal ClassID As Integer) As IQueryable(Of TagData)
        Dim db As New DB_TagDataContext
        Return From c In db.TagData _
               Where c.ClassID = ClassID _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 获取分类下所有静态或动态标签
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq(ByVal ClassID As Integer, ByVal IsControl As Boolean) As IQueryable(Of TagData)
        Dim db As New DB_TagDataContext
        Return From c In db.TagData _
               Where c.ClassID = ClassID _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_TagDataContext
            Dim Del = (From d In db.TagData _
                      Where d.ID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                Dim mSiteID As Integer = Del.SiteID
                db.TagData.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Tag" & mSiteID.ToString & ".txt", Now)
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_TagDataContext
            Dim Del = From d In db.TagData _
                      Where ID.Contains(d.ID) _
                      Select d
            Dim mSiteID As Integer
            For Each d In Del
                mSiteID = d.SiteID
                db.TagData.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Tag" & mSiteID.ToString & ".txt", Now)
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 删除分类下多个实例
    ''' </summary>
    ''' <param name="ClassID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function DeleteClass(ByVal ClassID As Integer) As Boolean
        Using db As New DB_TagDataContext
            Dim Del = From d In db.TagData _
                      Where d.ClassID = ClassID _
                      Select d
            Dim mSiteID As Integer
            For Each d In Del
                mSiteID = d.SiteID
                db.TagData.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Tag" & mSiteID.ToString & ".txt", Now)
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="ClassID"></param>
    ''' <param name="TagName"></param>
    ''' <param name="TagContent"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal ClassID As Integer, ByVal TagName As String, ByVal TagContent As String, ByVal SiteID As Integer) As Integer
        Using db As New DB_TagDataContext
            Dim mNewTagData As New TagData With {.SiteID = SiteID, .ClassID = ClassID, .TagName = TagName, .TagContent = TagContent}
            db.TagData.InsertOnSubmit(mNewTagData)
            Try
                db.SubmitChanges()
                IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Tag" & SiteID.ToString & ".txt", Now)
                Return mNewTagData.ID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="ClassID"></param>
    ''' <param name="TagName"></param>
    ''' <param name="TagContent"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal ClassID As Integer, ByVal TagName As String, ByVal TagContent As String) As Integer
        Using db As New DB_TagDataContext
            Dim UpdateTagData = (From c In db.TagData _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateTagData) Then
                With UpdateTagData
                    .ClassID = ClassID
                    .TagName = TagName
                    .TagContent = TagContent
                End With

                Try
                    db.SubmitChanges()
                    IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Tag" & UpdateTagData.SiteID.ToString & ".txt", Now)
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
End Class
