﻿Public Class clsTagJscript
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As TagJscript
        Using db As New DB_TagDataContext
            Return (From c In db.TagJscript _
                    Where c.ID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq() As IQueryable(Of TagJscript)
        Dim db As New DB_TagDataContext
        Return From c In db.TagJscript _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_TagDataContext
            Dim Del = (From d In db.TagJscript _
                      Where d.ID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                db.TagJscript.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_TagDataContext
            Dim Del = From d In db.TagJscript _
                      Where ID.Contains(d.ID) _
                      Select d
            For Each d In Del
                db.TagJscript.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="JsContent"></param>
    ''' <param name="JsName"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal JsContent As String, ByVal JsName As String) As Integer
        Using db As New DB_TagDataContext
            Dim mNewTagJscript As New TagJscript With {.JsContent = JsContent, .JsName = JsName}
            db.TagJscript.InsertOnSubmit(mNewTagJscript)
            Try
                db.SubmitChanges()
                Return mNewTagJscript.ID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <param name="JsContent"></param>
    ''' <param name="JsName"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal JsContent As String, ByVal JsName As String) As Integer
        Using db As New DB_TagDataContext
            Dim UpdateTagJscript = (From c In db.TagJscript _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateTagJscript) Then
                With UpdateTagJscript
                    .JsContent = JsContent
                    .JsName = JsName

                End With

                Try
                    db.SubmitChanges()
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
End Class
