﻿Public Class clsTaskAccepter
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As TaskAccepter
        Using db As New DB_TaskDataContext
            Return (From c In db.TaskAccepter _
                    Where c.ID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq(ByVal SiteID As Integer) As IQueryable(Of TaskAccepter)
        Dim db As New DB_TaskDataContext
        Return From c In db.TaskAccepter _
               Where c.SiteID = SiteID _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_TaskDataContext
            Dim Del = (From d In db.TaskAccepter _
                      Where d.ID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                db.TaskAccepter.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_TaskDataContext
            Dim Del = From d In db.TaskAccepter _
                      Where ID.Contains(d.ID) _
                      Select d
            For Each d In Del
                db.TaskAccepter.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="TaskID"></param>
    ''' <param name="AccepterID"></param>
    ''' <param name="BidPrice"></param>
    ''' <param name="BidNote"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal TaskID As Integer, ByVal AccepterID As Integer, ByVal BidPrice As Double, ByVal BidNote As String, ByVal SiteID As Integer) As Integer
        Using db As New DB_TaskDataContext
            Dim mNewTaskAccepter As New TaskAccepter With {.TaskID = TaskID, .AccepterID = AccepterID, .BidPrice = BidPrice, .BidNote = BidNote, .SiteID = SiteID}
            db.TaskAccepter.InsertOnSubmit(mNewTaskAccepter)
            Try
                db.SubmitChanges()
                Return mNewTaskAccepter.ID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="TaskID"></param>
    ''' <param name="AccepterID"></param>
    ''' <param name="BidPrice"></param>
    ''' <param name="BidNote"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal TaskID As Integer, ByVal AccepterID As Integer, ByVal BidPrice As Double, ByVal BidNote As String) As Integer
        Using db As New DB_TaskDataContext
            Dim UpdateTaskAccepter = (From c In db.TaskAccepter _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateTaskAccepter) Then
                With UpdateTaskAccepter
                    .TaskID = TaskID
                    .AccepterID = AccepterID
                    .BidPrice = BidPrice
                    .BidNote = BidNote

                End With

                Try
                    db.SubmitChanges()
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
End Class
