﻿Public Class clsTaskTemplate
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As TaskTemplate
        Using db As New DB_TaskDataContext
            Return (From c In db.TaskTemplate _
                    Where c.ID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq(ByVal mSiteID As Integer) As IQueryable(Of TaskTemplate)
        Dim db As New DB_TaskDataContext
        Return From c In db.TaskTemplate _
               Where c.SiteID = mSiteID _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_TaskDataContext
            Dim Del = (From d In db.TaskTemplate _
                      Where d.ID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                db.TaskTemplate.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_TaskDataContext
            Dim Del = From d In db.TaskTemplate _
                      Where ID.Contains(d.ID) _
                      Select d
            For Each d In Del
                db.TaskTemplate.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="TaskClassID"></param>
    ''' <param name="AddUserID"></param>
    ''' <param name="TaskType"></param>
    ''' <param name="AccepeterID"></param>
    ''' <param name="AccepeterGroupID"></param>
    ''' <param name="TaskLimit"></param>
    ''' <param name="ValidLimit"></param>
    ''' <param name="AppraisePoint"></param>
    ''' <param name="ReleaseInterval"></param>
    ''' <param name="ReleaseType"></param>
    ''' <param name="AddTime"></param>
    ''' <param name="TaskPrice"></param>
    ''' <param name="TaskName"></param>
    ''' <param name="TaskNote"></param>
    ''' <param name="AppraiseNote"></param>
    ''' <param name="Attachment"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal TaskClassID As Integer, ByVal AddUserID As Integer, ByVal TaskType As Integer, ByVal AccepeterID As Integer, ByVal AccepeterGroupID As Integer, ByVal TaskLimit As Integer, ByVal ValidLimit As Integer, ByVal AppraisePoint As Integer, ByVal ReleaseInterval As Integer, ByVal ReleaseType As Integer, ByVal AddTime As DateTime, ByVal TaskPrice As Double, ByVal TaskName As String, ByVal TaskNote As String, ByVal AppraiseNote As String, ByVal Attachment As String, ByVal mSiteID As Integer) As Integer
        Using db As New DB_TaskDataContext
            Dim mNewTaskTemplate As New TaskTemplate With {.TaskClassID = TaskClassID, .AddUserID = AddUserID, .TaskType = TaskType, .AccepeterID = AccepeterID, .AccepeterGroupID = AccepeterGroupID, .TaskLimit = TaskLimit, .ValidLimit = ValidLimit, .AppraisePoint = AppraisePoint, .ReleaseInterval = ReleaseInterval, .ReleaseType = ReleaseType, .AddTime = AddTime, .TaskPrice = TaskPrice, .TaskName = TaskName, .TaskNote = TaskNote, .AppraiseNote = AppraiseNote, .Attachment = Attachment, .SiteID = mSiteID}
            db.TaskTemplate.InsertOnSubmit(mNewTaskTemplate)
            Try
                db.SubmitChanges()
                Return mNewTaskTemplate.ID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="TaskClassID"></param>
    ''' <param name="AddUserID"></param>
    ''' <param name="TaskType"></param>
    ''' <param name="AccepeterID"></param>
    ''' <param name="AccepeterGroupID"></param>
    ''' <param name="TaskLimit"></param>
    ''' <param name="ValidLimit"></param>
    ''' <param name="AppraisePoint"></param>
    ''' <param name="ReleaseInterval"></param>
    ''' <param name="ReleaseType"></param>
    ''' <param name="AddTime"></param>
    ''' <param name="TaskPrice"></param>
    ''' <param name="TaskName"></param>
    ''' <param name="TaskNote"></param>
    ''' <param name="AppraiseNote"></param>
    ''' <param name="Attachment"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal TaskClassID As Integer, ByVal AddUserID As Integer, ByVal TaskType As Integer, ByVal AccepeterID As Integer, ByVal AccepeterGroupID As Integer, ByVal TaskLimit As Integer, ByVal ValidLimit As Integer, ByVal AppraisePoint As Integer, ByVal ReleaseInterval As Integer, ByVal ReleaseType As Integer, ByVal AddTime As DateTime, ByVal TaskPrice As Double, ByVal TaskName As String, ByVal TaskNote As String, ByVal AppraiseNote As String, ByVal Attachment As String) As Integer
        Using db As New DB_TaskDataContext
            Dim UpdateTaskTemplate = (From c In db.TaskTemplate _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateTaskTemplate) Then
                With UpdateTaskTemplate
                    .TaskClassID = TaskClassID
                    .AddUserID = AddUserID
                    .TaskType = TaskType
                    .AccepeterID = AccepeterID
                    .AccepeterGroupID = AccepeterGroupID
                    .TaskLimit = TaskLimit
                    .ValidLimit = ValidLimit
                    .AppraisePoint = AppraisePoint
                    .ReleaseInterval = ReleaseInterval
                    .ReleaseType = ReleaseType
                    .AddTime = AddTime
                    .TaskPrice = TaskPrice
                    .TaskName = TaskName
                    .TaskNote = TaskNote
                    .AppraiseNote = AppraiseNote
                    .Attachment = Attachment

                End With

                Try
                    db.SubmitChanges()
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
End Class
