﻿Imports System.Web
Public Class clsTaskUserGroup
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As TaskUserGroup
        Using db As New DB_TaskDataContext
            Return (From c In db.TaskUserGroup _
                    Where c.ClassID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq(ByVal mSiteID As Integer) As IQueryable(Of TaskUserGroup)
        Dim db As New DB_TaskDataContext
        Return From c In db.TaskUserGroup _
               Where c.SiteID = mSiteID _
               Order By c.ClassLev, c.OrderID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_TaskDataContext
            Dim Del = (From d In db.TaskUserGroup _
                      Where d.ClassID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                If Del.ParentID > 0 Then
                    Dim pClass = (From c In db.TaskUserGroup _
                                 Where c.ClassID = Del.ParentID _
                                 Select c).FirstOrDefault
                    If Not IsNothing(pClass) Then
                        pClass.ChildCount = pClass.ChildCount - 1
                        Try
                            db.SubmitChanges()
                        Catch ex As Exception
                            Return False
                        End Try
                    End If
                End If
                db.TaskUserGroup.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    ' IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\ArticleClass.txt", Now)
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_TaskDataContext
            Dim Del = From d In db.TaskUserGroup _
                      Where ID.Contains(d.ClassID) _
                      Select d
            For Each d In Del
                db.TaskUserGroup.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                'IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\ArticleClass.txt", Now)
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="ParentID"></param>
    ''' <param name="ClassLev"></param>
    ''' <param name="ChildCount"></param>
    ''' <param name="OrderID"></param>
    ''' <param name="ClassName"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal mSiteID As Integer, ByVal ParentID As Integer, ByVal ClassLev As Integer, ByVal ChildCount As Integer, ByVal OrderID As Integer, ByVal ClassName As String) As Integer
        Using db As New DB_TaskDataContext
            Dim mTopID As Integer = 0
            Dim pClass = (From p In db.TaskUserGroup _
                         Where p.ClassID = ParentID _
                         Select p).FirstOrDefault
            If pClass IsNot Nothing Then
                pClass.ChildCount += 1
                If pClass.TopID > 0 Then
                    mTopID = pClass.TopID
                Else
                    mTopID = pClass.ClassID
                End If
                Try
                    db.SubmitChanges()
                Catch ex As Exception
                    Return 0
                End Try
            End If
            Dim mNewArticleClass As New TaskUserGroup With {.SiteID = mSiteID, .TopID = mTopID, .ParentID = ParentID, .ClassLev = ClassLev, .ChildCount = ChildCount, .OrderID = OrderID, .ClassName = ClassName}
            db.TaskUserGroup.InsertOnSubmit(mNewArticleClass)
            Try
                db.SubmitChanges()
                'IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\ArticleClass.txt", Now)
                Return mNewArticleClass.ClassID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function

    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="ClassID"></param>
    ''' <param name="ClassName"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ClassID As Integer, ByVal ClassName As String) As Integer
        Using db As New DB_TaskDataContext
            Dim UpdateArticleClass = (From c In db.TaskUserGroup _
                                       Where c.ClassID = ClassID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateArticleClass) Then
                With UpdateArticleClass
                    .ClassName = ClassName
                End With
                Try
                    db.SubmitChanges()
                    'IO.File.WriteAllText(Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\ArticleClass.txt", Now)
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function

    ''' <summary>
    ''' 排序节点向上向下移动
    ''' </summary>
    ''' <param name="ParentClassID">父级序号</param>
    ''' <param name="ThisClassID">栏目序号</param>
    ''' <param name="IsUp">是否向上移动</param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function ChangeOrder(ByVal mSiteID As Integer, ByVal ParentClassID As Integer, ByVal ThisClassID As Integer, ByVal IsUp As Boolean)
        Using db As New DB_TaskDataContext
            Dim MeOrderID As Integer = 1
            Dim mTmpOrderID As Integer = 1
            Dim rtnValue As Boolean = True
            Dim mThisClass = (From c In db.TaskUserGroup _
                             Where c.ClassID = ThisClassID _
                             Select c).FirstOrDefault
            If mThisClass IsNot Nothing Then
                mTmpOrderID = mThisClass.OrderID
                If IsUp Then
                    If mThisClass.OrderID > 1 Then
                        MeOrderID = mThisClass.OrderID - 1
                    End If
                Else
                    MeOrderID = mThisClass.OrderID + 1
                End If
                mThisClass.OrderID = MeOrderID
                Dim mThatClass = (From c In db.TaskUserGroup _
                                  Where c.OrderID = MeOrderID _
                                  And c.ParentID = ParentClassID _
                                  Select c).FirstOrDefault
                If mThatClass IsNot Nothing Then
                    mThatClass.OrderID = mTmpOrderID
                    Try
                        db.SubmitChanges()
                    Catch ex As Exception
                        Return False
                    End Try
                End If
            End If
            Return True
        End Using
    End Function
End Class

