﻿Imports System.Web
Public Class clsTemplateClass
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As TemplateClass
        Using db As New DB_TemplateDataContext
            Return (From c In db.TemplateClass _
                    Where c.ID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq(ByVal SiteID As Integer) As IQueryable(Of TemplateClass)
        Dim db As New DB_TemplateDataContext
        Return From c In db.TemplateClass _
               Where c.SiteID = SiteID _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_TemplateDataContext
            Dim Del = (From d In db.TemplateClass _
                      Where d.ID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                Dim mTemplateList As New clsTemplateList
                If mTemplateList.DeleteClass(Del.ID) Then
                    db.TemplateClass.DeleteOnSubmit(Del)
                    Dim mTemplatePath As String = HttpContext.Current.Server.MapPath("/Sites/Site" & Del.SiteID.ToString & "/Template" & Del.ID.ToString)
                    IO.Directory.Delete(mTemplatePath, True)
                Else
                    Return False
                End If
                Try
                    db.SubmitChanges()
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_TemplateDataContext
            Dim Del = From d In db.TemplateClass _
                      Where ID.Contains(d.ID) _
                      Select d
            Dim mTmpPath As String = ""
            For Each d In Del
                db.TemplateClass.DeleteOnSubmit(d)
                Dim mTemplatePath As String = HttpContext.Current.Server.MapPath("/Sites/Site" & d.SiteID.ToString & "/Template" & d.ID.ToString)
                IO.Directory.Delete(mTemplatePath, True)
            Next
            Try
                db.SubmitChanges()
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="ClassName"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal SiteID As Integer, ByVal ClassName As String) As Integer
        Dim mNewTemplateClass As New TemplateClass With {.SiteID = SiteID, .ClassName = ClassName}
        Using db As New DB_TemplateDataContext
            db.TemplateClass.InsertOnSubmit(mNewTemplateClass)
            Try
                db.SubmitChanges()
                Dim mTemplatePath As String = HttpContext.Current.Server.MapPath("/Sites/Site" & SiteID.ToString & "/Template" & mNewTemplateClass.ID.ToString)
                IO.Directory.CreateDirectory(mTemplatePath)
                Return mNewTemplateClass.ID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="ClassName"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal ClassName As String) As Integer
        Using db As New DB_TemplateDataContext
            Dim UpdateTemplateClass = (From c In db.TemplateClass _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateTemplateClass) Then
                With UpdateTemplateClass
                    .ClassName = ClassName
                End With

                Try
                    db.SubmitChanges()
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
End Class
