﻿Public Class clsTemplateList
    ''' <summary>
    ''' 根据ID获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As TemplateList
        Using db As New DB_TemplateDataContext
            Return (From c In db.TemplateList _
                    Where c.ID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function

    ''' <summary>
    ''' 根据文件名获取单条记录
    ''' </summary>
    ''' <param name="FileName"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal FileName As String) As TemplateList
        Using db As New DB_TemplateDataContext
            Return (From c In db.TemplateList _
                    Where c.FileName = FileName _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq(ByVal SiteID As Integer) As IQueryable(Of TemplateList)
        Dim db As New DB_TemplateDataContext
        Dim mClasses = (From c In clsTemplateClass.GetLinq(SiteID) _
                       Select c.ID).ToArray
        Return From c In db.TemplateList _
               Where mClasses.Contains(c.ClassID) _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 获取指定模板组所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetClassLinq(ByVal ClassID As Integer) As IQueryable(Of TemplateList)
        Dim db As New DB_TemplateDataContext
        Return From c In db.TemplateList _
               Where c.ClassID = ClassID _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 获取指定模板组下是否有设为当前首页的模板
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function HasDefault(ByVal ClassID As Integer) As Boolean
        Using db As New DB_TemplateDataContext
            Return (From c In db.TemplateList _
                    Where c.ClassID = ClassID _
                    And c.IsDefault = True _
                    Order By c.ID _
                    Select c.IsDefault).FirstOrDefault
        End Using

    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_TemplateDataContext
            Dim Del = (From d In db.TemplateList _
                      Where d.ID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                Dim mURL As New clsTemplateURL
                mURL.DeleteTmp(Del.ID)
                db.TemplateList.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除分类下所有模板
    ''' </summary>
    ''' <param name="ClassID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function DeleteClass(ByVal ClassID As Integer) As Boolean
        Using db As New DB_TemplateDataContext
            Dim Dels = From d In db.TemplateList _
                      Where d.ClassID = ClassID _
                      Select d
            Dim DelID() = (From d In db.TemplateList _
                          Where d.ClassID = ClassID _
                          Select d.ID).ToArray
            For Each d In Dels
                db.TemplateList.DeleteOnSubmit(d)
            Next
            Dim mURL As New clsTemplateURL
            mURL.DeleteTmp(DelID)
            Try
                db.SubmitChanges()
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_TemplateDataContext
            Dim Del = From d In db.TemplateList _
                      Where ID.Contains(d.ID) _
                      Select d
            For Each d In Del
                db.TemplateList.DeleteOnSubmit(d)
            Next
            Dim mURL As New clsTemplateURL
            mURL.DeleteTmp(ID)
            Try
                db.SubmitChanges()
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="ClassID"></param>
    ''' <param name="TmpContent"></param>
    ''' <param name="IsDefault"></param>
    ''' <param name="TmpName"></param>
    ''' <param name="FileName"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal ClassID As Integer, ByVal TmpContent As String, ByVal IsDefault As Boolean, ByVal TmpName As String, ByVal FileName As String) As Integer
        Using db As New DB_TemplateDataContext
            Dim mNewTemplateList As New TemplateList With {.ClassID = ClassID, .TmpContent = TmpContent, .IsDefault = IsDefault, .TmpName = TmpName, .FileName = FileName}
            db.TemplateList.InsertOnSubmit(mNewTemplateList)
            Try
                db.SubmitChanges()
                Return mNewTemplateList.ID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="ClassID"></param>
    ''' <param name="TmpContent"></param>
    ''' <param name="TmpName"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal ClassID As Integer, ByVal TmpContent As String, ByVal TmpName As String) As Integer
        Using db As New DB_TemplateDataContext
            Dim UpdateTemplateList = (From c In db.TemplateList _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateTemplateList) Then
                With UpdateTemplateList
                    .ClassID = ClassID
                    .TmpContent = TmpContent
                    .TmpName = TmpName
                End With

                Try
                    db.SubmitChanges()
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
    ''' <summary>
    ''' 修改默认项
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal SiteID As Integer) As Integer
        Dim returnValue As Integer = 0
        Using db As New DB_TemplateDataContext
            Dim UpdateTemplateList = (From c In db.TemplateList _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateTemplateList) Then
                If Not UpdateTemplateList.IsDefault Then
                    Dim mOldTmp = (From c In db.TemplateList _
                                    Where c.IsDefault _
                                    Select c).FirstOrDefault
                    If mOldTmp IsNot Nothing Then
                        mOldTmp.IsDefault = False
                    End If
                    returnValue = 1
                Else
                    returnValue = 2
                End If
                With UpdateTemplateList
                    .IsDefault = Not .IsDefault
                End With
                db.SubmitChanges()
            Else
                returnValue = 0
            End If
        End Using
        Return returnValue
    End Function
End Class
