﻿Imports System.Web

Public Class clsTemplateURL
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As TemplateURL
        Using db As New DB_TemplateDataContext
            Return (From c In db.TemplateURL _
                    Where c.ID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="RealUrl"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal RealUrl As String) As TemplateURL
        Using db As New DB_TemplateDataContext
            Return (From c In db.TemplateURL _
                    Where c.SendTo = RealUrl _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq(ByVal SiteID As Integer) As IQueryable(Of TemplateURL)
        Dim db As New DB_TemplateDataContext
        Return From c In db.TemplateURL _
               Where c.SiteID = SiteID _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_TemplateDataContext
            Dim Del = (From d In db.TemplateURL _
                      Where d.ID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                Dim mSiteID As Integer = Del.SiteID
                db.TemplateURL.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    HttpContext.Current.Cache.Remove("Rules" & mSiteID.ToString)
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除某个模板的所有映射
    ''' </summary>
    ''' <param name="TmpID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function DeleteTmp(ByVal TmpID As Integer) As Boolean
        Using db As New DB_TemplateDataContext
            Dim Del = From d In db.TemplateURL _
                      Where d.TmpID = TmpID _
                      Select d
            Dim mSiteID As Integer
            For Each d In Del
                mSiteID = d.SiteID
                db.TemplateURL.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                HttpContext.Current.Cache.Remove("Rules" & mSiteID.ToString)
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 删除某几个模板的所有映射
    ''' </summary>
    ''' <param name="TmpID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function DeleteTmp(ByVal TmpID() As Integer) As Boolean
        Using db As New DB_TemplateDataContext
            Dim Del = From d In db.TemplateURL _
                      Where TmpID.Contains(d.TmpID) _
                      Select d
            Dim mSiteID As Integer
            For Each d In Del
                mSiteID = d.SiteID
                db.TemplateURL.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                HttpContext.Current.Cache.Remove("Rules" & mSiteID.ToString)
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_TemplateDataContext
            Dim Del = From d In db.TemplateURL _
                      Where ID.Contains(d.ID) _
                      Select d
            Dim mSiteID As Integer
            For Each d In Del
                mSiteID = d.SiteID
                db.TemplateURL.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                HttpContext.Current.Cache.Remove("Rules" & mSiteID.ToString)
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="TmpID"></param>
    ''' <param name="LookFor"></param>
    ''' <param name="SendTo"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal TmpID As Integer, ByVal LookFor As String, ByVal SendTo As String, ByVal SiteID As Integer, ByVal WriteTime As Date) As Integer
        Using db As New DB_TemplateDataContext
            Dim mNewTemplateURL As New TemplateURL With {.SiteID = SiteID, .TmpID = TmpID, .LookFor = LookFor, .SendTo = SendTo, .LastWriteTime = WriteTime}
            db.TemplateURL.InsertOnSubmit(mNewTemplateURL)
            Try
                db.SubmitChanges()
                HttpContext.Current.Cache.Remove("Rules" & SiteID.ToString)
                Return mNewTemplateURL.ID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="TmpID"></param>
    ''' <param name="LookFor"></param>
    ''' <param name="SendTo"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal TmpID As Integer, ByVal LookFor As String, ByVal SendTo As String, ByVal WriteTime As Date) As Integer
        Using db As New DB_TemplateDataContext
            Dim UpdateTemplateURL = (From c In db.TemplateURL _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateTemplateURL) Then
                With UpdateTemplateURL
                    .TmpID = TmpID
                    .LookFor = LookFor
                    .SendTo = SendTo
                    .LastWriteTime = WriteTime
                End With

                Try
                    db.SubmitChanges()
                    HttpContext.Current.Cache.Remove("Rules" & UpdateTemplateURL.SiteID.ToString)
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
    Public Function DeleteDefault(ByVal DefaultFileName As String) As Boolean
        
        If DefaultFileName IsNot Nothing AndAlso DefaultFileName.Length > 0 Then

            Dim db As New DB_Template.DB_TemplateDataContext
            Dim mDefault = From c In db.TemplateURL _
                            Where c.LookFor = "~/" & DefaultFileName _
                            Or c.LookFor = "~/" _
                            Select c
            Dim mSiteID As Integer
            For Each d In mDefault
                mSiteID = d.SiteID
                db.TemplateURL.DeleteOnSubmit(d)
            Next
            HttpContext.Current.Cache.Remove("Rules" & mSiteID.ToString)
            db.SubmitChanges()
            Return True '1
        Else
            Return False '3
        End If
    End Function
End Class
