﻿Public Class clsUserGroup
    ''' <summary>
    ''' 查询当前站点下所有用户组
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq(ByVal mSiteID As Integer) As IQueryable(Of UserGroup)
        Dim db As New DB_UserDataContext
        Return From g In db.UserGroup _
               Where g.SiteID = mSiteID _
               Order By g.ID Descending _
               Select g
    End Function
    ''' <summary>
    ''' 读取一个用户组信息
    ''' </summary>
    ''' <param name="ID">用户组ID</param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer, ByVal SiteID As Integer) As UserGroup
        Using db As New DB_UserDataContext
            Return (From g In db.UserGroup _
                    Where g.SiteID = SiteID _
                    And g.ID = ID _
                    Order By g.ID _
                    Select g).FirstOrDefault()
        End Using
    End Function
    ''' <summary>
    ''' 修改用户组
    ''' </summary>
    ''' <param name="mGroupID">用户组ID</param>
    ''' <param name="mGroupName">用户组名称</param>
    ''' <param name="mGroupIntro">简介</param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal mGroupID As Integer, ByVal mGroupName As String, ByVal mGroupIntro As String, ByVal SiteID As Integer) As Integer

        Using db As New DB_UserDataContext
            Dim FindUserGroup = (From g In db.UserGroup _
                                 Where g.ID = mGroupID _
                                 And g.SiteID = SiteID _
                                 Order By g.ID _
                                 Select g).FirstOrDefault
            If Not IsNothing(FindUserGroup) Then
                With FindUserGroup
                    .GroupIntro = mGroupIntro
                    .GroupName = mGroupName
                End With
            End If
            Try
                db.SubmitChanges()
                Return 1
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加新用户组
    ''' </summary>
    ''' <param name="mGroupName">用户组名称</param>
    ''' <param name="mGroupIntro">简介</param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal mGroupName As String, ByVal mGroupIntro As String, ByVal SiteID As Integer) As Integer
        Using db As New DB_UserDataContext
            Dim mNewUserGroup As New UserGroup With {.SiteID = SiteID, _
                                                     .GroupName = mGroupName, _
                                                     .GroupIntro = mGroupIntro}
            db.UserGroup.InsertOnSubmit(mNewUserGroup)
            Try
                db.SubmitChanges()
                Return mNewUserGroup.ID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 删除用户组
    ''' </summary>
    ''' <param name="ID">用户组ID</param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer, ByVal SiteID As Integer) As Boolean
        Using db As New DB_UserDataContext
            Dim DelUserGroup = (From g In db.UserGroup _
                               Where g.ID = ID _
                               And g.SiteID = SiteID _
                               Order By g.ID _
                               Select g).FirstOrDefault
            If Not IsNothing(DelUserGroup) Then
                db.UserGroup.DeleteOnSubmit(DelUserGroup)
                Try
                    db.SubmitChanges()
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除几个用户组
    ''' </summary>
    ''' <param name="ID">用户组ID数组</param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer, ByVal SiteID As Integer) As Boolean
        If Not IsNothing(ID) Then
            Using db As New DB_UserDataContext
                Dim DelGroups = From g In db.UserGroup _
                                Where g.SiteID = SiteID _
                                And ID.Contains(g.ID) _
                                Order By g.ID _
                                Select g
                For Each d In DelGroups
                    db.UserGroup.DeleteOnSubmit(d)
                Next
                Try
                    db.SubmitChanges()
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            End Using
        Else
            Return False
        End If

    End Function
End Class
