﻿Public Class clsXrenUser
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As XrenUser
        Using db As New DB_UserDataContext
            Return (From c In db.XrenUser _
                    Where c.ID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal UserName As String, ByVal MD5PassWord As String) As XrenUser
        Using db As New DB_UserDataContext
            Return (From c In db.XrenUser _
                    Where c.UserName = UserName _
                    And c.PassWord = MD5PassWord _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal UserName As String, ByVal MD5PassWord As String, ByVal CheckManager As Boolean, ByVal SiteID As Integer) As XrenUser
        Using db As New DB_UserDataContext
            Return (From c In db.XrenUser _
                    Where c.UserName = UserName _
                    And c.PassWord = MD5PassWord _
                    And c.IsManager = CheckManager _
                    And c.SiteID = SiteID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq(ByVal SiteID As Integer) As IQueryable(Of XrenUser)
        Dim db As New DB_UserDataContext
        Return From c In db.XrenUser _
               Where c.SiteID = SiteID _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_UserDataContext
            Dim Del = (From d In db.XrenUser _
                      Where d.ID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                db.XrenUser.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_UserDataContext
            Dim Del = From d In db.XrenUser _
                      Where ID.Contains(d.ID) _
                      Select d
            For Each d In Del
                db.XrenUser.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="GroupID"></param>
    ''' <param name="Point"></param>
    ''' <param name="LoginTimes"></param>
    ''' <param name="SignInTimes"></param>
    ''' <param name="LastLoginTime"></param>
    ''' <param name="SignInTime"></param>
    ''' <param name="IsManager"></param>
    ''' <param name="Sex"></param>
    ''' <param name="Locked"></param>
    ''' <param name="IsVerification"></param>
    ''' <param name="UserName"></param>
    ''' <param name="PassWord"></param>
    ''' <param name="Email"></param>
    ''' <param name="HeadPhoto"></param>
    ''' <param name="Question"></param>
    ''' <param name="Answer"></param>
    ''' <param name="UserSignature"></param>
    ''' <param name="UserCardID"></param>
    ''' <param name="CellPhone"></param>
    ''' <param name="LastLoginIP"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal GroupID As Integer, ByVal Point As Integer, ByVal LoginTimes As Integer, ByVal SignInTimes As Integer, ByVal LastLoginTime As DateTime, ByVal SignInTime As DateTime, ByVal IsManager As Boolean, ByVal Sex As Boolean, ByVal Locked As Boolean, ByVal IsVerification As Boolean, ByVal UserName As String, ByVal PassWord As String, ByVal Email As String, ByVal HeadPhoto As String, ByVal Question As String, ByVal Answer As String, ByVal UserSignature As String, ByVal UserCardID As String, ByVal CellPhone As String, ByVal LastLoginIP As String, ByVal SiteID As Integer) As Integer
        Using db As New DB_UserDataContext
            Dim mNewXrenUser As New XrenUser With {.SiteID = SiteID, .GroupID = GroupID, .Point = Point, .LoginTimes = LoginTimes, .SignInTimes = SignInTimes, .LastLoginTime = LastLoginTime, .SignInTime = SignInTime, .IsManager = IsManager, .Sex = Sex, .Locked = Locked, .IsVerification = IsVerification, .UserName = UserName, .PassWord = PassWord, .Email = Email, .HeadPhoto = HeadPhoto, .Question = Question, .Answer = Answer, .UserSignature = UserSignature, .UserCardID = UserCardID, .CellPhone = CellPhone, .LastLoginIP = LastLoginIP}
            db.XrenUser.InsertOnSubmit(mNewXrenUser)
            Try
                db.SubmitChanges()
                Return mNewXrenUser.ID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="GroupID"></param>
    ''' <param name="Point"></param>
    ''' <param name="LoginTimes"></param>
    ''' <param name="SignInTimes"></param>
    ''' <param name="LastLoginTime"></param>
    ''' <param name="SignInTime"></param>
    ''' <param name="IsManager"></param>
    ''' <param name="Sex"></param>
    ''' <param name="Locked"></param>
    ''' <param name="IsVerification"></param>
    ''' <param name="UserName"></param>
    ''' <param name="PassWord"></param>
    ''' <param name="Email"></param>
    ''' <param name="HeadPhoto"></param>
    ''' <param name="Question"></param>
    ''' <param name="Answer"></param>
    ''' <param name="UserSignature"></param>
    ''' <param name="UserCardID"></param>
    ''' <param name="CellPhone"></param>
    ''' <param name="LastLoginIP"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal GroupID As Integer, ByVal Point As Integer, ByVal LoginTimes As Integer, ByVal SignInTimes As Integer, ByVal LastLoginTime As DateTime, ByVal SignInTime As DateTime, ByVal IsManager As Boolean, ByVal Sex As Boolean, ByVal Locked As Boolean, ByVal IsVerification As Boolean, ByVal UserName As String, ByVal PassWord As String, ByVal Email As String, ByVal HeadPhoto As String, ByVal Question As String, ByVal Answer As String, ByVal UserSignature As String, ByVal UserCardID As String, ByVal CellPhone As String, ByVal LastLoginIP As String) As Integer
        Using db As New DB_UserDataContext
            Dim UpdateXrenUser = (From c In db.XrenUser _
                                  Where c.ID = ID _
                                  Select c).FirstOrDefault
            If Not IsNothing(UpdateXrenUser) Then
                With UpdateXrenUser
                    .GroupID = GroupID
                    .Point = Point
                    .LoginTimes = LoginTimes
                    .SignInTimes = SignInTimes
                    .LastLoginTime = LastLoginTime
                    .SignInTime = SignInTime
                    .IsManager = IsManager
                    .Sex = Sex
                    .Locked = Locked
                    .IsVerification = IsVerification
                    .UserName = UserName
                    If PassWord.Length > 0 Then .PassWord = PassWord
                    .Email = Email
                    .HeadPhoto = HeadPhoto
                    .Question = Question
                    If Answer.Length > 0 Then .Answer = Answer
                    .UserSignature = UserSignature
                    .UserCardID = UserCardID
                    .CellPhone = CellPhone
                    .LastLoginIP = LastLoginIP

                End With

                Try
                    db.SubmitChanges()
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
    ''' <summary>
    ''' 修改密码
    ''' </summary>
    ''' <param name="UserID"></param>
    ''' <param name="NewMD5PassWord"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function ChangePassWord(ByVal UserID As Integer, ByVal NewMD5PassWord As String) As Boolean
        Using db As New DB_UserDataContext
            Dim CUser = (From u In db.XrenUser _
                         Where u.ID = UserID _
                         Select u).FirstOrDefault
            If Not IsNothing(CUser) Then
                CUser.PassWord = NewMD5PassWord
                Try
                    db.SubmitChanges()
                    Return True
                Catch ex As Exception
                    Return False
                End Try

            End If
        End Using
    End Function
End Class
