﻿Public Class clsVote_Answer
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As Vote_Answer
        Using db As New DB_VoteDataContext
            Return (From c In db.Vote_Answer _
                    Where c.ID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq() As IQueryable(Of Vote_Answer)
        Dim db As New DB_VoteDataContext
        Return From c In db.Vote_Answer _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_VoteDataContext
            Dim Del = (From d In db.Vote_Answer _
                      Where d.ID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                db.Vote_Answer.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_VoteDataContext
            Dim Del = From d In db.Vote_Answer _
                      Where ID.Contains(d.ID) _
                      Select d
            For Each d In Del
                db.Vote_Answer.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="SubID"></param>
    ''' <param name="UserID"></param>
    ''' <param name="SubmitTime"></param>
    ''' <param name="Integral"></param>
    ''' <param name="Addtime"></param>
    ''' <param name="IsChecked"></param>
    ''' <param name="UserName"></param>
    ''' <param name="UserIP"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal SubID As Integer, ByVal UserID As Integer, ByVal SubmitTime As Integer, ByVal Integral As Integer, ByVal Addtime As DateTime, ByVal IsChecked As Boolean, ByVal UserName As String, ByVal UserIP As String) As Integer
        Using db As New DB_VoteDataContext
            Dim mNewVote_Answer As New Vote_Answer With {.SubID = SubID, .UserID = UserID, .SubmitTime = SubmitTime, .Integral = Integral, .Addtime = Addtime, .IsChecked = IsChecked, .UserName = UserName, .UserIP = UserIP}
            db.Vote_Answer.InsertOnSubmit(mNewVote_Answer)
            Try
                db.SubmitChanges()
                Return mNewVote_Answer.ID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function ChangerChecked(ByVal ID As Integer) As Integer
        Using db As New DB_VoteDataContext
            Dim UpdateVote_Answer = (From c In db.Vote_Answer _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateVote_Answer) Then
                With UpdateVote_Answer
                    .IsChecked = Not .IsChecked
                End With

                Try
                    db.SubmitChanges()
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
End Class
