﻿Public Class clsVote_Detailed
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As Vote_Detailed
        Using db As New DB_VoteDataContext
            Return (From c In db.Vote_Detailed _
                    Where c.ID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq() As IQueryable(Of Vote_Detailed)
        Dim db As New DB_VoteDataContext
        Return From c In db.Vote_Detailed _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_VoteDataContext
            Dim Del = (From d In db.Vote_Detailed _
                      Where d.ID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                db.Vote_Detailed.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="AnswerID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function DeleteByAnswerID(ByVal AnswerID As Integer) As Boolean
        Using db As New DB_VoteDataContext
            Dim Del = From d In db.Vote_Detailed _
                      Where d.AnsID = AnswerID _
                      Select d
            For Each d In Del
                db.Vote_Detailed.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_VoteDataContext
            Dim Del = From d In db.Vote_Detailed _
                      Where ID.Contains(d.ID) _
                      Select d
            For Each d In Del
                db.Vote_Detailed.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="AnsID"></param>
    ''' <param name="QuestionID"></param>
    ''' <param name="Answers"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal AnsID As Integer, ByVal QuestionID As Integer, ByVal Answers As String) As Integer
        Using db As New DB_VoteDataContext
            Dim mNewVote_Detailed As New Vote_Detailed With {.AnsID = AnsID, .QuestionID = QuestionID, .Answers = Answers}
            db.Vote_Detailed.InsertOnSubmit(mNewVote_Detailed)
            Try
                db.SubmitChanges()
                Return mNewVote_Detailed.ID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="AnsID"></param>
    ''' <param name="QuestionID"></param>
    ''' <param name="Answers"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal AnsID As Integer, ByVal QuestionID As Integer, ByVal Answers As String) As Integer
        Using db As New DB_VoteDataContext
            Dim UpdateVote_Detailed = (From c In db.Vote_Detailed _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateVote_Detailed) Then
                With UpdateVote_Detailed
                    .AnsID = AnsID
                    .QuestionID = QuestionID
                    .Answers = Answers

                End With

                Try
                    db.SubmitChanges()
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
End Class
