﻿Public Class clsVote_Option
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As Vote_Option
        Using db As New DB_VoteDataContext
            Return (From c In db.Vote_Option _
                    Where c.ID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq(ByVal QuestionID As Integer) As IQueryable(Of Vote_Option)
        Dim db As New DB_VoteDataContext
        Return From c In db.Vote_Option _
               Where c.QuesID = QuestionID _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_VoteDataContext
            Dim Del = (From d In db.Vote_Option _
                      Where d.ID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                db.Vote_Option.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="QuestionID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function DeleteByQuestion(ByVal QuestionID As Integer) As Boolean
        Using db As New DB_VoteDataContext
            Dim Del = From d In db.Vote_Option _
                      Where d.QuesID = QuestionID _
                      Select d
            For Each d In Del
                db.Vote_Option.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_VoteDataContext
            Dim Del = From d In db.Vote_Option _
                      Where ID.Contains(d.ID) _
                      Select d
            For Each d In Del
                db.Vote_Option.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="SubID"></param>
    ''' <param name="QuesID"></param>
    ''' <param name="Title"></param>
    ''' <param name="OptPicture"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal SubID As Integer, ByVal QuesID As Integer, ByVal Title As String, ByVal OptPicture As String) As Integer
        Using db As New DB_VoteDataContext
            Dim mNewVote_Option As New Vote_Option With {.SubID = SubID, .QuesID = QuesID, .OptText = Title, .OptPicture = OptPicture}
            db.Vote_Option.InsertOnSubmit(mNewVote_Option)
            Try
                db.SubmitChanges()
                Return mNewVote_Option.ID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="Title"></param>
    ''' <param name="OptPicture"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal Title As String, ByVal OptPicture As String) As Integer
        Using db As New DB_VoteDataContext
            Dim UpdateVote_Option = (From c In db.Vote_Option _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateVote_Option) Then
                With UpdateVote_Option
                    .OptText = Title
                    .OptPicture = OptPicture
                End With

                Try
                    db.SubmitChanges()
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
End Class
