﻿Public Class clsVote_Question
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As Vote_Question
        Using db As New DB_VoteDataContext
            Return (From c In db.Vote_Question _
                    Where c.ID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq(ByVal SubID As Integer) As IQueryable(Of Vote_Question)
        Dim db As New DB_VoteDataContext
        Return From c In db.Vote_Question _
               Where c.SubID = SubID _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_VoteDataContext
            Dim Del = (From d In db.Vote_Question _
                      Where d.ID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                Dim clsOption As New clsVote_Option
                clsOption.DeleteByQuestion(Del.ID)
                db.Vote_Question.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="SubID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function DeleteBySubjuct(ByVal SubID As Integer) As Boolean
        Using db As New DB_VoteDataContext
            Dim Del = From d In db.Vote_Question _
                      Where d.SubID = SubID _
                      Select d
            Dim clsOption As New clsVote_Option
            For Each d In Del
                clsOption.DeleteByQuestion(d.ID)
                db.Vote_Question.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_VoteDataContext
            Dim Del = From d In db.Vote_Question _
                      Where ID.Contains(d.ID) _
                      Select d
            Dim clsOption As New clsVote_Option
            For Each d In Del
                clsOption.DeleteByQuestion(d.ID)
                db.Vote_Question.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="SubID"></param>
    ''' <param name="VoteType"></param>
    ''' <param name="Integral"></param>
    ''' <param name="Pictrue"></param>
    ''' <param name="Title"></param>
    ''' <param name="RightOptionID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal SubID As Integer, ByVal VoteType As String, ByVal Integral As Integer, ByVal Pictrue As String, ByVal Title As String, ByVal RightOptionID As String) As Integer
        Using db As New DB_VoteDataContext
            Dim mNewVote_Question As New Vote_Question With {.SubID = SubID, .VoteType = VoteType, .Integral = Integral, .Pictrue = Pictrue, .Title = Title, .RightOptionID = RightOptionID}
            db.Vote_Question.InsertOnSubmit(mNewVote_Question)
            Try
                db.SubmitChanges()
                Return mNewVote_Question.ID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="VoteType"></param>
    ''' <param name="Integral"></param>
    ''' <param name="Pictrue"></param>
    ''' <param name="Title"></param>
    ''' <param name="RightOptionID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal VoteType As String, ByVal Integral As Integer, ByVal Pictrue As String, ByVal Title As String, ByVal RightOptionID As String) As Integer
        Using db As New DB_VoteDataContext
            Dim UpdateVote_Question = (From c In db.Vote_Question _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateVote_Question) Then
                With UpdateVote_Question
                    .VoteType = VoteType
                    .Integral = Integral
                    .Pictrue = Pictrue
                    .Title = Title
                    .RightOptionID = RightOptionID

                End With

                Try
                    db.SubmitChanges()
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="RightOptionID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal RightOptionID As String) As Integer
        Using db As New DB_VoteDataContext
            Dim UpdateVote_Question = (From c In db.Vote_Question _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateVote_Question) Then
                With UpdateVote_Question
                    .RightOptionID = RightOptionID
                End With

                Try
                    db.SubmitChanges()
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
End Class
