﻿Public Class clsVote_Subject
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As Vote_Subject
        Using db As New DB_VoteDataContext
            Return (From c In db.Vote_Subject _
                    Where c.ID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq(ByVal SiteID As Integer) As IQueryable(Of Vote_Subject)
        Dim db As New DB_VoteDataContext
        Return From c In db.Vote_Subject _
               Where c.SiteID = SiteID _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_VoteDataContext
            Dim Del = (From d In db.Vote_Subject _
                      Where d.ID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                Dim mclsQuestion As New clsVote_Question
                mclsQuestion.DeleteBySubjuct(Del.ID)
                db.Vote_Subject.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_VoteDataContext
            Dim Del = From d In db.Vote_Subject _
                      Where ID.Contains(d.ID) _
                      Select d
            Dim mclsQuestion As New clsVote_Question
            For Each d In Del
                mclsQuestion.DeleteBySubjuct(d.ID)
                db.Vote_Subject.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="TimeLimt"></param>
    ''' <param name="SiteID"></param>
    ''' <param name="Addtime"></param>
    ''' <param name="FailTime"></param>
    ''' <param name="IsRepeat"></param>
    ''' <param name="IsOpen"></param>
    ''' <param name="Title"></param>
    ''' <param name="SubPictrue"></param>
    ''' <param name="SubNote"></param>
    ''' <param name="CreatUser"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal TimeLimt As Integer, ByVal SiteID As Integer, ByVal Addtime As DateTime, ByVal FailTime As DateTime, ByVal IsRepeat As Boolean, ByVal IsOpen As Boolean, ByVal Title As String, ByVal SubPictrue As String, ByVal SubNote As String, ByVal CreatUser As String) As Integer
        Using db As New DB_VoteDataContext
            Dim mNewVote_Subject As New Vote_Subject With {.TimeLimt = TimeLimt, .SiteID = SiteID, .Addtime = Addtime, .FailTime = FailTime, .IsRepeat = IsRepeat, .IsOpen = IsOpen, .Title = Title, .SubPictrue = SubPictrue, .SubNote = SubNote, .CreatUser = CreatUser}
            db.Vote_Subject.InsertOnSubmit(mNewVote_Subject)
            Try
                db.SubmitChanges()
                Return mNewVote_Subject.ID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="TimeLimt"></param>
    ''' <param name="FailTime"></param>
    ''' <param name="IsRepeat"></param>
    ''' <param name="IsOpen"></param>
    ''' <param name="Title"></param>
    ''' <param name="SubPictrue"></param>
    ''' <param name="SubNote"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal TimeLimt As Integer, ByVal FailTime As DateTime, ByVal IsRepeat As Boolean, ByVal IsOpen As Boolean, ByVal Title As String, ByVal SubPictrue As String, ByVal SubNote As String) As Integer
        Using db As New DB_VoteDataContext
            Dim UpdateVote_Subject = (From c In db.Vote_Subject _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateVote_Subject) Then
                With UpdateVote_Subject
                    .TimeLimt = TimeLimt
                    .FailTime = FailTime
                    .IsRepeat = IsRepeat
                    .IsOpen = IsOpen
                    .Title = Title
                    .SubPictrue = SubPictrue
                    .SubNote = SubNote
                End With

                Try
                    db.SubmitChanges()
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
End Class
