﻿Public Class clsYc_Goods
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As Yc_Goods
        Using db As New DB_GoodsDataContext
            Return (From c In db.Yc_Goods _
                    Where c.ID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq() As IQueryable(Of Yc_Goods)
        Dim db As New DB_GoodsDataContext
        Return From c In db.Yc_Goods _
               Order By c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>DB_GoodsDataContext
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_GoodsDataContext
            Dim Del = (From d In db.Yc_Goods _
                      Where d.ID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                db.Yc_Goods.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_GoodsDataContext
            Dim Del = From d In db.Yc_Goods _
                      Where ID.Contains(d.ID) _
                      Select d
            For Each d In Del
                db.Yc_Goods.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="ClassID"></param>
    ''' <param name="GoodsPoints"></param>
    ''' <param name="GoodsName"></param>
    ''' <param name="GoodsDetail"></param>
    ''' <param name="GoodsPics"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal ClassID As Integer, ByVal GoodsPoints As Integer, ByVal GoodsName As String, ByVal GoodsDetail As String, ByVal GoodsPics As String, ByVal HTMLPics As String) As Integer
        Using db As New DB_GoodsDataContext
            Dim mNewYc_Goods As New Yc_Goods With {.ClassID = ClassID, .GoodsPoints = GoodsPoints, .GoodsName = GoodsName, .GoodsDetail = GoodsDetail, .GoodsPics = GoodsPics, .HTMLPics = HTMLPics}
            db.Yc_Goods.InsertOnSubmit(mNewYc_Goods)
            Try
                db.SubmitChanges()
                Return mNewYc_Goods.ID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="ClassID"></param>
    ''' <param name="GoodsPoints"></param>
    ''' <param name="GoodsName"></param>
    ''' <param name="GoodsDetail"></param>
    ''' <param name="GoodsPics"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal ClassID As Integer, ByVal GoodsPoints As Integer, ByVal GoodsName As String, ByVal GoodsDetail As String, ByVal GoodsPics As String, ByVal HTMLPics As String) As Integer
        Using db As New DB_GoodsDataContext
            Dim UpdateYc_Goods = (From c In db.Yc_Goods _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateYc_Goods) Then
                With UpdateYc_Goods
                    .ClassID = ClassID
                    .GoodsPoints = GoodsPoints
                    .GoodsName = GoodsName
                    .GoodsDetail = GoodsDetail
                    .GoodsPics = GoodsPics
                    .HTMLPics = HTMLPics
                End With

                Try
                    db.SubmitChanges()
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
End Class
