﻿Public Class clsYc_GoodsOrderFrom
    ''' <summary>
    ''' 获取单条记录
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetSingle(ByVal ID As Integer) As Yc_GoodsOrderFrom
        Using db As New DB_GoodsDataContext
            Return (From c In db.Yc_GoodsOrderFrom _
                    Where c.ID = ID _
                    Select c).FirstOrDefault
        End Using
    End Function
    ''' <summary>
    ''' 获取所有记录
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetLinq() As IQueryable(Of Yc_GoodsOrderFrom)
        Dim db As New DB_GoodsDataContext
        Return From c In db.Yc_GoodsOrderFrom _
               Order By c.State Descending, c.ID _
               Select c
    End Function
    ''' <summary>
    ''' 删除单个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID As Integer) As Boolean
        Using db As New DB_GoodsDataContext
            Dim Del = (From d In db.Yc_GoodsOrderFrom _
                      Where d.ID = ID _
                      Select d).FirstOrDefault
            If Not IsNothing(Del) Then
                db.Yc_GoodsOrderFrom.DeleteOnSubmit(Del)
                Try
                    db.SubmitChanges()
                    Return True
                Catch ex As Exception
                    Return False
                End Try
            Else
                Return False
            End If
        End Using
    End Function
    ''' <summary>
    ''' 删除多个实例
    ''' </summary>
    ''' <param name="ID"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Delete(ByVal ID() As Integer) As Boolean
        Using db As New DB_GoodsDataContext
            Dim Del = From d In db.Yc_GoodsOrderFrom _
                      Where ID.Contains(d.ID) _
                      Select d
            For Each d In Del
                db.Yc_GoodsOrderFrom.DeleteOnSubmit(d)
            Next
            Try
                db.SubmitChanges()
                Return True
            Catch ex As Exception
                Return False
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 添加
    ''' </summary>
    ''' <param name="UserID"></param>
    ''' <param name="GoodsID"></param>
    ''' <param name="State"></param>
    ''' <param name="AddTime"></param>
    ''' <param name="UserName"></param>
    ''' <param name="GoodsName"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Insert(ByVal UserID As Integer, ByVal GoodsID As Integer, ByVal State As Integer, ByVal AddTime As DateTime, ByVal UserName As String, ByVal GoodsName As String) As Integer
        Using db As New DB_GoodsDataContext
            Dim mNewYc_GoodsOrderFrom As New Yc_GoodsOrderFrom With {.UserID = UserID, .GoodsID = GoodsID, .State = State, .AddTime = AddTime, .UserName = UserName, .GoodsName = GoodsName}
            db.Yc_GoodsOrderFrom.InsertOnSubmit(mNewYc_GoodsOrderFrom)
            Try
                db.SubmitChanges()
                Return mNewYc_GoodsOrderFrom.ID
            Catch ex As Exception
                Return 0
            End Try
        End Using
    End Function
    ''' <summary>
    ''' 保存
    ''' </summary>
    ''' <param name="UserID"></param>
    ''' <param name="GoodsID"></param>
    ''' <param name="State"></param>
    ''' <param name="AddTime"></param>
    ''' <param name="UserName"></param>
    ''' <param name="GoodsName"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Save(ByVal ID As Integer, ByVal UserID As Integer, ByVal GoodsID As Integer, ByVal State As Integer, ByVal AddTime As DateTime, ByVal UserName As String, ByVal GoodsName As String) As Integer
        Using db As New DB_GoodsDataContext
            Dim UpdateYc_GoodsOrderFrom = (From c In db.Yc_GoodsOrderFrom _
                                       Where c.ID = ID _
                                       Select c).FirstOrDefault
            If Not IsNothing(UpdateYc_GoodsOrderFrom) Then
                With UpdateYc_GoodsOrderFrom
                    .UserID = UserID
                    .GoodsID = GoodsID
                    .State = State
                    .AddTime = AddTime
                    .UserName = UserName
                    .GoodsName = GoodsName

                End With

                Try
                    db.SubmitChanges()
                    Return 1
                Catch ex As Exception
                    Return 0
                End Try
            Else
                Return 0
            End If
        End Using
    End Function
    Public Function SendGoods(ByVal OrderID As Integer) As Boolean
        Using db As New DB_GoodsDataContext
            Dim SendOrder = (From s In db.Yc_GoodsOrderFrom _
                            Where s.ID = OrderID _
                            Select s).FirstOrDefault
            If SendOrder IsNot Nothing Then
                SendOrder.State = 1
                Try
                    db.SubmitChanges()
                    Return True
                Catch ex As Exception
                    Return False
                End Try

            End If
        End Using
    End Function
End Class
