﻿Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Text
Imports System.Web
Imports System.Web.UI
Imports System.Web.UI.WebControls

<Assembly: WebResource("HTMLEditor.Editor.js", "application/x-javascript", PerformSubstitution:=True)> 
<Assembly: WebResource("HTMLEditor.CtlEditor.js", "application/x-javascript", PerformSubstitution:=True)> 
<Assembly: WebResource("HTMLEditor.TagList.htm", "text/html", PerformSubstitution:=True)> 
<Assembly: WebResource("HTMLEditor.Upload.htm", "text/html", PerformSubstitution:=True)> 
<DefaultProperty("EditorHeight"), ToolboxData("<{0}:Editor runat=server></{0}:Editor>")> _
Public Class Editor
    Inherits CompositeControl
    Private HTMLValue As HiddenField
    Private _EdirotHeight As Integer
    Private _SaveButtonName As String
    Private _PlugPath As String
    Private _Simple As Boolean

    Private _PlugUploadPath As String
    Private _VideoEx As String
    Private _PicEx As String
    Private _FlashEx As String
    Private _UploadPath As String
    Private _SubmitButton As String


    Public Property PlugUploadPath() As String
        Get
            Return _PlugUploadPath
        End Get
        Set(ByVal value As String)
            _PlugUploadPath = value
        End Set
    End Property


    Public Property VideoEx() As String
        Get
            Return _VideoEx
        End Get
        Set(ByVal value As String)
            _VideoEx = value
        End Set
    End Property
    
    Public Property PicEx() As String
        Get
            Return _PicEx
        End Get
        Set(ByVal value As String)
            _PicEx = value
        End Set
    End Property
   

    Public Property FlashEx() As String
        Get
            Return _FlashEx
        End Get
        Set(ByVal value As String)
            _FlashEx = value
        End Set
    End Property

    Public Property UploadPath() As String
        Get
            Return _UploadPath
        End Get
        Set(ByVal value As String)
            _UploadPath = value
        End Set
    End Property
    Public Property Simple() As Boolean
        Get
            Return _Simple
        End Get
        Set(ByVal value As Boolean)
            _Simple = value
        End Set
    End Property
    Public Property PlugPath() As String
        Get
            Return _PlugPath
        End Get
        Set(ByVal value As String)
            _PlugPath = value
        End Set
    End Property
    Property EditorHeight() As Integer
        Get
            Return _EdirotHeight
        End Get
        Set(ByVal value As Integer)
            _EdirotHeight = value
        End Set
    End Property
    Property SubmitButton() As String
        Get
            Return _SubmitButton
        End Get
        Set(ByVal value As String)
            _SubmitButton = value
        End Set
    End Property

    Public Function GetHTML() As String
        'Dim mHtml As String = HttpContext.Current.Server.UrlDecode(HTMLValue.Value)
        'If Simple Then
        '    Dim Regbody As New RegularExpressions.Regex("(<body)+[^<>]*>[^0]*(</body>)+")
        '    Return Regbody.Match(mHtml).Value
        'Else
        '    Return mHtml
        'End If
        Return HttpContext.Current.Server.UrlDecode(HTMLValue.Value)
    End Function
    Public Sub SetHTML(ByVal HTML As String)
        EnsureChildControls()
        HTMLValue.Value = HTML
    End Sub
    Protected Overrides Sub RecreateChildControls()
        EnsureChildControls()
    End Sub
    Protected Overrides Sub CreateChildControls()
        Controls.Clear()
        HTMLValue = New HiddenField
        HTMLValue.ID = Me.ID & "_hfValue"
        Controls.Add(HTMLValue)
    End Sub

    Protected Overrides Sub RenderContents(ByVal writer As HtmlTextWriter)
        'AddAttributesToRender(writer)
        HTMLValue.RenderControl(writer)
        Dim EditorID As String = Me.ClientID & "_ifrm"
        Dim CodeID As String = HTMLValue.ClientID
        Dim ContentID As String = Me.ClientID & "_div"
        writer.Write("<div id=""" & ContentID & """></div>")
        writer.Write("<script type=""text/javascript"" language=""javascript"">" & vbCrLf)
        writer.Write(" $(document).ready(function() {" & vbCrLf)
        writer.Write("ControlEditor.EditorID = '" & EditorID & "';" & vbCrLf)
        writer.Write("ControlEditor.CodeID = '" & CodeID & "';" & vbCrLf)
        writer.Write("ControlEditor.ContentID = '" & ContentID & "';" & vbCrLf)
        If EditorHeight < 50 Then EditorHeight = 300
        writer.Write("ControlEditor.EditorHeight = '" & EditorHeight.ToString & "';" & vbCrLf)
        writer.Write("ControlEditor.PlugPath = '" & PlugPath & "';" & vbCrLf)
        writer.Write("ControlEditor.JsPath = '" & Page.ClientScript.GetWebResourceUrl(GetType(Editor), "HTMLEditor.CtlEditor.js") & "';" & vbCrLf)
        If Simple Then
            writer.Write("ControlEditor.Simple = true;" & vbCrLf)
        Else
            writer.Write("ControlEditor.Simple = false;" & vbCrLf)
        End If

        writer.Write("ControlEditor.UploadPagePath = '" & Page.ClientScript.GetWebResourceUrl(GetType(Editor), "HTMLEditor.Upload.htm") & "';" & vbCrLf)
        writer.Write("ControlEditor.PlugUploadPath = '" & PlugUploadPath & "';" & vbCrLf)
        writer.Write("ControlEditor.VideoEx = '" & VideoEx & "';" & vbCrLf)
        writer.Write("ControlEditor.PicEx = '" & PicEx & "';" & vbCrLf)
        writer.Write("ControlEditor.FlashEx = '" & FlashEx & "';" & vbCrLf)
        writer.Write("ControlEditor.UploadPath = '" & UploadPath & "';" & vbCrLf)
        writer.Write("ControlEditor.TagList = '" & Page.ClientScript.GetWebResourceUrl(GetType(Editor), "HTMLEditor.TagList.htm") & "';" & vbCrLf)
        writer.Write("ControlEditor.ButtonName = '" & SubmitButton & "';" & vbCrLf)
        writer.Write("ControlEditor.Init();" & vbCrLf)
        writer.Write(" });" & vbCrLf)
        writer.Write("</script>")
    End Sub
    Protected Overrides Sub OnPreRender(ByVal e As System.EventArgs)
        If Not Page.ClientScript.IsClientScriptIncludeRegistered("jqueryminScript") Then Page.ClientScript.RegisterClientScriptInclude("jqueryminScript", "/App_Themes/ManagerTheme/js/jquery.min.js")
        If Not Page.ClientScript.IsClientScriptIncludeRegistered("Editor") Then Page.ClientScript.RegisterClientScriptResource(GetType(Editor), "HTMLEditor.Editor.js")
        MyBase.OnPreRender(e)
    End Sub

End Class
