﻿Imports System.Web
Imports System.Text
Imports System.Web.Script.Serialization

Public Class clsPlug
   
    Public Sub SecurityModel()
        Dim mGetPlug As New DB_PlugModular.clsPlugUserSecurity
        Dim mUserPara = mGetPlug.GetUserPlugParameter("Admin_Index.aspx", BaseFunction.SiteUser.UserGroupID)
        If mUserPara.Count > 1 Then
            HttpContext.Current.Response.Write(mUserPara.Count)
        Else
            HttpContext.Current.Response.Write("0")
        End If
    End Sub
    Public Sub LoadPlugClass()
        Dim db As New DB_PlugModular.DB_PlugDataContext
        Dim mSiteID As Integer = CType(BaseFunction.PublicMethod.GetApplication("SiteID"), Integer)
        Dim PlugClass As List(Of DB_PlugModular.PlugClass) = XrenCache.XrCache.GetList(db, "PlugClass", DB_PlugModular.clsPlugClass.GetLinq, XrenCache.XrCache.CacheLifeType.File, HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\PlugClass.txt")
        Dim mPlugList As List(Of DB_PlugModular.Plug) = XrenCache.XrCache.GetList(db, "Plug", DB_PlugModular.clsPlug.GetLinq, XrenCache.XrCache.CacheLifeType.File, HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Plug.txt")
        Dim SiteSecurityList As List(Of DB_PlugModular.PlugUserSecurity) = XrenCache.XrCache.GetList(db, "Security" & mSiteID.ToString, DB_PlugModular.clsPlugUserSecurity.GetLinq(mSiteID), XrenCache.XrCache.CacheLifeType.File, HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Security" & mSiteID.ToString & ".txt")
        Dim GroupID As Integer = BaseFunction.SiteUser.UserGroupID
        If GroupID > 0 Then
            Dim mPlugClassID() As Integer = (From p In mPlugList _
                                             Join s In SiteSecurityList On p.ID Equals s.PlugID _
                                             Where s.ParID = 0 And s.GroupID = GroupID _
                                             And p.ShowMenu = True _
                                             Select p.ClassID).ToArray

            Dim iGMenus = (From g In PlugClass _
                          Where g.ClassType = 1 _
                          And mPlugClassID.Contains(g.ClassID) _
                          Order By g.OrderID Ascending _
                          Select g.ClassName, g.ClassID).ToList

            Dim mJson As New JavaScriptSerializer
            HttpContext.Current.Response.Write(mJson.Serialize(iGMenus))
        End If
    End Sub
    Private Function ReadPlugs(ByVal PlugClassID As Integer) As String
        Dim mHtml As New StringBuilder
        Dim mSiteID As Integer = CType(BaseFunction.PublicMethod.GetApplication("SiteID"), Integer)
        Dim db As New DB_PlugModular.DB_PlugDataContext
        Dim mPlugList As List(Of DB_PlugModular.Plug) = XrenCache.XrCache.GetList(db, "Plug", DB_PlugModular.clsPlug.GetLinq, XrenCache.XrCache.CacheLifeType.File, HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Plug.txt", , , , CType(BaseFunction.PublicMethod.GetApplication("SecCache"), Boolean))
        Dim mSiteUserSec As List(Of DB_PlugModular.PlugUserSecurity) = XrenCache.XrCache.GetList(db, "Security" & mSiteID.ToString, DB_PlugModular.clsPlugUserSecurity.GetLinq(mSiteID), XrenCache.XrCache.CacheLifeType.File, HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Security" & mSiteID.ToString & ".txt", , , , CType(BaseFunction.PublicMethod.GetApplication("SecCache"), Boolean))
        Dim mUserSec = (From u In mSiteUserSec _
                        Where u.GroupID = BaseFunction.SiteUser.UserGroupID _
                        Select u.PlugID).ToArray
        Dim mMenuLists = From m In mPlugList _
                         Where m.ClassID = PlugClassID _
                         And m.ShowMenu = True _
                         And m.PageFlag = 1 _
                         And mUserSec.Contains(m.ID) _
                         Order By m.OrderID _
                         Select m.PlugName, m.PageSetFile, m.NewTarget, m.BaseURL
        For Each m In mMenuLists
            mHtml.Append("<div class=""navMenuList"">")
            If m.NewTarget Then
                mHtml.Append("<a onclick=""AddNewFrameTab('/" & m.BaseURL & "/" & m.PageSetFile & "');"">" & m.PlugName & "</a></div>")
            Else
                mHtml.Append("<a href=""/" & m.BaseURL & "/" & m.PageSetFile & """ target=""main_right"">" & m.PlugName & "</a></div>")
            End If
        Next
        Return mHtml.ToString
    End Function
    Public Sub Menu()
        Dim mClassID As Integer
        If Integer.TryParse(HttpContext.Current.Request("ClassID"), mClassID) Then
            Dim db As New DB_PlugModular.DB_PlugDataContext
            Dim PlugClass As List(Of DB_PlugModular.PlugClass) = XrenCache.XrCache.GetList(db, "PlugClass", DB_PlugModular.clsPlugClass.GetLinq, XrenCache.XrCache.CacheLifeType.File, HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\PlugClass.txt", , , , CType(BaseFunction.PublicMethod.GetApplication("SecCache"), Boolean))
            Dim Html As New StringBuilder
            Dim mMenus = (From c In PlugClass _
                         Where c.ClassID = mClassID _
                         Order By c.OrderID _
                         Select c.ClassName, c.ClassID).ToList
            If Not IsNothing(mMenus) AndAlso mMenus.Count > 0 Then
                For Each m In mMenus
                    Html.Append("<div class=""MenuTitle"">" & m.ClassName & "</div>")
                    Html.Append(ReadPlugs(m.ClassID))
                Next
            Else
                Dim mClass = (From c In PlugClass _
                              Where c.ClassID = mClassID _
                              Select c.ClassID, c.ClassName).FirstOrDefault
                If Not IsNothing(mClass) Then
                    Html.Append("<div class=""MenuTitle"">" & mClass.ClassName & "</div>")
                    Html.Append(ReadPlugs(mClass.ClassID))
                End If
            End If
            HttpContext.Current.Response.Write(Html.ToString)
        Else
            HttpContext.Current.Response.Write("参数错误！")
        End If
    End Sub
    Public Sub GetModel()
        Dim OpenModel As Boolean = BaseFunction.PublicMethod.ChangeOpenModel
        If OpenModel Then
            HttpContext.Current.Response.Write("1")
        Else
            HttpContext.Current.Response.Write("0")
        End If
    End Sub
    Public Sub ChangeModel()
        Dim mJson As New JavaScriptSerializer
        Dim OpenModel As Boolean = BaseFunction.PublicMethod.ChangeOpenModel
        If OpenModel Then
            Dim db As New DB_PlugModular.DB_PlugDataContext
            Dim PlugClass As List(Of DB_PlugModular.PlugClass) = XrenCache.XrCache.GetList(db, "PlugClass", DB_PlugModular.clsPlugClass.GetLinq, XrenCache.XrCache.CacheLifeType.File, HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\PlugClass.txt", , , , CType(BaseFunction.PublicMethod.GetApplication("SecCache"), Boolean))
            Dim HTML As New StringBuilder
            Dim mPlugClass = (From p In PlugClass _
                              Where p.ClassType = 1 _
                              Select p.ClassID, p.ClassName).ToList
            HTML.Append(mJson.Serialize(mPlugClass))
            HttpContext.Current.Response.Write(HTML.ToString)
        Else
            HttpContext.Current.Response.Write("0")
        End If
    End Sub
    Public Sub OpenModel()
        Dim mstrPath() As String = HttpContext.Current.Request("PageName").Split("?")
        Dim mVirPath As String = mstrPath(0)
        Dim mPageName As String = IO.Path.GetFileName(mVirPath)
        Dim menName As String = mPageName.Replace(IO.Path.GetExtension(mPageName), "")
        Dim mPlugName As String = HttpUtility.HtmlDecode(HttpContext.Current.Request("PlugName"))
        Dim BaseURL As String = IO.Path.GetDirectoryName(mVirPath).ToLower
        Dim mFilePath As String
        If BaseURL.Length = 0 Then
            mFilePath = Web.HttpContext.Current.Request.PhysicalApplicationPath & "manager\" & mPageName
            mVirPath = "manager/" & HttpContext.Current.Request("PageName")
            BaseURL = "manager"
        Else
            mFilePath = Web.HttpContext.Current.Request.PhysicalApplicationPath & mVirPath
        End If
        If BaseURL.StartsWith("/") Then
            BaseURL = Microsoft.VisualBasic.Right(BaseURL, Len(BaseURL) - 1)
        End If
        Dim mJson As New JavaScriptSerializer
        Dim mDate As iList
        Dim mList As New List(Of iList)
        'If IO.File.Exists(mFilePath) Then
        Dim db As New DB_PlugModular.DB_PlugDataContext
        Dim mPlugList As List(Of DB_PlugModular.Plug) = XrenCache.XrCache.GetList(db, "Plug", DB_PlugModular.clsPlug.GetLinq, XrenCache.XrCache.CacheLifeType.File, HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Plug.txt", , , , CType(BaseFunction.PublicMethod.GetApplication("SecCache"), Boolean))
        Dim mClassID As Integer
        If Integer.TryParse(HttpContext.Current.Request("ClassID"), mClassID) Then
            Dim FindPlug = (From p In mPlugList _
                            Where p.PageSetFile = mPageName _
                            And p.BaseURL = BaseURL _
                            Select p).FirstOrDefault
            If IsNothing(FindPlug) Then
                Dim mPlug As New DB_PlugModular.clsPlug
                Dim MaxOrder = Aggregate p In mPlugList _
                               Where p.ClassID = mClassID _
                               Into m = Max(p.OrderID)
                If MaxOrder Is Nothing Then
                    MaxOrder = 0
                End If
                Dim NewPlugID As Integer = mPlug.Insert(mClassID, 1, MaxOrder + 1, Now, True, False, mPlugName, "", BaseFunction.SiteUser.GetLoginUserName, mPageName, "", "", "usercontrol.gif", BaseURL)
                If NewPlugID > 0 Then
                    Dim mSiteID As Integer = CType(BaseFunction.PublicMethod.GetApplication("SiteID"), Integer)
                    Dim mUserSecurity As New DB_PlugModular.clsPlugUserSecurity
                    Dim SecID As Integer = mUserSecurity.Insert(mSiteID, BaseFunction.SiteUser.UserGroupID, NewPlugID, 0)
                    If SecID > 0 Then
                        mDate = New iList With {.PlugID = NewPlugID, .URL = mVirPath}
                        HttpContext.Current.Response.Write(mJson.Serialize(mDate))
                    Else
                        HttpContext.Current.Response.Write("0")
                    End If
                Else
                    HttpContext.Current.Response.Write("0")
                End If
            Else
                mDate = New iList With {.PlugID = FindPlug.ID, .URL = mVirPath}
                HttpContext.Current.Response.Write(mJson.Serialize(mDate))
            End If

        Else
            HttpContext.Current.Response.Write("0")
        End If
        'Else
        'HttpContext.Current.Response.Write("0")
        'End If
    End Sub
    Public Sub GetParameter()
        Dim HTML As New StringBuilder
        Dim mPlugID As Integer
        If Integer.TryParse(HttpContext.Current.Request("PlugID"), mPlugID) Then
            Dim db As New DB_PlugModular.DB_PlugDataContext
            Dim mParList As List(Of DB_PlugModular.PlugParameter) = XrenCache.XrCache.GetList(db, "PlugParameter", DB_PlugModular.clsPlugParameter.GetLinq, XrenCache.XrCache.CacheLifeType.File, HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\PlugParameter.txt", , , , CType(BaseFunction.PublicMethod.GetApplication("SecCache"), Boolean))
            Dim PlugPar = (From p In mParList _
                           Where p.PlugID = mPlugID _
                           Select p.ParID, p.ParName, p.ParNote).ToList
            HTML.Append("<table cellpadding=""0"" cellspacing=""0"" class=""tbParameter"">")
            HTML.Append("<tr class=""trParameter"" >")
            HTML.Append("<td style=""width: 90px"">参数名称</td>")
            HTML.Append("<td style=""width: 50px"">参数说明</td>")
            HTML.Append("<td style=""text-align:center;"">操作</td>")
            HTML.Append("</tr>")
            For Each p In PlugPar
                HTML.Append("<tr>")
                HTML.Append("<td style=""width: 90px"">" & p.ParName & "</td>")
                HTML.Append("<td style=""width: 50px""><input name=""ParNote"" id=""ParNote" & p.ParID.ToString & """ type=""text"" value=""" & p.ParNote & """ /></td>")
                HTML.Append("<td style=""text-align:center;""><img src=""/App_Themes/ManagerTheme/Images/IsShow.gif"" alt=""保存更改"" onclick=""SaveParameter('" & p.ParID.ToString & "','ParNote" & p.ParID.ToString & "')"" /><img src=""/App_Themes/ManagerTheme/Images/Delete.gif"" alt=""删除"" onclick=""DeleteParameter('" & p.ParID.ToString & "','" & mPlugID.ToString & "')"" /></td>")
                HTML.Append("</tr>")
            Next
            HTML.Append("</table>")
            HttpContext.Current.Response.Write(HTML.ToString)
        Else
            HttpContext.Current.Response.Write("0")
        End If
    End Sub
    Public Sub ChangeParNote()
        Dim mParID As Integer
        Dim mParNote As String = HttpUtility.HtmlDecode(HttpContext.Current.Request("Note"))
        If Integer.TryParse(HttpContext.Current.Request("ParID"), mParID) Then
            Dim mParmeter As New DB_PlugModular.clsPlugParameter
            If mParmeter.ChangeParameterName(mParID, mParNote) Then
                HttpContext.Current.Response.Write("1")
            Else
                HttpContext.Current.Response.Write("0")
            End If
        End If
    End Sub
    Public Sub DeletePar()
        Dim mParID As Integer
        Dim mPlugID As Integer
        If Integer.TryParse(HttpContext.Current.Request("ParID"), mParID) AndAlso Integer.TryParse(HttpContext.Current.Request("PlugID"), mPlugID) Then
            Dim mParmeter As New DB_PlugModular.clsPlugParameter
            If mParmeter.Delete(mParID) Then
                HttpContext.Current.Response.Write("1")
            Else
                HttpContext.Current.Response.Write("0")
            End If
        End If
    End Sub
    Public Sub GetPlug()
        Dim mClassID As Integer
        Dim mSetGroupID As Integer = 0
        Dim mThisGroupID As Integer = BaseFunction.SiteUser.UserGroupID

        If Integer.TryParse(HttpContext.Current.Request("GroupID"), mSetGroupID) Then
            If Integer.TryParse(HttpContext.Current.Request("ClassID"), mClassID) Then
                Dim mSiteID As Integer = CType(BaseFunction.PublicMethod.GetApplication("SiteID"), Integer)
                Dim db As New DB_PlugModular.DB_PlugDataContext
                Dim mPlugList As List(Of DB_PlugModular.Plug) = XrenCache.XrCache.GetList(db, "Plug", DB_PlugModular.clsPlug.GetLinq, XrenCache.XrCache.CacheLifeType.File, HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Plug.txt", , , , CType(BaseFunction.PublicMethod.GetApplication("SecCache"), Boolean))
                Dim mUserSec As List(Of DB_PlugModular.PlugUserSecurity) = XrenCache.XrCache.GetList(db, "Security" & mSiteID.ToString, DB_PlugModular.clsPlugUserSecurity.GetLinq(mSiteID), XrenCache.XrCache.CacheLifeType.File, HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Security" & mSiteID.ToString & ".txt", , , , CType(BaseFunction.PublicMethod.GetApplication("SecCache"), Boolean))
                '读取要设置的用户组权限
                Dim mSetUserSec = (From s In mUserSec _
                                   Where s.ParID = 0 _
                                   And s.GroupID = mSetGroupID _
                                   Select s.PlugID).ToArray
                '读取当前用户的权限
                Dim mThisUserSec = (From s In mUserSec _
                                   Where s.ParID = 0 _
                                   And s.GroupID = mThisGroupID _
                                   Select s.PlugID).ToArray

                '读取当前用户组权限插件
                Dim mThisList = (From p In mPlugList _
                                 Where p.ClassID = mClassID _
                                 And mThisUserSec.Contains(p.ID) _
                                 Select New With {.PlugName = p.PlugName, .ID = p.ID, .Checked = False}).ToList
                
                Dim mList = (From m In mThisList _
                             Let isCheck = mSetUserSec.Contains(m.ID) _
                             Select New With {.PlugName = m.PlugName, .ID = m.ID, .Checked = isCheck}).ToList

                Dim mJson As New JavaScriptSerializer
                HttpContext.Current.Response.Write(mJson.Serialize(mList))
            End If
        End If
    End Sub
    Structure ParType
        Dim ParID As Integer
        Dim ParNote As String
        Dim Checked As Boolean
    End Structure
    Public Sub GetPar()
        Dim mPlugID As Integer
        Dim mSetGroupID As Integer = 0
        Dim mThisGroupID As Integer = BaseFunction.SiteUser.UserGroupID

        If Integer.TryParse(HttpContext.Current.Request("GroupID"), mSetGroupID) Then
            If Integer.TryParse(HttpContext.Current.Request("PlugID"), mPlugID) Then
                Dim mSiteID As Integer = CType(BaseFunction.PublicMethod.GetApplication("SiteID"), Integer)
                Dim db As New DB_PlugModular.DB_PlugDataContext
                Dim mUserSec As List(Of DB_PlugModular.PlugUserSecurity) = XrenCache.XrCache.GetList(db, "Security" & mSiteID.ToString, DB_PlugModular.clsPlugUserSecurity.GetLinq(mSiteID), XrenCache.XrCache.CacheLifeType.File, HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Security" & mSiteID.ToString & ".txt", , , , CType(BaseFunction.PublicMethod.GetApplication("SecCache"), Boolean))
                Dim mParList As List(Of DB_PlugModular.PlugParameter) = XrenCache.XrCache.GetList(db, "PlugParameter", DB_PlugModular.clsPlugParameter.GetLinq, XrenCache.XrCache.CacheLifeType.File, HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\PlugParameter.txt", , , , CType(BaseFunction.PublicMethod.GetApplication("SecCache"), Boolean))
                Dim mJson As New JavaScriptSerializer
                Dim mThisList = (From u In mUserSec _
                                 Join p In mParList On u.ParID Equals p.ParID _
                                 Where p.PlugID = mPlugID _
                                 And u.GroupID = mThisGroupID _
                                 And u.PlugID = mPlugID _
                                 Order By u.ParID _
                                 Select p.ParID, p.ParNote).ToList
                Dim mSetList = (From u In mUserSec _
                                 Join p In mParList On u.ParID Equals p.ParID _
                                 Where p.PlugID = mPlugID _
                                 And u.GroupID = mSetGroupID _
                                 Order By u.ParID _
                                 Select p.ParID).Distinct.ToList
                Dim mList = (From t In mThisList _
                             Let isCheck = mSetList.Contains(t.ParID) _
                             Select New ParType With {.ParID = t.ParID, .ParNote = t.ParNote, .Checked = isCheck}).ToList
                Dim ViewSec = (From v In mUserSec _
                              Where v.ParID = 0 And v.PlugID = mPlugID _
                              And v.GroupID = mSetGroupID _
                              Select v).FirstOrDefault
                If ViewSec IsNot Nothing Then
                    mList.Insert(0, New ParType With {.ParID = 0, .ParNote = "查看", .Checked = True})
                Else
                    mList.Insert(0, New ParType With {.ParID = 0, .ParNote = "查看", .Checked = False})
                End If
                HttpContext.Current.Response.Write(mJson.Serialize(mList))
            End If
        End If
    End Sub
    Public Sub SavePlugSec()
        Dim mPlugID As Integer
        Dim mSetGroupID As Integer
        Dim mChange As Boolean
        Integer.TryParse(HttpContext.Current.Request("PlugID"), mPlugID)
        Boolean.TryParse(HttpContext.Current.Request("Change"), mChange)
        If Integer.TryParse(HttpContext.Current.Request("GroupID"), mSetGroupID) Then
            Dim mUserSecurity As New DB_PlugModular.clsPlugUserSecurity
            If mChange Then
                Dim mSiteID As Integer = CType(BaseFunction.PublicMethod.GetApplication("SiteID"), Integer)
                If mUserSecurity.Insert(mSiteID, mSetGroupID, mPlugID) Then
                    HttpContext.Current.Response.Write("1")
                Else
                    HttpContext.Current.Response.Write("0")
                End If
            Else
                mUserSecurity.DeleteUserPlugSecurity(mPlugID, mSetGroupID)
                HttpContext.Current.Response.Write("1")
            End If
        End If
    End Sub

    Public Sub SaveSec()
        Dim mStrParID As String = HttpContext.Current.Request("ParID")
        Dim mPlugID As Integer
        Dim mParID As Integer
        Dim mChange As Boolean
        Boolean.TryParse(HttpContext.Current.Request("Change"), mChange)
        Integer.TryParse(HttpContext.Current.Request("PlugID"), mPlugID)
        Integer.TryParse(HttpContext.Current.Request("ParID"), mParID)

        Dim mSetGroupID As Integer = 0
        Dim mThisGroupID As Integer = BaseFunction.SiteUser.UserGroupID

        If Integer.TryParse(HttpContext.Current.Request("GroupID"), mSetGroupID) Then
            Dim mSiteID As Integer = CType(BaseFunction.PublicMethod.GetApplication("SiteID"), Integer)
            Dim db As New DB_PlugModular.DB_PlugDataContext
            Dim mUserSec As List(Of DB_PlugModular.PlugUserSecurity) = XrenCache.XrCache.GetList(db, "Security" & mSiteID.ToString, DB_PlugModular.clsPlugUserSecurity.GetLinq(mSiteID), XrenCache.XrCache.CacheLifeType.File, HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\Security" & mSiteID.ToString & ".txt", , , , CType(BaseFunction.PublicMethod.GetApplication("SecCache"), Boolean))
            Dim mUserSecurity As New DB_PlugModular.clsPlugUserSecurity
            If mSetGroupID > 0 And mPlugID > 0 Then
                If mChange Then
                    If mUserSecurity.Insert(mSiteID, mSetGroupID, mPlugID, mParID) > 0 Then
                        HttpContext.Current.Response.Write("1")
                    Else
                        HttpContext.Current.Response.Write("0")
                    End If
                Else
                    mUserSecurity.DeleteUserSecurity(mParID, mSetGroupID)
                    HttpContext.Current.Response.Write("1")
                End If
            Else
                HttpContext.Current.Response.Write("0")
            End If
        End If
    End Sub
End Class
Public Class iList
    Dim _URL As String
    Dim _PlugID As Integer
    Property URL() As String
        Get
            Return _URL
        End Get
        Set(ByVal value As String)
            _URL = value
        End Set
    End Property
    Property PlugID() As Integer
        Get
            Return _PlugID
        End Get
        Set(ByVal value As Integer)
            _PlugID = value
        End Set
    End Property
End Class
