﻿Imports System.Web.Script.Serialization
Imports System.Web

Public Class clsSQL
    Private Structure jsFields
        Dim TableID As Integer
        Dim FieldID As Integer
        Dim FieldName As String
        Dim TableName As String
        Dim PrimaryKey As Boolean
    End Structure
    Public Sub GetSQLClass()
        Dim mSiteID As Integer = CType(BaseFunction.PublicMethod.GetApplication("SiteID"), Integer)
        Dim mJson As New JavaScriptSerializer
        Dim mClasses = (From c In DB_SQL.clsSQLClass.GetLinq(mSiteID) _
                        Select c.ID, c.ClassName).ToList
        HttpContext.Current.Response.Write(mJson.Serialize(mClasses))
    End Sub
    Public Sub GetSQLList()
        Dim mClassID As Integer
        If Integer.TryParse(HttpContext.Current.Request("ClassID"), mClassID) Then
            Dim mSQLList As IQueryable(Of DB_SQL.SQLData)
            If mClassID > 0 Then
                mSQLList = DB_SQL.clsSQLData.GetListOfClass(mClassID)
            Else
                Dim mSiteID As Integer = CType(BaseFunction.PublicMethod.GetApplication("SiteID"), Integer)
                mSQLList = DB_SQL.clsSQLData.GetLinq(mSiteID)
            End If
            Dim mJson As New JavaScriptSerializer
            Dim mList = (From t In mSQLList _
                         Select t.ID, t.SQLName).ToList
            HttpContext.Current.Response.Write(mJson.Serialize(mList))
        End If
    End Sub
    Public Sub GetFieldList()
        Dim mSQLID As Integer
        If Integer.TryParse(HttpContext.Current.Request("SQLID"), mSQLID) Then
            Dim mJson As New JavaScriptSerializer
            Dim mclsSQLDesign As New DB_SQL.clsSQLDesign
            Dim mDesign As DB_SQL.SQLDesign = mclsSQLDesign.GetSingle(mSQLID)
            Dim mFieldList As List(Of jsFields) = mJson.Deserialize(Of List(Of jsFields))(mDesign.hfSelectFields)

            Dim mFieldsID() As Integer = (From f In mFieldList _
                                          Select f.FieldID).ToArray
            Dim mList = (From f In DB_SQL.clsTableFields.GetLinq _
                        Where mFieldsID.Contains(f.ID) _
                        Select f.FieldName, f.FieldNote).ToList

            HttpContext.Current.Response.Write(mJson.Serialize(mList))
        End If
    End Sub
    'Public Sub GetRequestValue()
    '    Dim mSQLID As Integer
    '    If Integer.TryParse(HttpContext.Current.Request("SQLID"), mSQLID) Then
    '        Dim mFieldList = (From f In DB_SQL.clsSQLWhere.GetSQLLinq(mSQLID) _
    '                          Where f.RequestType = 2 _
    '                         Select f.ID, f.DefaultValue, f.WhereField).ToList
    '        Dim mJson As New JavaScriptSerializer
    '        HttpContext.Current.Response.Write(mJson.Serialize(mFieldList))
    '    End If
    'End Sub
    'Public Sub GetSQLLink()
    '    Dim mSQLID As Integer
    '    If Integer.TryParse(HttpContext.Current.Request("SQLID"), mSQLID) Then
    '        Dim mSQLData As New DB_SQL.clsSQLData
    '        Dim mSQL As DB_SQL.SQLData = mSQLData.GetSingle(mSQLID)
    '        If Not IsNothing(mSQL.CreateLink) AndAlso mSQL.CreateLink.Length > 0 Then
    '            HttpContext.Current.Response.Write("<span id='SQLLink'>链接</span>")
    '        Else
    '            HttpContext.Current.Response.Write("")
    '        End If
    '    End If
    'End Sub
End Class
